/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.framework.detection.impl.exclude.old;

import com.intellij.framework.detection.impl.exclude.old.DisabledAutodetectionInModuleElement;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.SortedList;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Tag(value="facet-type")
public class DisabledAutodetectionByTypeElement {
    public static final Comparator<DisabledAutodetectionByTypeElement> COMPARATOR = (o1, o2) -> StringUtil.compare((String)o1.getFacetTypeId(), (String)o2.getFacetTypeId(), (boolean)true);
    private String myFacetTypeId;
    private List<DisabledAutodetectionInModuleElement> myModuleElements = new SortedList(DisabledAutodetectionInModuleElement.COMPARATOR);

    public DisabledAutodetectionByTypeElement() {
    }

    public DisabledAutodetectionByTypeElement(String facetTypeId) {
        this.myFacetTypeId = facetTypeId;
    }

    public DisabledAutodetectionByTypeElement(String facetTypeId, String moduleName) {
        this(facetTypeId);
        this.myModuleElements.add(new DisabledAutodetectionInModuleElement(moduleName));
    }

    public DisabledAutodetectionByTypeElement(String facetTypeId, String moduleName, String url, boolean recursively) {
        this(facetTypeId);
        this.myModuleElements.add(new DisabledAutodetectionInModuleElement(moduleName, url, recursively));
    }

    @Attribute(value="id")
    public String getFacetTypeId() {
        return this.myFacetTypeId;
    }

    @Tag(value="modules")
    @AbstractCollection(surroundWithTag=false)
    public List<DisabledAutodetectionInModuleElement> getModuleElements() {
        return this.myModuleElements;
    }

    public void setFacetTypeId(String facetTypeId) {
        this.myFacetTypeId = facetTypeId;
    }

    public void setModuleElements(List<DisabledAutodetectionInModuleElement> moduleElements) {
        this.myModuleElements = moduleElements;
    }

    public void addDisabled(@NotNull String moduleName) {
        if (moduleName == null) {
            DisabledAutodetectionByTypeElement.$$$reportNull$$$0(0);
        }
        if (this.myModuleElements.isEmpty()) {
            return;
        }
        DisabledAutodetectionInModuleElement element = this.findElement(moduleName);
        if (element != null) {
            element.getFiles().clear();
            element.getDirectories().clear();
            return;
        }
        this.myModuleElements.add(new DisabledAutodetectionInModuleElement(moduleName));
    }

    public void disableInProject() {
        this.myModuleElements.clear();
    }

    public void addDisabled(@NotNull String moduleName, @NotNull String fileUrl, boolean recursively) {
        if (moduleName == null) {
            DisabledAutodetectionByTypeElement.$$$reportNull$$$0(1);
        }
        if (fileUrl == null) {
            DisabledAutodetectionByTypeElement.$$$reportNull$$$0(2);
        }
        if (this.myModuleElements.isEmpty()) {
            return;
        }
        DisabledAutodetectionInModuleElement element = this.findElement(moduleName);
        if (element != null) {
            if (!element.isDisableInWholeModule()) {
                if (recursively) {
                    element.getDirectories().add(fileUrl);
                } else {
                    element.getFiles().add(fileUrl);
                }
            }
            return;
        }
        this.myModuleElements.add(new DisabledAutodetectionInModuleElement(moduleName, fileUrl, recursively));
    }

    @Nullable
    public DisabledAutodetectionInModuleElement findElement(@NotNull String moduleName) {
        if (moduleName == null) {
            DisabledAutodetectionByTypeElement.$$$reportNull$$$0(3);
        }
        for (DisabledAutodetectionInModuleElement element : this.myModuleElements) {
            if (!moduleName.equals(element.getModuleName())) continue;
            return element;
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DisabledAutodetectionByTypeElement that = (DisabledAutodetectionByTypeElement)o;
        return this.myFacetTypeId.equals(that.myFacetTypeId) && this.myModuleElements.equals(that.myModuleElements);
    }

    public int hashCode() {
        return this.myFacetTypeId.hashCode() + 31 * this.myModuleElements.hashCode();
    }

    public boolean isDisabled(String moduleName, String url) {
        if (this.myModuleElements.isEmpty()) {
            return true;
        }
        DisabledAutodetectionInModuleElement element = this.findElement(moduleName);
        if (element == null) {
            return false;
        }
        if (element.isDisableInWholeModule() || element.getFiles().contains(url)) {
            return true;
        }
        for (String directoryUrl : element.getDirectories()) {
            if (!directoryUrl.endsWith("/")) {
                directoryUrl = directoryUrl + "/";
            }
            if (!url.startsWith(directoryUrl) && (SystemInfo.isFileSystemCaseSensitive || !StringUtil.startsWithIgnoreCase((String)url, (String)directoryUrl))) continue;
            return true;
        }
        return false;
    }

    public boolean removeDisabled(String moduleName) {
        Iterator<DisabledAutodetectionInModuleElement> iterator = this.myModuleElements.iterator();
        while (iterator.hasNext()) {
            DisabledAutodetectionInModuleElement element = iterator.next();
            if (!element.getModuleName().equals(moduleName)) continue;
            iterator.remove();
            break;
        }
        return this.myModuleElements.size() > 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileUrl";
                break;
            }
        }
        objectArray2[1] = "com/intellij/framework/detection/impl/exclude/old/DisabledAutodetectionByTypeElement";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addDisabled";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "findElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

