/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.impl;

import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.DataManager;
import com.intellij.ide.impl.ModuleStructureComponent;
import com.intellij.ide.projectView.impl.ProjectRootsUtil;
import com.intellij.ide.structureView.StructureView;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.StructureViewWrapper;
import com.intellij.ide.structureView.impl.StructureViewComposite;
import com.intellij.ide.structureView.newStructureView.StructureViewComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.TimerListener;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.ex.FileEditorProviderManager;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.module.InternalModuleType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.PersistentFSConstants;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.psi.PsiElement;
import com.intellij.ui.components.JBPanelWithEmptyText;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerAdapter;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.util.BitUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StructureViewWrapperImpl
implements StructureViewWrapper,
Disposable {
    private static final DataKey<StructureViewWrapper> WRAPPER_DATA_KEY = DataKey.create((String)"WRAPPER_DATA_KEY");
    private final Project myProject;
    private final ToolWindowEx myToolWindow;
    private VirtualFile myFile;
    private StructureView myStructureView;
    private FileEditor myFileEditor;
    private ModuleStructureComponent myModuleStructureComponent;
    private JPanel[] myPanels = new JPanel[0];
    private final MergingUpdateQueue myUpdateQueue;
    private Runnable myPendingSelection;
    private boolean myFirstRun = true;

    public StructureViewWrapperImpl(Project project, ToolWindowEx toolWindow) {
        this.myProject = project;
        this.myToolWindow = toolWindow;
        this.myUpdateQueue = new MergingUpdateQueue("StructureView", Registry.intValue((String)"structureView.coalesceTime"), false, this.myToolWindow.getComponent(), (Disposable)this, this.myToolWindow.getComponent(), true);
        this.myUpdateQueue.setRestartTimerOnAdd(true);
        final TimerListener timerListener = new TimerListener(){

            public ModalityState getModalityState() {
                return ModalityState.stateForComponent((Component)StructureViewWrapperImpl.this.myToolWindow.getComponent());
            }

            public void run() {
                StructureViewWrapperImpl.this.checkUpdate();
            }
        };
        ActionManager.getInstance().addTimerListener(500, timerListener);
        Disposer.register((Disposable)this, (Disposable)new Disposable(){

            public void dispose() {
                ActionManager.getInstance().removeTimerListener(timerListener);
            }
        });
        this.myToolWindow.getComponent().addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if (BitUtil.isSet((long)e.getChangeFlags(), (long)2L)) {
                    StructureViewWrapperImpl.this.scheduleRebuild();
                }
            }
        });
        this.myToolWindow.getContentManager().addContentManagerListener((ContentManagerListener)new ContentManagerAdapter(){

            public void selectionChanged(ContentManagerEvent event) {
                if (StructureViewWrapperImpl.this.myStructureView instanceof StructureViewComposite) {
                    StructureViewComposite.StructureViewDescriptor[] views;
                    for (StructureViewComposite.StructureViewDescriptor view : views = ((StructureViewComposite)StructureViewWrapperImpl.this.myStructureView).getStructureViews()) {
                        if (!view.title.equals(event.getContent().getTabName())) continue;
                        StructureViewWrapperImpl.this.updateHeaderActions(view.structureView);
                        break;
                    }
                }
            }
        });
        Disposer.register((Disposable)this.myToolWindow.getContentManager(), (Disposable)this);
    }

    private void checkUpdate() {
        FileEditorManagerImpl editorManager;
        List<Pair<VirtualFile, EditorWindow>> history;
        VirtualFile[] files;
        if (this.myProject.isDisposed()) {
            return;
        }
        Component owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        boolean insideToolwindow = SwingUtilities.isDescendingFrom(this.myToolWindow.getComponent(), owner);
        if (!this.myFirstRun && (insideToolwindow || JBPopupFactory.getInstance().isPopupActive())) {
            return;
        }
        DataContext dataContext = DataManager.getInstance().getDataContext(owner);
        if (WRAPPER_DATA_KEY.getData(dataContext) == this) {
            return;
        }
        if (CommonDataKeys.PROJECT.getData(dataContext) != this.myProject) {
            return;
        }
        VirtualFile[] virtualFileArray = files = this.hasFocus() ? null : (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext);
        if (!this.myToolWindow.isVisible()) {
            if (files != null && files.length > 0) {
                this.myFile = files[0];
            }
            return;
        }
        if (files != null && files.length == 1) {
            this.setFile(files[0]);
        } else if (files != null && files.length > 1) {
            this.setFile(null);
        } else if (this.myFirstRun && !(history = (editorManager = (FileEditorManagerImpl)FileEditorManager.getInstance((Project)this.myProject)).getSelectionHistory()).isEmpty()) {
            this.setFile((VirtualFile)history.get(0).getFirst());
        }
        this.myFirstRun = false;
    }

    private boolean hasFocus() {
        JComponent tw = this.myToolWindow.getComponent();
        for (Component owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner(); owner != null; owner = owner.getParent()) {
            if (owner != tw) continue;
            return true;
        }
        return false;
    }

    private void setFile(VirtualFile file2) {
        StructureViewModel model;
        StructureViewTreeElement treeElement;
        Object value;
        boolean forceRebuild;
        boolean bl = forceRebuild = !Comparing.equal((Object)file2, (Object)this.myFile);
        if (!forceRebuild && this.myStructureView != null && ((value = (treeElement = (model = this.myStructureView.getTreeModel()).getRoot()).getValue()) == null || value instanceof PsiElement && !((PsiElement)value).isValid())) {
            forceRebuild = true;
        }
        if (forceRebuild) {
            this.myFile = file2;
            this.scheduleRebuild();
        }
    }

    public void dispose() {
    }

    @Override
    public boolean selectCurrentElement(FileEditor fileEditor, VirtualFile file2, boolean requestFocus) {
        Runnable runnable2 = () -> {
            if (!Comparing.equal((Object)this.myFileEditor, (Object)fileEditor)) {
                this.myFile = file2;
                this.rebuild();
            }
            if (this.myStructureView != null) {
                this.myStructureView.navigateToSelectedElement(requestFocus);
            }
        };
        if (this.isStructureViewShowing()) {
            if (this.myUpdateQueue.isEmpty()) {
                runnable2.run();
            } else {
                this.myPendingSelection = runnable2;
            }
        } else {
            this.myPendingSelection = runnable2;
        }
        return true;
    }

    private void scheduleRebuild() {
        this.myUpdateQueue.queue(new Update("rebuild"){

            public void run() {
                if (StructureViewWrapperImpl.this.myProject.isDisposed()) {
                    return;
                }
                StructureViewWrapperImpl.this.rebuild();
            }
        });
    }

    public void rebuild() {
        VirtualFile[] selectedFiles;
        if (this.myProject.isDisposed()) {
            return;
        }
        Dimension referenceSize = null;
        if (this.myStructureView != null) {
            if (this.myStructureView instanceof StructureView.Scrollable) {
                referenceSize = ((StructureView.Scrollable)this.myStructureView).getCurrentSize();
            }
            this.myStructureView.storeState();
            Disposer.dispose((Disposable)this.myStructureView);
            this.myStructureView = null;
            this.myFileEditor = null;
        }
        if (this.myModuleStructureComponent != null) {
            Disposer.dispose((Disposable)this.myModuleStructureComponent);
            this.myModuleStructureComponent = null;
        }
        ContentManager contentManager = this.myToolWindow.getContentManager();
        contentManager.removeAllContents(true);
        if (!this.isStructureViewShowing()) {
            return;
        }
        VirtualFile file2 = this.myFile;
        if (file2 == null && (selectedFiles = FileEditorManager.getInstance((Project)this.myProject).getSelectedFiles()).length > 0) {
            file2 = selectedFiles[0];
        }
        String[] names = new String[]{""};
        if (file2 != null && file2.isValid()) {
            if (file2.isDirectory()) {
                Module module2;
                if (ProjectRootsUtil.isModuleContentRoot(file2, this.myProject) && (module2 = ModuleUtilCore.findModuleForFile((VirtualFile)file2, (Project)this.myProject)) != null && !(ModuleUtil.getModuleType((Module)module2) instanceof InternalModuleType)) {
                    this.myModuleStructureComponent = new ModuleStructureComponent(module2);
                    this.createSinglePanel(this.myModuleStructureComponent.getComponent());
                    Disposer.register((Disposable)this, (Disposable)this.myModuleStructureComponent);
                }
            } else {
                StructureViewBuilder structureViewBuilder;
                FileEditor editor = FileEditorManager.getInstance((Project)this.myProject).getSelectedEditor(file2);
                boolean needDisposeEditor = false;
                if (editor == null) {
                    editor = this.createTempFileEditor(file2);
                    needDisposeEditor = true;
                }
                if (editor != null && editor.isValid() && (structureViewBuilder = editor.getStructureViewBuilder()) != null) {
                    this.myStructureView = structureViewBuilder.createStructureView(editor, this.myProject);
                    this.myFileEditor = editor;
                    Disposer.register((Disposable)this, (Disposable)this.myStructureView);
                    this.updateHeaderActions(this.myStructureView);
                    if (this.myStructureView instanceof StructureView.Scrollable) {
                        ((StructureView.Scrollable)this.myStructureView).setReferenceSizeWhileInitializing(referenceSize);
                    }
                    if (this.myStructureView instanceof StructureViewComposite) {
                        StructureViewComposite composite = (StructureViewComposite)this.myStructureView;
                        StructureViewComposite.StructureViewDescriptor[] views = composite.getStructureViews();
                        this.myPanels = new JPanel[views.length];
                        names = new String[views.length];
                        for (int i = 0; i < this.myPanels.length; ++i) {
                            this.myPanels[i] = this.createContentPanel(views[i].structureView.getComponent());
                            names[i] = views[i].title;
                        }
                    } else {
                        this.createSinglePanel(this.myStructureView.getComponent());
                    }
                    this.myStructureView.restoreState();
                    this.myStructureView.centerSelectedRow();
                }
                if (needDisposeEditor && editor != null) {
                    Disposer.dispose((Disposable)editor);
                }
            }
        }
        if (this.myModuleStructureComponent == null && this.myStructureView == null) {
            JBPanelWithEmptyText panel2 = new JBPanelWithEmptyText(){

                public Color getBackground() {
                    return UIUtil.getTreeBackground();
                }
            };
            panel2.getEmptyText().setText("No structure");
            this.createSinglePanel((JComponent)panel2);
        }
        for (int i = 0; i < this.myPanels.length; ++i) {
            Content content = ContentFactory.SERVICE.getInstance().createContent((JComponent)this.myPanels[i], names[i], false);
            contentManager.addContent(content);
            if (i != 0 || this.myStructureView == null) continue;
            Disposer.register((Disposable)content, (Disposable)this.myStructureView);
        }
        if (this.myPendingSelection != null) {
            Runnable selection = this.myPendingSelection;
            this.myPendingSelection = null;
            selection.run();
        }
    }

    private void updateHeaderActions(StructureView structureView) {
        AnAction[] titleActions = AnAction.EMPTY_ARRAY;
        if (structureView instanceof StructureViewComponent) {
            JTree tree = ((StructureViewComponent)structureView).getTree();
            titleActions = new AnAction[]{CommonActionsManager.getInstance().createExpandAllHeaderAction(tree), CommonActionsManager.getInstance().createCollapseAllHeaderAction(tree)};
        }
        this.myToolWindow.setTitleActions(titleActions);
    }

    private void createSinglePanel(JComponent component) {
        this.myPanels = new JPanel[1];
        this.myPanels[0] = this.createContentPanel(component);
    }

    private ContentPanel createContentPanel(JComponent component) {
        ContentPanel panel2 = new ContentPanel();
        panel2.setBackground(UIUtil.getTreeTextBackground());
        panel2.add((Component)component, "Center");
        return panel2;
    }

    @Nullable
    private FileEditor createTempFileEditor(@NotNull VirtualFile file2) {
        if (file2 == null) {
            StructureViewWrapperImpl.$$$reportNull$$$0(0);
        }
        if (file2.getLength() > (long)PersistentFSConstants.getMaxIntellisenseFileSize()) {
            return null;
        }
        FileEditorProviderManager editorProviderManager = FileEditorProviderManager.getInstance();
        FileEditorProvider[] providers = editorProviderManager.getProviders(this.myProject, file2);
        return providers.length == 0 ? null : providers[0].createEditor(this.myProject, file2);
    }

    protected boolean isStructureViewShowing() {
        ToolWindowManager windowManager = ToolWindowManager.getInstance((Project)this.myProject);
        ToolWindow toolWindow = windowManager.getToolWindow(ToolWindowId.STRUCTURE_VIEW);
        return toolWindow != null && toolWindow.isVisible();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/impl/StructureViewWrapperImpl", "createTempFileEditor"));
    }

    private class ContentPanel
    extends JPanel
    implements DataProvider {
        public ContentPanel() {
            super(new BorderLayout());
        }

        public Object getData(@NonNls String dataId) {
            if (WRAPPER_DATA_KEY.is(dataId)) {
                return StructureViewWrapperImpl.this;
            }
            return null;
        }
    }
}

