/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.passwordSafe.impl.providers;

import com.intellij.credentialStore.CredentialAttributes;
import com.intellij.credentialStore.Credentials;
import com.intellij.credentialStore.OneTimeString;
import com.intellij.ide.passwordSafe.PasswordStorage;
import com.intellij.ide.passwordSafe.impl.providers.EncryptionUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BasePasswordSafeProvider
implements PasswordStorage {
    @NotNull
    protected abstract byte[] key();

    @Nullable
    public Credentials get(@NotNull CredentialAttributes attributes) {
        byte[] masterKey;
        byte[] encryptedPassword;
        if (attributes == null) {
            BasePasswordSafeProvider.$$$reportNull$$$0(0);
        }
        OneTimeString password = (encryptedPassword = this.getEncryptedPassword(EncryptionUtil.encryptKey(masterKey = this.key(), EncryptionUtil.rawKey(attributes)))) == null ? null : EncryptionUtil.decryptText(masterKey, encryptedPassword);
        return password == null ? null : new Credentials(attributes.getUserName(), password);
    }

    protected abstract byte[] getEncryptedPassword(@NotNull byte[] var1);

    protected abstract void removeEncryptedPassword(byte[] var1);

    public final void set(@NotNull CredentialAttributes attributes, @Nullable Credentials value) {
        if (attributes == null) {
            BasePasswordSafeProvider.$$$reportNull$$$0(1);
        }
        byte[] key = EncryptionUtil.encryptKey(this.key(), EncryptionUtil.rawKey(attributes));
        if (value == null || value.getPassword() == null) {
            this.removeEncryptedPassword(key);
        } else {
            this.storeEncryptedPassword(key, EncryptionUtil.encryptText(this.key(), value.getPassword()));
        }
    }

    protected abstract void storeEncryptedPassword(byte[] var1, byte[] var2);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "attributes";
        objectArray2[1] = "com/intellij/ide/passwordSafe/impl/providers/BasePasswordSafeProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "get";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "set";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

