/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.intellij;

import com.intellij.ide.ui.laf.darcula.DarculaUIUtil;
import com.intellij.ide.ui.laf.intellij.WinIntelliJTextBorder;
import com.intellij.ide.ui.laf.intellij.WinIntelliJTextFieldUI;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.JPasswordField;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicPasswordFieldUI;
import javax.swing.text.JTextComponent;

public class WinIntelliJPasswordFieldUI
extends BasicPasswordFieldUI {
    private final JPasswordField passwordField;
    private MouseListener hoverListener;
    private FocusListener focusListener;

    public WinIntelliJPasswordFieldUI(JPasswordField passwordField) {
        this.passwordField = passwordField;
    }

    public static ComponentUI createUI(JComponent c) {
        return new WinIntelliJPasswordFieldUI((JPasswordField)c);
    }

    @Override
    public void installListeners() {
        super.installListeners();
        this.hoverListener = new DarculaUIUtil.MouseHoverPropertyTrigger(this.passwordField, "JTextField.hover");
        this.focusListener = new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                WinIntelliJPasswordFieldUI.this.passwordField.repaint();
            }

            @Override
            public void focusLost(FocusEvent e) {
                WinIntelliJPasswordFieldUI.this.passwordField.repaint();
            }
        };
        this.passwordField.addMouseListener(this.hoverListener);
        this.passwordField.addFocusListener(this.focusListener);
    }

    @Override
    public void uninstallListeners() {
        super.uninstallListeners();
        if (this.hoverListener != null) {
            this.passwordField.removeMouseListener(this.hoverListener);
        }
        if (this.focusListener != null) {
            this.passwordField.removeFocusListener(this.focusListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintBackground(Graphics g) {
        JTextComponent c = this.getComponent();
        Graphics2D g2 = (Graphics2D)g.create();
        try {
            Container parent = c.getParent();
            if (c.isOpaque() && parent != null) {
                g2.setColor(parent.getBackground());
                g2.fillRect(0, 0, c.getWidth(), c.getHeight());
            }
            if (c.getBorder() instanceof WinIntelliJTextBorder) {
                WinIntelliJTextFieldUI.paintTextFieldBackground(c, g2);
            }
        }
        finally {
            g2.dispose();
        }
    }
}

