/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.actions;

import com.intellij.diff.DiffManager;
import com.intellij.diff.DiffRequestFactory;
import com.intellij.diff.InvalidDiffRequestException;
import com.intellij.diff.merge.MergeRequest;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;

public class MergeFilesAction
extends AnAction
implements DumbAware {
    public void update(AnActionEvent e) {
        DataContext context = e.getDataContext();
        Project project = (Project)CommonDataKeys.PROJECT.getData(context);
        if (project == null) {
            e.getPresentation().setEnabled(false);
            return;
        }
        VirtualFile[] files = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(context);
        if (files == null || files.length != 3) {
            e.getPresentation().setEnabled(false);
        }
    }

    public void actionPerformed(AnActionEvent e) {
        DataContext context = e.getDataContext();
        VirtualFile[] files = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(context);
        if (files == null || files.length != 3) {
            return;
        }
        DiffRequestFactory diffRequestFactory = DiffRequestFactory.getInstance();
        try {
            Project project = (Project)CommonDataKeys.PROJECT.getData(context);
            String title = DiffBundle.message((String)"merge.files.dialog.title", (Object[])new Object[0]);
            List titles = ContainerUtil.list((Object[])new String[]{files[0].getPresentableUrl(), files[1].getPresentableUrl(), files[2].getPresentableUrl()});
            VirtualFile outputFile = files[1];
            List contents = ContainerUtil.list((Object[])new VirtualFile[]{files[0], files[1], files[2]});
            MergeRequest request = diffRequestFactory.createMergeRequestFromFiles(project, outputFile, contents, title, titles, null);
            request.putUserData(DiffUserDataKeys.HELP_ID, (Object)"cvs.merge");
            DiffManager.getInstance().showMerge(project, request);
        }
        catch (InvalidDiffRequestException err) {
            Messages.showErrorDialog((String)err.getLocalizedMessage(), (String)DiffBundle.message((String)"merge.files.dialog.title", (Object[])new Object[0]));
        }
    }
}

