/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.ex;

import com.intellij.diff.util.DiffUtil;
import com.intellij.ide.GeneralSettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.markup.MarkupEditorFilterFactory;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.ex.LineStatusMarkerPopup;
import com.intellij.openapi.vcs.ex.LineStatusMarkerRenderer;
import com.intellij.openapi.vcs.ex.LineStatusTrackerBase;
import com.intellij.openapi.vcs.ex.LineStatusTrackerDrawing;
import com.intellij.openapi.vcs.ex.Range;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.util.Function;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class LineStatusTracker
extends LineStatusTrackerBase {
    private static final Key<JPanel> PANEL_KEY = new Key("LineStatusTracker.CanNotCalculateDiffPanel");
    @NotNull
    private final VirtualFile myVirtualFile;
    @NotNull
    private final FileEditorManager myFileEditorManager;
    @NotNull
    private final VcsDirtyScopeManager myVcsDirtyScopeManager;
    @NotNull
    private Mode myMode;

    private LineStatusTracker(@NotNull Project project, @NotNull Document document, @NotNull VirtualFile virtualFile, @NotNull Mode mode) {
        if (project == null) {
            LineStatusTracker.$$$reportNull$$$0(0);
        }
        if (document == null) {
            LineStatusTracker.$$$reportNull$$$0(1);
        }
        if (virtualFile == null) {
            LineStatusTracker.$$$reportNull$$$0(2);
        }
        if (mode == null) {
            LineStatusTracker.$$$reportNull$$$0(3);
        }
        super(project, document);
        this.myVirtualFile = virtualFile;
        this.myMode = mode;
        this.myFileEditorManager = FileEditorManager.getInstance((Project)project);
        this.myVcsDirtyScopeManager = VcsDirtyScopeManager.getInstance((Project)project);
    }

    public static LineStatusTracker createOn(@NotNull VirtualFile virtualFile, @NotNull Document document, @NotNull Project project, @NotNull Mode mode) {
        if (virtualFile == null) {
            LineStatusTracker.$$$reportNull$$$0(4);
        }
        if (document == null) {
            LineStatusTracker.$$$reportNull$$$0(5);
        }
        if (project == null) {
            LineStatusTracker.$$$reportNull$$$0(6);
        }
        if (mode == null) {
            LineStatusTracker.$$$reportNull$$$0(7);
        }
        return new LineStatusTracker(project, document, virtualFile, mode);
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = super.getProject();
        if (project == null) {
            LineStatusTracker.$$$reportNull$$$0(8);
        }
        return project;
    }

    @Override
    @NotNull
    public VirtualFile getVirtualFile() {
        VirtualFile virtualFile = this.myVirtualFile;
        if (virtualFile == null) {
            LineStatusTracker.$$$reportNull$$$0(9);
        }
        return virtualFile;
    }

    @NotNull
    public Mode getMode() {
        Mode mode = this.myMode;
        if (mode == null) {
            LineStatusTracker.$$$reportNull$$$0(10);
        }
        return mode;
    }

    public boolean isAvailableAt(@NotNull Editor editor) {
        if (editor == null) {
            LineStatusTracker.$$$reportNull$$$0(11);
        }
        return this.myMode != Mode.SILENT && editor.getSettings().isLineMarkerAreaShown() && !DiffUtil.isDiffEditor(editor);
    }

    public void setMode(@NotNull Mode mode) {
        if (mode == null) {
            LineStatusTracker.$$$reportNull$$$0(12);
        }
        if (this.myMode == mode) {
            return;
        }
        this.myMode = mode;
        this.reinstallRanges();
    }

    @Override
    protected boolean isDetectWhitespaceChangedLines() {
        return this.myMode == Mode.SMART;
    }

    @Override
    protected void installNotification(@NotNull String text) {
        FileEditor[] editors;
        if (text == null) {
            LineStatusTracker.$$$reportNull$$$0(13);
        }
        for (FileEditor editor : editors = this.myFileEditorManager.getAllEditors(this.myVirtualFile)) {
            JPanel panel2 = (JPanel)editor.getUserData(PANEL_KEY);
            if (panel2 != null) continue;
            EditorNotificationPanel newPanel = new EditorNotificationPanel().text(text);
            editor.putUserData(PANEL_KEY, (Object)newPanel);
            this.myFileEditorManager.addTopComponent(editor, (JComponent)newPanel);
        }
    }

    @Override
    protected void destroyNotification() {
        FileEditor[] editors;
        for (FileEditor editor : editors = this.myFileEditorManager.getEditors(this.myVirtualFile)) {
            JPanel panel2 = (JPanel)editor.getUserData(PANEL_KEY);
            if (panel2 == null) continue;
            this.myFileEditorManager.removeTopComponent(editor, (JComponent)panel2);
            editor.putUserData(PANEL_KEY, null);
        }
    }

    @Override
    protected void createHighlighter(@NotNull Range range) {
        if (range == null) {
            LineStatusTracker.$$$reportNull$$$0(14);
        }
        this.myApplication.assertIsDispatchThread();
        if (range.getHighlighter() != null) {
            LOG.error("Multiple highlighters registered for the same Range");
            return;
        }
        if (this.myMode == Mode.SILENT) {
            return;
        }
        int first = range.getLine1() >= DiffUtil.getLineCount(this.myDocument) ? this.myDocument.getTextLength() : this.myDocument.getLineStartOffset(range.getLine1());
        int second = range.getLine2() >= DiffUtil.getLineCount(this.myDocument) ? this.myDocument.getTextLength() : this.myDocument.getLineStartOffset(range.getLine2());
        MarkupModel markupModel = DocumentMarkupModel.forDocument(this.myDocument, this.myProject, true);
        RangeHighlighter highlighter = LineStatusMarkerRenderer.createRangeHighlighter(range, new TextRange(first, second), markupModel);
        highlighter.setLineMarkerRenderer(LineStatusMarkerRenderer.createRenderer(range, (Function<Editor, LineStatusMarkerPopup>)((Function)editor -> {
            if (range == null) {
                LineStatusTracker.$$$reportNull$$$0(16);
            }
            return new LineStatusTrackerDrawing.MyLineStatusMarkerPopup(this, (Editor)editor, range);
        })));
        highlighter.setEditorFilter(MarkupEditorFilterFactory.createIsNotDiffFilter());
        range.setHighlighter(highlighter);
    }

    @Override
    protected void fireFileUnchanged() {
        if (GeneralSettings.getInstance().isSaveOnFrameDeactivation()) {
            TransactionGuard.getInstance().submitTransactionLater((Disposable)this.getProject(), () -> {
                FileDocumentManager.getInstance().saveDocument(this.myDocument);
                List<Range> ranges = this.getRanges();
                if (ranges == null || ranges.isEmpty()) {
                    this.myVcsDirtyScopeManager.fileDirty(this.myVirtualFile);
                }
            });
        }
    }

    @Override
    protected void doRollbackRange(@NotNull Range range) {
        if (range == null) {
            LineStatusTracker.$$$reportNull$$$0(15);
        }
        super.doRollbackRange(range);
        this.markLinesUnchanged(range.getLine1(), range.getLine1() + range.getVcsLine2() - range.getVcsLine1());
    }

    private void markLinesUnchanged(int startLine, int endLine) {
        if (this.myDocument.getTextLength() == 0) {
            return;
        }
        if (startLine == endLine) {
            return;
        }
        ((DocumentImpl)this.myDocument).clearLineModificationFlags(startLine, endLine);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 3: 
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/ex/LineStatusTracker";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/ex/LineStatusTracker";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getVirtualFile";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getMode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createOn";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isAvailableAt";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setMode";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "installNotification";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createHighlighter";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "doRollbackRange";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createHighlighter$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum Mode {
        DEFAULT,
        SMART,
        SILENT;

    }
}

