/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.project.model.impl.module;

import com.intellij.project.model.impl.module.JpsRootModel;
import com.intellij.project.model.impl.module.dependencies.JpsInheritedSdkOrderEntry;
import com.intellij.project.model.impl.module.dependencies.JpsLibraryOrderEntry;
import com.intellij.project.model.impl.module.dependencies.JpsModuleOrderEntry;
import com.intellij.project.model.impl.module.dependencies.JpsModuleSdkOrderEntry;
import com.intellij.project.model.impl.module.dependencies.JpsModuleSourceOrderEntry;
import com.intellij.project.model.impl.module.dependencies.JpsOrderEntry;
import org.jetbrains.jps.model.module.JpsDependencyElement;
import org.jetbrains.jps.model.module.JpsLibraryDependency;
import org.jetbrains.jps.model.module.JpsModuleDependency;
import org.jetbrains.jps.model.module.JpsModuleSourceDependency;
import org.jetbrains.jps.model.module.JpsSdkDependency;

public class JpsOrderEntryFactory {
    public static JpsOrderEntry<?> createOrderEntry(JpsRootModel model, JpsDependencyElement dependencyElement) {
        if (dependencyElement instanceof JpsModuleSourceDependency) {
            return new JpsModuleSourceOrderEntry(model, (JpsModuleSourceDependency)dependencyElement);
        }
        if (dependencyElement instanceof JpsModuleDependency) {
            return new JpsModuleOrderEntry(model, (JpsModuleDependency)dependencyElement);
        }
        if (dependencyElement instanceof JpsLibraryDependency) {
            return new JpsLibraryOrderEntry(model, (JpsLibraryDependency)dependencyElement);
        }
        if (dependencyElement instanceof JpsSdkDependency) {
            JpsSdkDependency sdkDependency = (JpsSdkDependency)dependencyElement;
            if (sdkDependency.isInherited()) {
                return new JpsInheritedSdkOrderEntry(model, sdkDependency);
            }
            return new JpsModuleSdkOrderEntry(model, sdkDependency);
        }
        throw new UnsupportedOperationException();
    }
}

