/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter;

import com.intellij.lang.Language;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.formatter.CompositeWhiteSpaceFormattingStrategy;
import com.intellij.psi.formatter.LanguageWhiteSpaceFormattingStrategy;
import com.intellij.psi.formatter.StaticSymbolWhiteSpaceDefinitionStrategy;
import com.intellij.psi.formatter.WhiteSpaceFormattingStrategy;
import com.intellij.reference.SoftReference;
import com.intellij.util.PatchedWeakReference;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;

public class WhiteSpaceFormattingStrategyFactory {
    private static final List<WhiteSpaceFormattingStrategy> SHARED_STRATEGIES = Arrays.asList(new StaticSymbolWhiteSpaceDefinitionStrategy(' ', '\t', '\n'));
    private static final AtomicReference<PatchedWeakReference<Collection<WhiteSpaceFormattingStrategy>>> myCachedStrategies = new AtomicReference();

    private WhiteSpaceFormattingStrategyFactory() {
    }

    public static WhiteSpaceFormattingStrategy getStrategy() {
        return new CompositeWhiteSpaceFormattingStrategy(SHARED_STRATEGIES);
    }

    public static WhiteSpaceFormattingStrategy getStrategy(@NotNull Language language) throws IllegalStateException {
        if (language == null) {
            WhiteSpaceFormattingStrategyFactory.$$$reportNull$$$0(0);
        }
        CompositeWhiteSpaceFormattingStrategy result2 = new CompositeWhiteSpaceFormattingStrategy(SHARED_STRATEGIES);
        WhiteSpaceFormattingStrategy strategy = (WhiteSpaceFormattingStrategy)LanguageWhiteSpaceFormattingStrategy.INSTANCE.forLanguage(language);
        if (strategy != null) {
            result2.addStrategy(strategy);
        }
        return result2;
    }

    @NotNull
    public static Collection<WhiteSpaceFormattingStrategy> getAllStrategies() {
        WeakReference reference = myCachedStrategies.get();
        Collection strategies = (Collection)SoftReference.dereference((Reference)reference);
        if (strategies != null) {
            Collection collection = strategies;
            if (collection == null) {
                WhiteSpaceFormattingStrategyFactory.$$$reportNull$$$0(1);
            }
            return collection;
        }
        Collection languages = Language.getRegisteredLanguages();
        if (languages == null) {
            List<WhiteSpaceFormattingStrategy> result2 = Collections.emptyList();
            myCachedStrategies.set(new PatchedWeakReference(result2));
            List<WhiteSpaceFormattingStrategy> list2 = result2;
            if (list2 == null) {
                WhiteSpaceFormattingStrategyFactory.$$$reportNull$$$0(2);
            }
            return list2;
        }
        HashSet<WhiteSpaceFormattingStrategy> result3 = new HashSet<WhiteSpaceFormattingStrategy>(SHARED_STRATEGIES);
        LanguageWhiteSpaceFormattingStrategy languageStrategy = LanguageWhiteSpaceFormattingStrategy.INSTANCE;
        for (Language language : languages) {
            WhiteSpaceFormattingStrategy strategy = (WhiteSpaceFormattingStrategy)languageStrategy.forLanguage(language);
            if (strategy == null) continue;
            result3.add(strategy);
        }
        myCachedStrategies.set(new PatchedWeakReference<HashSet<WhiteSpaceFormattingStrategy>>(result3));
        HashSet<WhiteSpaceFormattingStrategy> hashSet = result3;
        if (hashSet == null) {
            WhiteSpaceFormattingStrategyFactory.$$$reportNull$$$0(3);
        }
        return hashSet;
    }

    public static WhiteSpaceFormattingStrategy getStrategy(@NotNull Editor editor) throws IllegalStateException {
        PsiFile psiFile;
        Project project;
        if (editor == null) {
            WhiteSpaceFormattingStrategyFactory.$$$reportNull$$$0(4);
        }
        if ((project = editor.getProject()) != null && (psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument())) != null) {
            return WhiteSpaceFormattingStrategyFactory.getStrategy(psiFile.getLanguage());
        }
        return WhiteSpaceFormattingStrategyFactory.getStrategy();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/formatter/WhiteSpaceFormattingStrategyFactory";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/formatter/WhiteSpaceFormattingStrategyFactory";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllStrategies";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getStrategy";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

