/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.injected;

import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageManagerImpl;
import com.intellij.psi.impl.source.tree.injected.MultiHostRegistrarImpl;
import com.intellij.psi.impl.source.tree.injected.Place;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.util.PsiModificationTracker;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class InjectedPsiCachedValueProvider
implements ParameterizedCachedValueProvider<MultiHostRegistrarImpl, PsiElement> {
    InjectedPsiCachedValueProvider() {
    }

    public CachedValueProvider.Result<MultiHostRegistrarImpl> compute(PsiElement element) {
        PsiFile hostPsiFile = element.getContainingFile();
        if (hostPsiFile == null) {
            return null;
        }
        FileViewProvider viewProvider = hostPsiFile.getViewProvider();
        DocumentEx hostDocument = (DocumentEx)viewProvider.getDocument();
        if (hostDocument == null) {
            return null;
        }
        PsiManager psiManager = viewProvider.getManager();
        Project project = psiManager.getProject();
        InjectedLanguageManagerImpl injectedManager = InjectedLanguageManagerImpl.getInstanceImpl(project);
        MultiHostRegistrarImpl result2 = InjectedPsiCachedValueProvider.doCompute(element, injectedManager, project, hostPsiFile);
        return CachedValueProvider.Result.create((Object)result2, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT, hostDocument});
    }

    @Nullable
    static MultiHostRegistrarImpl doCompute(@NotNull PsiElement element, @NotNull InjectedLanguageManagerImpl injectedManager, Project project, PsiFile hostPsiFile) {
        if (element == null) {
            InjectedPsiCachedValueProvider.$$$reportNull$$$0(0);
        }
        if (injectedManager == null) {
            InjectedPsiCachedValueProvider.$$$reportNull$$$0(1);
        }
        MyInjProcessor processor2 = new MyInjProcessor(project, hostPsiFile);
        injectedManager.processInPlaceInjectorsFor(element, processor2);
        MultiHostRegistrarImpl registrar = processor2.hostRegistrar;
        return registrar == null || registrar.getResult() == null ? null : registrar;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "injectedManager";
                break;
            }
        }
        objectArray[1] = "com/intellij/psi/impl/source/tree/injected/InjectedPsiCachedValueProvider";
        objectArray[2] = "doCompute";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyInjProcessor
    implements InjectedLanguageManagerImpl.InjProcessor {
        private MultiHostRegistrarImpl hostRegistrar;
        private final Project myProject;
        private final PsiFile myHostPsiFile;

        private MyInjProcessor(Project project, PsiFile hostPsiFile) {
            this.myProject = project;
            this.myHostPsiFile = hostPsiFile;
        }

        @Override
        public boolean process(@NotNull PsiElement element, @NotNull MultiHostInjector injector) {
            if (element == null) {
                MyInjProcessor.$$$reportNull$$$0(0);
            }
            if (injector == null) {
                MyInjProcessor.$$$reportNull$$$0(1);
            }
            if (this.hostRegistrar == null) {
                this.hostRegistrar = new MultiHostRegistrarImpl(this.myProject, this.myHostPsiFile, element);
            }
            injector.getLanguagesToInject((MultiHostRegistrar)this.hostRegistrar, element);
            List<Pair<Place, PsiFile>> result2 = this.hostRegistrar.getResult();
            return result2 == null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "injector";
                    break;
                }
            }
            objectArray[1] = "com/intellij/psi/impl/source/tree/injected/InjectedPsiCachedValueProvider$MyInjProcessor";
            objectArray[2] = "process";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

