/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.statistics.impl;

import com.intellij.openapi.util.io.DataInputOutputUtilRt;
import com.intellij.psi.statistics.impl.WrongFormatException;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ObjectIntHashMap;
import com.intellij.util.io.IOUtil;
import gnu.trove.THashMap;
import gnu.trove.TObjectIntHashMap;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

class StatisticsUnit {
    private static final int FORMAT_VERSION_NUMBER = 6;
    private final int myNumber;
    private final Map<String, LinkedList<String>> myDataMap = new THashMap();
    private final TObjectIntHashMap<String> myContextMaxStamps = new TObjectIntHashMap();
    private final Map<String, TObjectIntHashMap<String>> myValueStamps = new THashMap();

    StatisticsUnit(int number) {
        this.myNumber = number;
    }

    int getRecency(String context, String value) {
        int stamp;
        TObjectIntHashMap<String> perContext = this.myValueStamps.get(context);
        int n = stamp = perContext == null ? -1 : perContext.get((Object)value);
        if (stamp < 0) {
            return Integer.MAX_VALUE;
        }
        int diff = this.myContextMaxStamps.get((Object)context) - stamp;
        return diff >= 10000 ? Integer.MAX_VALUE : diff;
    }

    public int getData(String key1, String key2) {
        List list2 = this.myDataMap.get(key1);
        if (list2 == null) {
            return 0;
        }
        int result2 = 0;
        for (String s : list2) {
            if (!s.equals(key2)) continue;
            ++result2;
        }
        return result2;
    }

    public void incData(String key1, String key2) {
        LinkedList<String> list2 = this.myDataMap.get(key1);
        if (list2 == null) {
            list2 = new LinkedList();
            this.myDataMap.put(key1, list2);
        }
        list2.addFirst(key2);
        if (list2.size() > 7) {
            list2.removeLast();
        }
        this.advanceRecencyStamps(key1, key2);
    }

    private void advanceRecencyStamps(String context, String value) {
        int stamp = this.myContextMaxStamps.get((Object)context) + 1;
        this.myContextMaxStamps.put((Object)context, stamp);
        this.getValueStamps(context).put((Object)value, stamp);
        if (stamp > 20000) {
            this.trimAncientRecencyEntries(context, 10000);
        }
    }

    @NotNull
    private TObjectIntHashMap<String> getValueStamps(String context) {
        ObjectIntHashMap valueStamps = this.myValueStamps.get(context);
        if (valueStamps == null) {
            valueStamps = new ObjectIntHashMap();
            this.myValueStamps.put(context, (TObjectIntHashMap<String>)valueStamps);
        }
        ObjectIntHashMap objectIntHashMap = valueStamps;
        if (objectIntHashMap == null) {
            StatisticsUnit.$$$reportNull$$$0(0);
        }
        return objectIntHashMap;
    }

    private void trimAncientRecencyEntries(String context, int limit) {
        ObjectIntHashMap newStamps = new ObjectIntHashMap();
        for (Object o : this.getValueStamps(context).keys()) {
            int recency = this.getRecency(context, (String)o);
            if (recency == Integer.MAX_VALUE) continue;
            newStamps.put((Object)((String)o), limit - recency);
        }
        this.myValueStamps.put(context, (TObjectIntHashMap<String>)newStamps);
        this.myContextMaxStamps.put((Object)context, limit);
    }

    String[] getKeys2(String key1) {
        List list2 = this.myDataMap.get(key1);
        if (list2 == null) {
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        return ArrayUtil.toStringArray(new LinkedHashSet(list2));
    }

    int getNumber() {
        return this.myNumber;
    }

    void write(OutputStream out) throws IOException {
        DataOutputStream dataOut = new DataOutputStream(out);
        dataOut.writeInt(6);
        DataInputOutputUtilRt.writeSeq((DataOutput)dataOut, this.myDataMap.entrySet(), entry -> {
            IOUtil.writeUTF((DataOutput)dataOut, (String)((String)entry.getKey()));
            DataInputOutputUtilRt.writeSeq((DataOutput)dataOut, (Collection)((Collection)entry.getValue()), data -> IOUtil.writeUTF((DataOutput)dataOut, (String)data));
        });
        StatisticsUnit.writeStringIntMap(dataOut, this.myContextMaxStamps);
        DataInputOutputUtilRt.writeSeq((DataOutput)dataOut, this.myValueStamps.entrySet(), entry -> {
            IOUtil.writeUTF((DataOutput)dataOut, (String)((String)entry.getKey()));
            StatisticsUnit.writeStringIntMap(dataOut, (TObjectIntHashMap<String>)((TObjectIntHashMap)entry.getValue()));
        });
    }

    void read(InputStream in) throws IOException, WrongFormatException {
        this.myDataMap.clear();
        this.myContextMaxStamps.clear();
        this.myValueStamps.clear();
        DataInputStream dataIn = new DataInputStream(in);
        int formatVersion = dataIn.readInt();
        if (formatVersion != 6) {
            throw new WrongFormatException();
        }
        DataInputOutputUtilRt.readSeq((DataInput)dataIn, () -> {
            this.myDataMap.put(IOUtil.readUTF((DataInput)dataIn), new LinkedList(DataInputOutputUtilRt.readSeq((DataInput)dataIn, () -> IOUtil.readUTF((DataInput)dataIn))));
            return null;
        });
        StatisticsUnit.readStringIntMap(dataIn, this.myContextMaxStamps);
        DataInputOutputUtilRt.readSeq((DataInput)dataIn, () -> {
            ObjectIntHashMap map2 = new ObjectIntHashMap();
            this.myValueStamps.put(IOUtil.readUTF((DataInput)dataIn), (TObjectIntHashMap<String>)map2);
            StatisticsUnit.readStringIntMap(dataIn, (TObjectIntHashMap<String>)map2);
            return null;
        });
    }

    private static void writeStringIntMap(DataOutputStream dataOut, TObjectIntHashMap<String> map2) throws IOException {
        DataInputOutputUtilRt.writeINT((DataOutput)dataOut, (int)map2.size());
        for (Object context : map2.keys()) {
            IOUtil.writeUTF((DataOutput)dataOut, (String)((String)context));
            DataInputOutputUtilRt.writeINT((DataOutput)dataOut, (int)map2.get((Object)((String)context)));
        }
    }

    private static void readStringIntMap(DataInputStream dataIn, TObjectIntHashMap<String> map2) throws IOException {
        int count = DataInputOutputUtilRt.readINT((DataInput)dataIn);
        for (int i = 0; i < count; ++i) {
            map2.put((Object)IOUtil.readUTF((DataInput)dataIn), DataInputOutputUtilRt.readINT((DataInput)dataIn));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/statistics/impl/StatisticsUnit", "getValueStamps"));
    }
}

