/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.psi.stubs.SerializationManagerEx;
import com.intellij.psi.stubs.SerializerNotFoundException;
import com.intellij.psi.stubs.Stub;
import com.intellij.util.CompressionUtil;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.PersistentHashMapValueStorage;
import com.intellij.util.io.UnsyncByteArrayInputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SerializedStubTree {
    private final byte[] myBytes;
    private final int myLength;
    private final long myByteContentLength;
    private final int myCharContentLength;
    private Stub myStubElement;

    public SerializedStubTree(byte[] bytes, int length, @Nullable Stub stubElement, long byteContentLength, int charContentLength) {
        this.myBytes = bytes;
        this.myLength = length;
        this.myByteContentLength = byteContentLength;
        this.myCharContentLength = charContentLength;
        this.myStubElement = stubElement;
    }

    public SerializedStubTree(DataInput in) throws IOException {
        if (PersistentHashMapValueStorage.COMPRESSION_ENABLED) {
            int serializedStubsLength = DataInputOutputUtil.readINT((DataInput)in);
            byte[] bytes = new byte[serializedStubsLength];
            in.readFully(bytes);
            this.myBytes = bytes;
            this.myLength = this.myBytes.length;
            this.myByteContentLength = DataInputOutputUtil.readLONG((DataInput)in);
            this.myCharContentLength = DataInputOutputUtil.readINT((DataInput)in);
        } else {
            this.myBytes = CompressionUtil.readCompressed((DataInput)in);
            this.myLength = this.myBytes.length;
            this.myByteContentLength = in.readLong();
            this.myCharContentLength = in.readInt();
        }
    }

    public void write(DataOutput out) throws IOException {
        if (PersistentHashMapValueStorage.COMPRESSION_ENABLED) {
            DataInputOutputUtil.writeINT((DataOutput)out, (int)this.myLength);
            out.write(this.myBytes, 0, this.myLength);
            DataInputOutputUtil.writeLONG((DataOutput)out, (long)this.myByteContentLength);
            DataInputOutputUtil.writeINT((DataOutput)out, (int)this.myCharContentLength);
        } else {
            CompressionUtil.writeCompressed((DataOutput)out, (byte[])this.myBytes, (int)0, (int)this.myLength);
            out.writeLong(this.myByteContentLength);
            out.writeInt(this.myCharContentLength);
        }
    }

    @NotNull
    public Stub getStub(boolean willIndexStub) throws SerializerNotFoundException {
        Stub stub = this.getStub(willIndexStub, SerializationManagerEx.getInstanceEx());
        if (stub == null) {
            SerializedStubTree.$$$reportNull$$$0(0);
        }
        return stub;
    }

    @NotNull
    public Stub getStub(boolean willIndexStub, @NotNull SerializationManagerEx serializationManager) throws SerializerNotFoundException {
        Stub stubElement;
        if (serializationManager == null) {
            SerializedStubTree.$$$reportNull$$$0(1);
        }
        if ((stubElement = this.myStubElement) != null) {
            this.myStubElement = null;
            if (willIndexStub) {
                Stub stub = stubElement;
                if (stub == null) {
                    SerializedStubTree.$$$reportNull$$$0(2);
                }
                return stub;
            }
        }
        Stub stub = serializationManager.deserialize((InputStream)new UnsyncByteArrayInputStream(this.myBytes));
        if (stub == null) {
            SerializedStubTree.$$$reportNull$$$0(3);
        }
        return stub;
    }

    public boolean contentLengthMatches(long byteContentLength, int charContentLength) {
        if (this.myCharContentLength >= 0 && charContentLength >= 0) {
            return this.myCharContentLength == charContentLength;
        }
        return this.myByteContentLength == byteContentLength;
    }

    String dumpLengths() {
        return "{chars=" + this.myCharContentLength + ", bytes=" + this.myByteContentLength + "}";
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (!(that instanceof SerializedStubTree)) {
            return false;
        }
        SerializedStubTree thatTree = (SerializedStubTree)that;
        int length = this.myLength;
        if (length != thatTree.myLength) {
            return false;
        }
        byte[] thisBytes = this.myBytes;
        byte[] thatBytes = thatTree.myBytes;
        for (int i = 0; i < length; ++i) {
            if (thisBytes[i] == thatBytes[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this.myBytes == null) {
            return 0;
        }
        int result2 = 1;
        for (int i = 0; i < this.myLength; ++i) {
            result2 = 31 * result2 + this.myBytes[i];
        }
        return result2;
    }

    public long getByteContentLength() {
        return this.myByteContentLength;
    }

    public int getCharContentLength() {
        return this.myCharContentLength;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/stubs/SerializedStubTree";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serializationManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getStub";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/stubs/SerializedStubTree";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getStub";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

