/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.terminal.AppendableTerminalDataStream;
import com.intellij.terminal.JBTerminalSystemSettingsProviderBase;
import com.intellij.terminal.JBTerminalWidget;
import com.intellij.terminal.ProcessHandlerTtyConnector;
import com.jediterm.terminal.HyperlinkStyle;
import com.jediterm.terminal.Terminal;
import com.jediterm.terminal.TerminalKeyEncoder;
import com.jediterm.terminal.TerminalStarter;
import com.jediterm.terminal.TtyConnector;
import com.jediterm.terminal.model.JediTerminal;
import com.jediterm.terminal.ui.TerminalSession;
import java.awt.Color;
import java.io.IOException;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TerminalExecutionConsole
implements ConsoleView {
    private JBTerminalWidget myTerminalWidget;
    private Project myProject;
    private final AppendableTerminalDataStream myDataStream;
    private final TerminalKeyEncoder myKeyEncoder;

    public TerminalExecutionConsole(@NotNull Project project, @NotNull ProcessHandler processHandler2) {
        if (project == null) {
            TerminalExecutionConsole.$$$reportNull$$$0(0);
        }
        if (processHandler2 == null) {
            TerminalExecutionConsole.$$$reportNull$$$0(1);
        }
        this.myKeyEncoder = new TerminalKeyEncoder();
        this.myKeyEncoder.setAutoNewLine(true);
        this.myProject = project;
        JBTerminalSystemSettingsProviderBase provider = new JBTerminalSystemSettingsProviderBase(){

            public HyperlinkStyle.HighlightMode getHyperlinkHighlightingMode() {
                return HyperlinkStyle.HighlightMode.ALWAYS;
            }
        };
        this.myDataStream = new AppendableTerminalDataStream();
        this.myTerminalWidget = new JBTerminalWidget(project, 200, 24, provider, (Disposable)this){

            @Override
            protected TerminalStarter createTerminalStarter(JediTerminal terminal, TtyConnector connector) {
                return new TerminalStarter((Terminal)terminal, connector, TerminalExecutionConsole.this.myDataStream){

                    public byte[] getCode(int key, int modifiers) {
                        if (key == 10) {
                            return TerminalExecutionConsole.this.myKeyEncoder.getCode(key, modifiers);
                        }
                        return super.getCode(key, modifiers);
                    }
                };
            }
        };
        Disposer.register((Disposable)this.myTerminalWidget, (Disposable)provider);
        final TerminalSession session2 = this.myTerminalWidget.createTerminalSession(new ProcessHandlerTtyConnector(processHandler2, EncodingProjectManager.getInstance((Project)project).getDefaultCharset()));
        processHandler2.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void startNotified(@NotNull ProcessEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(0);
                }
                session2.start();
            }

            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                if (event == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (outputType == null) {
                    3.$$$reportNull$$$0(2);
                }
                try {
                    ConsoleViewContentType contentType = null;
                    if (outputType != ProcessOutputTypes.STDOUT) {
                        contentType = ConsoleViewContentType.getConsoleViewType((Key)outputType);
                    }
                    TerminalExecutionConsole.this.printText(event.getText(), contentType);
                    if (outputType == ProcessOutputTypes.SYSTEM) {
                        TerminalExecutionConsole.this.myDataStream.append('\r');
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(3);
                }
                TerminalExecutionConsole.this.myTerminalWidget.getTerminalPanel().setCursorVisible(false);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "outputType";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/terminal/TerminalExecutionConsole$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "startNotified";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onTextAvailable";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processTerminated";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private void printText(@NotNull String text, @Nullable ConsoleViewContentType contentType) throws IOException {
        if (text == null) {
            TerminalExecutionConsole.$$$reportNull$$$0(2);
        }
        if (contentType != null) {
            this.myDataStream.append(TerminalExecutionConsole.encodeColor(contentType.getAttributes().getForegroundColor()));
        }
        this.myDataStream.append(text);
        if (contentType != null) {
            this.myDataStream.append("\u001b[39m");
        }
    }

    private static String encodeColor(Color color) {
        return String.valueOf('\u001b') + "[38;2;" + color.getRed() + ";" + color.getGreen() + ";" + color.getBlue() + "m";
    }

    public void addMessageFilter(Project project, Filter filter2) {
        this.myTerminalWidget.addMessageFilter(project, filter2);
    }

    public void print(@NotNull String text, @NotNull ConsoleViewContentType contentType) {
        if (text == null) {
            TerminalExecutionConsole.$$$reportNull$$$0(3);
        }
        if (contentType == null) {
            TerminalExecutionConsole.$$$reportNull$$$0(4);
        }
        this.myTerminalWidget.getTerminal().writeCharacters(text);
    }

    public void clear() {
        this.myTerminalWidget.getTerminal().clearScreen();
    }

    public void scrollTo(int offset) {
    }

    public void attachToProcess(ProcessHandler processHandler2) {
    }

    public void setOutputPaused(boolean value) {
    }

    public boolean isOutputPaused() {
        return false;
    }

    public boolean hasDeferredOutput() {
        return false;
    }

    public void performWhenNoDeferredOutput(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            TerminalExecutionConsole.$$$reportNull$$$0(5);
        }
    }

    public void setHelpId(@NotNull String helpId) {
        if (helpId == null) {
            TerminalExecutionConsole.$$$reportNull$$$0(6);
        }
    }

    public void addMessageFilter(@NotNull Filter filter2) {
        if (filter2 == null) {
            TerminalExecutionConsole.$$$reportNull$$$0(7);
        }
        this.addMessageFilter(this.myProject, filter2);
    }

    public void printHyperlink(@NotNull String hyperlinkText, @Nullable HyperlinkInfo info) {
        if (hyperlinkText == null) {
            TerminalExecutionConsole.$$$reportNull$$$0(8);
        }
    }

    public int getContentSize() {
        return 0;
    }

    public boolean canPause() {
        return false;
    }

    @NotNull
    public AnAction[] createConsoleActions() {
        if (AnAction.EMPTY_ARRAY == null) {
            TerminalExecutionConsole.$$$reportNull$$$0(9);
        }
        return AnAction.EMPTY_ARRAY;
    }

    public void allowHeavyFilters() {
    }

    public JComponent getComponent() {
        return this.myTerminalWidget.getComponent();
    }

    public JComponent getPreferredFocusableComponent() {
        return this.myTerminalWidget.getComponent();
    }

    public void dispose() {
        this.myTerminalWidget = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentType";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helpId";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hyperlinkText";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/terminal/TerminalExecutionConsole";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/terminal/TerminalExecutionConsole";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createConsoleActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "printText";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "print";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "performWhenNoDeferredOutput";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setHelpId";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addMessageFilter";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "printHyperlink";
                break;
            }
            case 9: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

