/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tree;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.ide.SmartSelectProvider;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.Nullable;

public class TreeSmartSelectProvider
implements SmartSelectProvider<JTree> {
    public void increaseSelection(JTree tree) {
        TreePath path = tree.getLeadSelectionPath();
        if (path == null) {
            return;
        }
        TreeSmartSelectProvider.increaseSelection(path, tree);
    }

    private static void increaseSelection(TreePath path, JTree tree) {
        TreePath parentPath = path.getParentPath();
        if (parentPath == null) {
            return;
        }
        boolean madeSelection = false;
        for (int i = 0; i < TreeSmartSelectProvider.getNumberOfNodes(tree); ++i) {
            TreePath row = tree.getPathForRow(i);
            if (!parentPath.isDescendant(row) || row.equals(parentPath) || tree.isRowSelected(i)) continue;
            madeSelection = true;
            TreeSmartSelectProvider.addSelection(tree, row);
        }
        if (!madeSelection) {
            if (tree.isRowSelected(tree.getRowForPath(parentPath))) {
                TreeSmartSelectProvider.increaseSelection(parentPath, tree);
            } else {
                TreeSmartSelectProvider.addSelection(tree, parentPath);
            }
        }
    }

    public static int getNumberOfNodes(JTree tree) {
        return TreeSmartSelectProvider.getNumberOfNodes(tree, tree.getModel().getRoot());
    }

    private static int getNumberOfNodes(JTree tree, Object node) {
        int count = 1;
        int nChildren = tree.getModel().getChildCount(node);
        for (int i = 0; i < nChildren; ++i) {
            count += TreeSmartSelectProvider.getNumberOfNodes(tree, tree.getModel().getChild(node, i));
        }
        return count;
    }

    private static void addSelection(JTree tree, TreePath path) {
        TreePath leadPath = tree.getLeadSelectionPath();
        tree.getSelectionModel().addSelectionPath(path);
        tree.setLeadSelectionPath(leadPath);
    }

    public void decreaseSelection(JTree tree) {
        TreePath[] paths = tree.getSelectionPaths();
        TreePath leadSelection = tree.getLeadSelectionPath();
        if (paths == null || paths.length < 2) {
            return;
        }
        Object[] selected = leadSelection.getPath();
        if (selected.length < 2) {
            return;
        }
        ArrayList<TreePath> toRemove2 = new ArrayList<TreePath>();
        for (int i = 0; i < selected.length; ++i) {
            for (TreePath path : paths) {
                if (TreeSmartSelectProvider.hasCommonStart(path, leadSelection, i + 1)) continue;
                toRemove2.add(path);
            }
            if (toRemove2.isEmpty()) continue;
            if (toRemove2.size() == paths.length - 1 && tree.isPathSelected(leadSelection.getParentPath())) {
                tree.removeSelectionPath(leadSelection.getParentPath());
            } else {
                for (TreePath path : toRemove2) {
                    tree.removeSelectionPath(path);
                }
            }
            tree.setLeadSelectionPath(leadSelection);
            return;
        }
        if (paths.length == tree.getSelectionCount()) {
            for (TreePath path : paths) {
                tree.removeSelectionPath(path);
            }
            tree.addSelectionPath(leadSelection);
            tree.setLeadSelectionPath(leadSelection);
        }
    }

    private static boolean hasCommonStart(TreePath path, TreePath leadSelection, int commonStartLength) {
        Object[] pathObjects = path.getPath();
        if (pathObjects.length < commonStartLength) {
            return false;
        }
        Object[] leadSelectionObjects = leadSelection.getPath();
        for (int i = 0; i < pathObjects.length && i < leadSelectionObjects.length && i < commonStartLength; ++i) {
            if (pathObjects[i] == leadSelectionObjects[i] || pathObjects[i] != null && pathObjects[i].equals(leadSelectionObjects[i])) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public JTree getSource(DataContext context) {
        Component component = (Component)PlatformDataKeys.CONTEXT_COMPONENT.getData(context);
        return component instanceof JTree ? (JTree)component : null;
    }
}

