/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IndexExtension;
import com.intellij.util.indexing.IndexInfrastructure;
import com.intellij.util.indexing.SharedIndicesData;
import com.intellij.util.indexing.VfsAwareMapReduceIndex;
import com.intellij.util.indexing.impl.AbstractForwardIndex;
import com.intellij.util.indexing.impl.CollectionInputDataDiffBuilder;
import com.intellij.util.indexing.impl.DebugAssertions;
import com.intellij.util.indexing.impl.InputDataDiffBuilder;
import com.intellij.util.indexing.impl.KeyCollectionBasedForwardIndex;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.KeyDescriptor;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SharedMapBasedForwardIndex<Key, Value>
extends AbstractForwardIndex<Key, Value> {
    private final DataExternalizer<Collection<Key>> mySnapshotIndexExternalizer;
    private final KeyCollectionBasedForwardIndex<Key, Value> myUnderlying;

    SharedMapBasedForwardIndex(IndexExtension<Key, Value, ?> extension, @Nullable KeyCollectionBasedForwardIndex<Key, Value> underlying) {
        super(extension);
        this.myUnderlying = underlying;
        this.mySnapshotIndexExternalizer = VfsAwareMapReduceIndex.createInputsIndexExternalizer(extension);
        assert (this.myUnderlying != null || SharedIndicesData.ourFileSharedIndicesEnabled && !SharedIndicesData.DO_CHECKS);
    }

    @NotNull
    public InputDataDiffBuilder<Key, Value> getDiffBuilder(int inputId) throws IOException {
        if (SharedIndicesData.ourFileSharedIndicesEnabled) {
            Collection keys = SharedIndicesData.recallFileData(inputId, (ID)this.myIndexId, this.mySnapshotIndexExternalizer);
            if (this.myUnderlying != null) {
                Collection keysFromInputsIndex = (Collection)this.myUnderlying.getInput(inputId);
                if (keys == null && keysFromInputsIndex != null || !DebugAssertions.equals((Collection)keysFromInputsIndex, keys, (KeyDescriptor)this.myKeyDescriptor)) {
                    SharedIndicesData.associateFileData(inputId, (ID)this.myIndexId, keysFromInputsIndex, this.mySnapshotIndexExternalizer);
                    if (keys != null) {
                        DebugAssertions.error((String)("Unexpected indexing diff " + this.myIndexId.getName() + ", file:" + IndexInfrastructure.findFileById(PersistentFS.getInstance(), inputId) + "," + keysFromInputsIndex + "," + keys), (Object[])new Object[0]);
                    }
                    keys = keysFromInputsIndex;
                }
            }
            CollectionInputDataDiffBuilder collectionInputDataDiffBuilder = new CollectionInputDataDiffBuilder(inputId, keys);
            if (collectionInputDataDiffBuilder == null) {
                SharedMapBasedForwardIndex.$$$reportNull$$$0(0);
            }
            return collectionInputDataDiffBuilder;
        }
        CollectionInputDataDiffBuilder collectionInputDataDiffBuilder = new CollectionInputDataDiffBuilder(inputId, (Collection)this.myUnderlying.getInput(inputId));
        if (collectionInputDataDiffBuilder == null) {
            SharedMapBasedForwardIndex.$$$reportNull$$$0(1);
        }
        return collectionInputDataDiffBuilder;
    }

    public void putInputData(int inputId, @NotNull Map<Key, Value> data) throws IOException {
        if (data == null) {
            SharedMapBasedForwardIndex.$$$reportNull$$$0(2);
        }
        Set<Key> keySeq = data.keySet();
        if (this.myUnderlying != null) {
            this.myUnderlying.putInputData(inputId, data);
        }
        if (SharedIndicesData.ourFileSharedIndicesEnabled) {
            if (keySeq.isEmpty()) {
                keySeq = null;
            }
            SharedIndicesData.associateFileData(inputId, (ID)this.myIndexId, keySeq, this.mySnapshotIndexExternalizer);
        }
    }

    public void flush() {
        if (this.myUnderlying != null) {
            this.myUnderlying.flush();
        }
    }

    public void clear() throws IOException {
        if (this.myUnderlying != null) {
            this.myUnderlying.clear();
        }
    }

    public void close() throws IOException {
        if (this.myUnderlying != null) {
            this.myUnderlying.close();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/SharedMapBasedForwardIndex";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDiffBuilder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/SharedMapBasedForwardIndex";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "putInputData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

