/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectAndLibrariesScope;
import com.intellij.psi.search.ProjectScopeImpl;
import com.intellij.util.Processor;
import com.intellij.util.SystemProperties;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ConcurrentIntObjectMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.IdFilter;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.VfsAwareIndexStorage;
import com.intellij.util.indexing.impl.MapIndexStorage;
import com.intellij.util.io.AppendableStorageBackedByResizableMappedFile;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.DataOutputStream;
import com.intellij.util.io.DifferentSerializableBytesImplyNonEqualityPolicy;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.KeyDescriptor;
import gnu.trove.TIntHashSet;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VfsAwareMapIndexStorage<Key, Value>
extends MapIndexStorage<Key, Value>
implements VfsAwareIndexStorage<Key, Value> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.util.indexing.impl.MapIndexStorage");
    private static final boolean ENABLE_CACHED_HASH_IDS = SystemProperties.getBooleanProperty((String)"idea.index.no.cashed.hashids", (boolean)true);
    private final boolean myBuildKeyHashToVirtualFileMapping;
    private AppendableStorageBackedByResizableMappedFile myKeyHashToVirtualFileMapping;
    private volatile int myLastScannedId;
    private static final ConcurrentIntObjectMap<Boolean> ourInvalidatedSessionIds = ContainerUtil.createConcurrentIntObjectMap();
    private static volatile File mySessionDirectory;

    public VfsAwareMapIndexStorage(@NotNull File storageFile, @NotNull KeyDescriptor<Key> keyDescriptor, @NotNull DataExternalizer<Value> valueExternalizer, int cacheSize, boolean readOnly) throws IOException {
        if (storageFile == null) {
            VfsAwareMapIndexStorage.$$$reportNull$$$0(0);
        }
        if (keyDescriptor == null) {
            VfsAwareMapIndexStorage.$$$reportNull$$$0(1);
        }
        if (valueExternalizer == null) {
            VfsAwareMapIndexStorage.$$$reportNull$$$0(2);
        }
        super(storageFile, keyDescriptor, valueExternalizer, cacheSize, false, true, readOnly);
        this.myBuildKeyHashToVirtualFileMapping = false;
    }

    public VfsAwareMapIndexStorage(@NotNull File storageFile, @NotNull KeyDescriptor<Key> keyDescriptor, @NotNull DataExternalizer<Value> valueExternalizer, int cacheSize, boolean keyIsUniqueForIndexedFile, boolean buildKeyHashToVirtualFileMapping) throws IOException {
        if (storageFile == null) {
            VfsAwareMapIndexStorage.$$$reportNull$$$0(3);
        }
        if (keyDescriptor == null) {
            VfsAwareMapIndexStorage.$$$reportNull$$$0(4);
        }
        if (valueExternalizer == null) {
            VfsAwareMapIndexStorage.$$$reportNull$$$0(5);
        }
        super(storageFile, keyDescriptor, valueExternalizer, cacheSize, keyIsUniqueForIndexedFile, false, false);
        this.myBuildKeyHashToVirtualFileMapping = buildKeyHashToVirtualFileMapping && FileBasedIndex.ourEnableTracingOfKeyHashToVirtualFileMapping;
        this.initMapAndCache();
    }

    protected void initMapAndCache() throws IOException {
        super.initMapAndCache();
        this.myKeyHashToVirtualFileMapping = this.myBuildKeyHashToVirtualFileMapping ? new AppendableStorageBackedByResizableMappedFile(this.getProjectFile(), 4096, null, 0x100000, true) : null;
    }

    protected void checkCanceled() {
        ProgressManager.checkCanceled();
    }

    @NotNull
    private File getProjectFile() {
        File file2 = new File(this.myBaseStorageFile.getPath() + ".project");
        if (file2 == null) {
            VfsAwareMapIndexStorage.$$$reportNull$$$0(6);
        }
        return file2;
    }

    private <T extends Throwable> void withLock(ThrowableRunnable<T> r) throws T {
        this.myKeyHashToVirtualFileMapping.getPagedFileStorage().lock();
        try {
            r.run();
        }
        finally {
            this.myKeyHashToVirtualFileMapping.getPagedFileStorage().unlock();
        }
    }

    public void flush() {
        this.l.lock();
        try {
            super.flush();
            if (this.myKeyHashToVirtualFileMapping != null && this.myKeyHashToVirtualFileMapping.isDirty()) {
                this.withLock(() -> this.myKeyHashToVirtualFileMapping.force());
            }
        }
        finally {
            this.l.unlock();
        }
    }

    public void close() throws StorageException {
        super.close();
        try {
            if (this.myKeyHashToVirtualFileMapping != null) {
                this.withLock(() -> this.myKeyHashToVirtualFileMapping.close());
            }
        }
        catch (RuntimeException e) {
            VfsAwareMapIndexStorage.unwrapCauseAndRethrow((RuntimeException)e);
        }
    }

    public void clear() throws StorageException {
        try {
            if (this.myKeyHashToVirtualFileMapping != null) {
                this.withLock(() -> this.myKeyHashToVirtualFileMapping.close());
            }
        }
        catch (RuntimeException e) {
            LOG.error((Throwable)e);
        }
        try {
            if (this.myKeyHashToVirtualFileMapping != null) {
                IOUtil.deleteAllFilesStartingWith((File)this.getProjectFile());
            }
        }
        catch (RuntimeException e) {
            VfsAwareMapIndexStorage.unwrapCauseAndRethrow((RuntimeException)e);
        }
        super.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean processKeys(@NotNull Processor<Key> processor2, GlobalSearchScope scope, IdFilter idFilter) throws StorageException {
        if (processor2 == null) {
            VfsAwareMapIndexStorage.$$$reportNull$$$0(7);
        }
        this.l.lock();
        try {
            this.myCache.clear();
            if (this.myBuildKeyHashToVirtualFileMapping && idFilter != null) {
                TIntHashSet finalHashMaskSet;
                TIntHashSet hashMaskSet = null;
                long l = System.currentTimeMillis();
                File fileWithCaches = this.getSavedProjectFileValueIds(this.myLastScannedId, scope);
                boolean useCachedHashIds = ENABLE_CACHED_HASH_IDS && (scope instanceof ProjectScopeImpl || scope instanceof ProjectAndLibrariesScope) && fileWithCaches != null;
                int id = this.myKeyHashToVirtualFileMapping.getCurrentLength();
                if (useCachedHashIds && id == this.myLastScannedId && ourInvalidatedSessionIds.remove(id) == null) {
                    try {
                        hashMaskSet = VfsAwareMapIndexStorage.loadHashedIds(fileWithCaches);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (hashMaskSet == null) {
                    if (useCachedHashIds && this.myLastScannedId != 0) {
                        FileUtil.asyncDelete((File)fileWithCaches);
                    }
                    finalHashMaskSet = hashMaskSet = new TIntHashSet(1000);
                    this.withLock(() -> {
                        this.myKeyHashToVirtualFileMapping.force();
                        ProgressManager.checkCanceled();
                        this.myKeyHashToVirtualFileMapping.processAll(key -> {
                            if (!idFilter.containsFileId(key[1])) {
                                return true;
                            }
                            finalHashMaskSet.add(key[0]);
                            ProgressManager.checkCanceled();
                            return true;
                        }, (KeyDescriptor)IntPairInArrayKeyDescriptor.INSTANCE);
                    });
                    if (useCachedHashIds) {
                        this.saveHashedIds(hashMaskSet, id, scope);
                    }
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Scanned keyHashToVirtualFileMapping of " + this.myBaseStorageFile + " for " + (System.currentTimeMillis() - l));
                }
                finalHashMaskSet = hashMaskSet;
                boolean bl = this.myMap.processKeys(key -> {
                    if (processor2 == null) {
                        VfsAwareMapIndexStorage.$$$reportNull$$$0(13);
                    }
                    if (!finalHashMaskSet.contains(this.myKeyDescriptor.getHashCode(key))) {
                        return true;
                    }
                    return processor2.process(key);
                });
                return bl;
            }
            boolean hashMaskSet = this.myMap.processKeys(processor2);
            return hashMaskSet;
        }
        catch (IOException e) {
            throw new StorageException((Throwable)e);
        }
        catch (RuntimeException e) {
            boolean bl = (Boolean)VfsAwareMapIndexStorage.unwrapCauseAndRethrow((RuntimeException)e);
            return bl;
        }
        finally {
            this.l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static TIntHashSet loadHashedIds(@NotNull File fileWithCaches) throws IOException {
        int capacity;
        if (fileWithCaches == null) {
            VfsAwareMapIndexStorage.$$$reportNull$$$0(8);
        }
        FilterInputStream inputStream = null;
        inputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(fileWithCaches)));
        TIntHashSet hashMaskSet = new TIntHashSet(capacity);
        for (capacity = DataInputOutputUtil.readINT((DataInput)((Object)inputStream)); capacity > 0; --capacity) {
            hashMaskSet.add(DataInputOutputUtil.readINT((DataInput)((Object)inputStream)));
        }
        inputStream.close();
        TIntHashSet tIntHashSet = hashMaskSet;
        TIntHashSet tIntHashSet2 = tIntHashSet;
        if (tIntHashSet2 == null) {
            VfsAwareMapIndexStorage.$$$reportNull$$$0(9);
        }
        return tIntHashSet2;
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveHashedIds(@NotNull TIntHashSet hashMaskSet, int largestId, @NotNull GlobalSearchScope scope) {
        if (hashMaskSet == null) {
            VfsAwareMapIndexStorage.$$$reportNull$$$0(10);
        }
        if (scope == null) {
            VfsAwareMapIndexStorage.$$$reportNull$$$0(11);
        }
        File newFileWithCaches = this.getSavedProjectFileValueIds(largestId, scope);
        assert (newFileWithCaches != null);
        DataOutputStream stream = null;
        boolean savedSuccessfully = false;
        try {
            stream = new DataOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(newFileWithCaches)));
            DataInputOutputUtil.writeINT((DataOutput)stream, (int)hashMaskSet.size());
            DataOutputStream finalStream = stream;
            savedSuccessfully = hashMaskSet.forEach(value -> {
                try {
                    DataInputOutputUtil.writeINT((DataOutput)finalStream, (int)value);
                    return true;
                }
                catch (IOException ex) {
                    return false;
                }
            });
        }
        catch (IOException iOException) {
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                    if (savedSuccessfully) {
                        this.myLastScannedId = largestId;
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static File getSessionDir() {
        File sessionDirectory = mySessionDirectory;
        if (sessionDirectory != null) return sessionDirectory;
        Class<VfsAwareMapIndexStorage> clazz = VfsAwareMapIndexStorage.class;
        synchronized (VfsAwareMapIndexStorage.class) {
            sessionDirectory = mySessionDirectory;
            if (sessionDirectory != null) return sessionDirectory;
            try {
                mySessionDirectory = sessionDirectory = FileUtil.createTempDirectory((File)new File(PathManager.getTempPath()), (String)Long.toString(System.currentTimeMillis()), (String)"", (boolean)true);
            }
            catch (IOException ex) {
                throw new RuntimeException("Can not create temp directory", ex);
            }
            return sessionDirectory;
        }
    }

    @Nullable
    private File getSavedProjectFileValueIds(int id, @NotNull GlobalSearchScope scope) {
        Project project;
        if (scope == null) {
            VfsAwareMapIndexStorage.$$$reportNull$$$0(12);
        }
        if ((project = scope.getProject()) == null) {
            return null;
        }
        return new File(VfsAwareMapIndexStorage.getSessionDir(), this.getProjectFile().getName() + "." + project.hashCode() + "." + id + "." + scope.isSearchInLibraries());
    }

    public void addValue(Key key, int inputId, Value value) throws StorageException {
        try {
            if (this.myKeyHashToVirtualFileMapping != null) {
                this.withLock(() -> this.myKeyHashToVirtualFileMapping.append((Object)new int[]{this.myKeyDescriptor.getHashCode(key), inputId}, (KeyDescriptor)IntPairInArrayKeyDescriptor.INSTANCE));
                int lastScannedId = this.myLastScannedId;
                if (lastScannedId != 0) {
                    ourInvalidatedSessionIds.cacheOrGet(lastScannedId, (Object)Boolean.TRUE);
                    this.myLastScannedId = 0;
                }
            }
            super.addValue(key, inputId, value);
        }
        catch (IOException e) {
            throw new StorageException((Throwable)e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storageFile";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyDescriptor";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueExternalizer";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/VfsAwareMapIndexStorage";
                break;
            }
            case 7: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileWithCaches";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashMaskSet";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/VfsAwareMapIndexStorage";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectFile";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "loadHashedIds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 9: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processKeys";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "loadHashedIds";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "saveHashedIds";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getSavedProjectFileValueIds";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processKeys$5";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class IntPairInArrayKeyDescriptor
    implements KeyDescriptor<int[]>,
    DifferentSerializableBytesImplyNonEqualityPolicy {
        private static final IntPairInArrayKeyDescriptor INSTANCE = new IntPairInArrayKeyDescriptor();

        private IntPairInArrayKeyDescriptor() {
        }

        public void save(@NotNull DataOutput out, int[] value) throws IOException {
            if (out == null) {
                IntPairInArrayKeyDescriptor.$$$reportNull$$$0(0);
            }
            DataInputOutputUtil.writeINT((DataOutput)out, (int)value[0]);
            DataInputOutputUtil.writeINT((DataOutput)out, (int)value[1]);
        }

        public int[] read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                IntPairInArrayKeyDescriptor.$$$reportNull$$$0(1);
            }
            return new int[]{DataInputOutputUtil.readINT((DataInput)in), DataInputOutputUtil.readINT((DataInput)in)};
        }

        public int getHashCode(int[] value) {
            return value[0] * 31 + value[1];
        }

        public boolean isEqual(int[] val1, int[] val2) {
            return val1[0] == val2[0] && val1[1] == val2[1];
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/util/indexing/VfsAwareMapIndexStorage$IntPairInArrayKeyDescriptor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

