/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcsUtil;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.ThrowableNotNullFunction;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.checkin.CheckinEnvironment;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsFileUtil {
    public static final int FILE_PATH_LIMIT = 7600;

    @NotNull
    public static <T> List<T> foreachChunk(@NotNull List<String> arguments, @NotNull ThrowableNotNullFunction<List<String>, List<? extends T>, VcsException> processor2) throws VcsException {
        if (arguments == null) {
            VcsFileUtil.$$$reportNull$$$0(0);
        }
        if (processor2 == null) {
            VcsFileUtil.$$$reportNull$$$0(1);
        }
        List<? extends T> list2 = VcsFileUtil.foreachChunk(arguments, 1, processor2);
        if (list2 == null) {
            VcsFileUtil.$$$reportNull$$$0(2);
        }
        return list2;
    }

    @NotNull
    public static <T> List<T> foreachChunk(@NotNull List<String> arguments, int groupSize, @NotNull ThrowableNotNullFunction<List<String>, List<? extends T>, VcsException> processor2) throws VcsException {
        if (arguments == null) {
            VcsFileUtil.$$$reportNull$$$0(3);
        }
        if (processor2 == null) {
            VcsFileUtil.$$$reportNull$$$0(4);
        }
        ArrayList result2 = ContainerUtil.newArrayList();
        VcsFileUtil.foreachChunk(arguments, groupSize, (ThrowableConsumer<List<String>, VcsException>)((ThrowableConsumer)chunk -> {
            if (processor2 == null) {
                VcsFileUtil.$$$reportNull$$$0(29);
            }
            result2.addAll((Collection)processor2.fun(chunk));
        }));
        ArrayList arrayList = result2;
        if (arrayList == null) {
            VcsFileUtil.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    public static void foreachChunk(@NotNull List<String> arguments, int groupSize, @NotNull ThrowableConsumer<List<String>, VcsException> consumer) throws VcsException {
        if (arguments == null) {
            VcsFileUtil.$$$reportNull$$$0(6);
        }
        if (consumer == null) {
            VcsFileUtil.$$$reportNull$$$0(7);
        }
        List<List<String>> chunks = VcsFileUtil.chunkArguments(arguments, groupSize);
        for (List<String> chunk : chunks) {
            ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
            if (indicator != null) {
                indicator.checkCanceled();
            }
            consumer.consume(chunk);
        }
    }

    @NotNull
    public static List<List<String>> chunkArguments(@NotNull List<String> arguments) {
        if (arguments == null) {
            VcsFileUtil.$$$reportNull$$$0(8);
        }
        List<List<String>> list2 = VcsFileUtil.chunkArguments(arguments, 1);
        if (list2 == null) {
            VcsFileUtil.$$$reportNull$$$0(9);
        }
        return list2;
    }

    @NotNull
    public static List<List<String>> chunkArguments(@NotNull List<String> arguments, int groupSize) {
        int i;
        if (arguments == null) {
            VcsFileUtil.$$$reportNull$$$0(10);
        }
        assert (arguments.size() % groupSize == 0) : "Arguments size should be divisible by group size";
        ArrayList<List<String>> rc = new ArrayList<List<String>>();
        int start = 0;
        int size = 0;
        for (i = 0; i < arguments.size(); i += groupSize) {
            int length = 0;
            for (int j = 0; j < groupSize; ++j) {
                length += arguments.get(i + j).length();
            }
            if (size + length > 7600) {
                if (start == i) {
                    rc.add(arguments.subList(i, i + groupSize));
                    start = i + groupSize;
                    size = 0;
                    continue;
                }
                rc.add(arguments.subList(start, i));
                start = i;
                size = length;
                continue;
            }
            size += length;
        }
        if (start != arguments.size()) {
            rc.add(arguments.subList(start, i));
        }
        ArrayList<List<String>> arrayList = rc;
        if (arrayList == null) {
            VcsFileUtil.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    public static List<List<String>> chunkPaths(VirtualFile root, Collection<FilePath> files) {
        return VcsFileUtil.chunkArguments(VcsFileUtil.toRelativePaths(root, files));
    }

    public static List<List<String>> chunkFiles(@NotNull VirtualFile root, @NotNull Collection<VirtualFile> files) {
        if (root == null) {
            VcsFileUtil.$$$reportNull$$$0(12);
        }
        if (files == null) {
            VcsFileUtil.$$$reportNull$$$0(13);
        }
        return VcsFileUtil.chunkArguments(VcsFileUtil.toRelativeFiles(root, files));
    }

    public static String getRelativeFilePath(VirtualFile file2, @NotNull VirtualFile baseDir) {
        if (baseDir == null) {
            VcsFileUtil.$$$reportNull$$$0(14);
        }
        return VcsFileUtil.getRelativeFilePath(file2.getPath(), baseDir);
    }

    public static String getRelativeFilePath(String file2, @NotNull VirtualFile baseDir) {
        String basePath;
        if (baseDir == null) {
            VcsFileUtil.$$$reportNull$$$0(15);
        }
        if (SystemInfo.isWindows) {
            file2 = file2.replace('\\', '/');
        }
        if (!file2.startsWith(basePath = baseDir.getPath())) {
            return file2;
        }
        if (file2.equals(basePath)) {
            return ".";
        }
        return file2.substring(baseDir.getPath().length() + 1);
    }

    public static boolean isOctal(char ch) {
        return '0' <= ch && ch <= '7';
    }

    public static String relativePath(VirtualFile root, FilePath path) {
        return VcsFileUtil.relativePath(VfsUtil.virtualToIoFile((VirtualFile)root), path.getIOFile());
    }

    public static String relativePath(File root, FilePath path) {
        return VcsFileUtil.relativePath(root, path.getIOFile());
    }

    public static String relativePath(File root, VirtualFile file2) {
        return VcsFileUtil.relativePath(root, VfsUtil.virtualToIoFile((VirtualFile)file2));
    }

    public static String relativePath(VirtualFile root, VirtualFile file2) {
        return VcsFileUtil.relativePath(VfsUtil.virtualToIoFile((VirtualFile)root), VfsUtil.virtualToIoFile((VirtualFile)file2));
    }

    public static String relativeOrFullPath(VirtualFile root, VirtualFile file2) {
        if (root == null) {
            file2.getPath();
        }
        return VcsFileUtil.relativePath(VfsUtil.virtualToIoFile((VirtualFile)root), VfsUtil.virtualToIoFile((VirtualFile)file2));
    }

    public static String relativePath(File root, File path) {
        String rc = FileUtil.getRelativePath((File)root, (File)path);
        if (rc == null) {
            throw new IllegalArgumentException("The file " + path + " cannot be made relative to " + root);
        }
        return rc.replace(File.separatorChar, '/');
    }

    public static List<String> toRelativePaths(@NotNull VirtualFile root, @NotNull Collection<FilePath> filePaths) {
        if (root == null) {
            VcsFileUtil.$$$reportNull$$$0(16);
        }
        if (filePaths == null) {
            VcsFileUtil.$$$reportNull$$$0(17);
        }
        ArrayList<String> rc = new ArrayList<String>(filePaths.size());
        for (FilePath path : filePaths) {
            rc.add(VcsFileUtil.relativePath(root, path));
        }
        return rc;
    }

    public static List<String> toRelativeFiles(@NotNull VirtualFile root, @NotNull Collection<VirtualFile> files) {
        if (root == null) {
            VcsFileUtil.$$$reportNull$$$0(18);
        }
        if (files == null) {
            VcsFileUtil.$$$reportNull$$$0(19);
        }
        ArrayList<String> rc = new ArrayList<String>(files.size());
        for (VirtualFile file2 : files) {
            rc.add(VcsFileUtil.relativePath(root, file2));
        }
        return rc;
    }

    public static void markFilesDirty(@NotNull Project project, @NotNull Collection<VirtualFile> affectedFiles) {
        if (project == null) {
            VcsFileUtil.$$$reportNull$$$0(20);
        }
        if (affectedFiles == null) {
            VcsFileUtil.$$$reportNull$$$0(21);
        }
        VcsDirtyScopeManager dirty = VcsDirtyScopeManager.getInstance((Project)project);
        for (VirtualFile file2 : affectedFiles) {
            if (file2.isDirectory()) {
                dirty.dirDirtyRecursively(file2);
                continue;
            }
            dirty.fileDirty(file2);
        }
    }

    public static void markFilesDirty(@NotNull Project project, @NotNull List<FilePath> affectedFiles) {
        if (project == null) {
            VcsFileUtil.$$$reportNull$$$0(22);
        }
        if (affectedFiles == null) {
            VcsFileUtil.$$$reportNull$$$0(23);
        }
        VcsDirtyScopeManager dirty = VcsDirtyScopeManager.getInstance((Project)project);
        for (FilePath file2 : affectedFiles) {
            if (file2.isDirectory()) {
                dirty.dirDirtyRecursively(file2);
                continue;
            }
            dirty.fileDirty(file2);
        }
    }

    @Nullable
    public static VirtualFile getPossibleBase(VirtualFile file2, String ... path) {
        if (file2 == null || path.length == 0) {
            return null;
        }
        VirtualFile current = file2;
        ArrayList<VirtualFile> backTrace = new ArrayList<VirtualFile>();
        int idx = path.length - 1;
        while (current != null) {
            if (SystemInfo.isFileSystemCaseSensitive ? current.getName().equals(path[idx]) : current.getName().equalsIgnoreCase(path[idx])) {
                if (idx == 0) {
                    return current;
                }
                --idx;
            } else if (idx != path.length - 1) {
                int diff = path.length - 1 - idx - 1;
                for (int i = 0; i < diff; ++i) {
                    current = (VirtualFile)backTrace.remove(backTrace.size() - 1);
                }
                idx = path.length - 1;
                continue;
            }
            backTrace.add(current);
            current = current.getParent();
        }
        return null;
    }

    public static void addFilesToVcsWithConfirmation(@NotNull Project project, VirtualFile ... virtualFiles) {
        if (project == null) {
            VcsFileUtil.$$$reportNull$$$0(24);
        }
        VcsFileUtil.addFilesToVcsWithConfirmation(project, Arrays.asList(virtualFiles));
    }

    public static void addFilesToVcsWithConfirmation(@NotNull Project project, @NotNull Collection<VirtualFile> virtualFiles) {
        if (project == null) {
            VcsFileUtil.$$$reportNull$$$0(25);
        }
        if (virtualFiles == null) {
            VcsFileUtil.$$$reportNull$$$0(26);
        }
        if (virtualFiles.isEmpty()) {
            return;
        }
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        ArrayListMultimap vcsMap = ArrayListMultimap.create();
        for (VirtualFile createdFile : virtualFiles) {
            AbstractVcs vcs = vcsManager.getVcsFor(createdFile);
            if (vcs == null) continue;
            VfsUtil.processFileRecursivelyWithoutIgnored((VirtualFile)createdFile, arg_0 -> VcsFileUtil.lambda$addFilesToVcsWithConfirmation$1((Multimap)vcsMap, vcs, arg_0));
        }
        for (AbstractVcs vcs : vcsMap.keySet()) {
            VcsShowConfirmationOption addOption = vcsManager.getStandardConfirmation(VcsConfiguration.StandardConfirmation.ADD, vcs);
            if (addOption.getValue() == VcsShowConfirmationOption.Value.DO_NOTHING_SILENTLY) {
                return;
            }
            ArrayList<VirtualFile> filesList = new ArrayList<VirtualFile>(vcsMap.get((Object)vcs));
            if (addOption.getValue() == VcsShowConfirmationOption.Value.DO_ACTION_SILENTLY) {
                VcsFileUtil.performAdditions(vcs, filesList);
                continue;
            }
            AbstractVcsHelper helper = AbstractVcsHelper.getInstance((Project)project);
            Ref filesToAdd = Ref.create();
            ApplicationManager.getApplication().invokeAndWait(() -> filesToAdd.set((Object)helper.selectFilesToProcess(new ArrayList(filesList), VcsBundle.message((String)"confirmation.title.add.files.to", (Object[])new Object[]{vcs.getDisplayName()}), null, VcsBundle.message((String)"confirmation.title.add.file.to", (Object[])new Object[]{vcs.getDisplayName()}), null, addOption)));
            if (filesToAdd.isNull()) continue;
            VcsFileUtil.performAdditions(vcs, new ArrayList<VirtualFile>((Collection)filesToAdd.get()));
        }
    }

    private static void performAdditions(@NotNull AbstractVcs vcs, @NotNull List<VirtualFile> value) {
        CheckinEnvironment checkinEnvironment;
        if (vcs == null) {
            VcsFileUtil.$$$reportNull$$$0(27);
        }
        if (value == null) {
            VcsFileUtil.$$$reportNull$$$0(28);
        }
        if ((checkinEnvironment = vcs.getCheckinEnvironment()) != null) {
            checkinEnvironment.scheduleUnversionedFilesForAddition(value);
        }
    }

    private static /* synthetic */ boolean lambda$addFilesToVcsWithConfirmation$1(Multimap vcsMap, AbstractVcs vcs, VirtualFile virtualFile) {
        return vcsMap.put((Object)vcs, (Object)virtualFile);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 9: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 9: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 1: 
            case 4: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 2: 
            case 5: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcsUtil/VcsFileUtil";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 12: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 13: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePaths";
                break;
            }
            case 20: 
            case 22: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "affectedFiles";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFiles";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcsUtil/VcsFileUtil";
                break;
            }
            case 2: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "foreachChunk";
                break;
            }
            case 9: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "chunkArguments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "foreachChunk";
                break;
            }
            case 2: 
            case 5: 
            case 9: 
            case 11: {
                break;
            }
            case 8: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "chunkArguments";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "chunkFiles";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getRelativeFilePath";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "toRelativePaths";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "toRelativeFiles";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "markFilesDirty";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "addFilesToVcsWithConfirmation";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "performAdditions";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "lambda$foreachChunk$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 9: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

