/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.template.formatter;

import com.intellij.formatting.ASTBlock;
import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.BlockEx;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.formatting.templateLanguages.BlockWithParent;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.formatter.common.AbstractBlock;
import com.intellij.psi.formatter.xml.XmlFormattingPolicy;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.xml.template.formatter.AbstractXmlTemplateFormattingModelBuilder;
import com.intellij.xml.template.formatter.FragmentedTemplateException;
import com.intellij.xml.template.formatter.IndentInheritingBlock;
import com.intellij.xml.template.formatter.TemplateFormatUtil;
import com.intellij.xml.template.formatter.TemplateXmlBlock;
import com.intellij.xml.template.formatter.TemplateXmlTagBlock;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TemplateLanguageBlock
extends AbstractBlock
implements BlockEx,
IndentInheritingBlock,
BlockWithParent {
    protected final ASTNode myNode;
    private final CodeStyleSettings mySettings;
    private final AbstractXmlTemplateFormattingModelBuilder myBuilder;
    private XmlFormattingPolicy myXmlFormattingPolicy;
    private Indent myIndent;
    private BlockWithParent myParent;
    private boolean myContainsErrorElements;

    protected TemplateLanguageBlock(AbstractXmlTemplateFormattingModelBuilder builder, @NotNull ASTNode node, @Nullable Wrap wrap, @Nullable Alignment alignment, CodeStyleSettings settings, XmlFormattingPolicy xmlFormattingPolicy, Indent indent) {
        if (node == null) {
            TemplateLanguageBlock.$$$reportNull$$$0(0);
        }
        super(node, wrap, alignment);
        this.myContainsErrorElements = false;
        this.myNode = node;
        this.mySettings = settings;
        this.myBuilder = builder;
        this.myXmlFormattingPolicy = xmlFormattingPolicy;
        this.myIndent = indent;
    }

    protected List<Block> buildChildrenWithMerge() throws FragmentedTemplateException {
        ArrayList<Block> markupBlocks = new ArrayList<Block>();
        List<PsiElement> markupElements = TemplateFormatUtil.findAllMarkupLanguageElementsInside(this.myNode.getPsi());
        if (markupElements.size() == 1 && markupElements.get(0) instanceof XmlDocument) {
            markupElements = this.getXmlDocumentChildren(markupElements.get(0));
        }
        boolean mergeFromMarkup = false;
        for (PsiElement markupElement : markupElements) {
            if (TemplateFormatUtil.isErrorElement(markupElement)) {
                throw new FragmentedTemplateException((PsiErrorElement)markupElement);
            }
            if (FormatterUtil.containsWhiteSpacesOnly(markupElement.getNode())) continue;
            Block rootBlock = this.myBuilder.createDataLanguageRootBlock(markupElement, markupElement.getLanguage(), this.mySettings, this.myXmlFormattingPolicy, this.myNode.getPsi().getContainingFile(), this.getDefaultMarkupIndent());
            PsiElement parent = markupElement.getParent();
            if (!mergeFromMarkup) {
                mergeFromMarkup = TemplateLanguageBlock.isScriptBlock(rootBlock);
            }
            if (parent instanceof PsiFile || rootBlock instanceof TemplateXmlBlock && ((TemplateXmlBlock)rootBlock).isTextContainingTemplateElements()) {
                for (Block block : rootBlock.getSubBlocks()) {
                    if (TemplateLanguageBlock.containsErrorElement(block)) {
                        throw new FragmentedTemplateException();
                    }
                    markupBlocks.add(block);
                }
                continue;
            }
            markupBlocks.add(rootBlock);
        }
        List<Block> result2 = new ArrayList<Block>();
        for (ASTNode child = this.myNode.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (FormatterUtil.containsWhiteSpacesOnly(child) || child.getTextLength() <= 0 || this.myBuilder.isMarkupLanguageElement(child.getPsi())) continue;
            this.addBlocksForNonMarkupChild(result2, child);
        }
        if (markupBlocks.size() > 0) {
            if (result2.isEmpty()) {
                return markupBlocks;
            }
            result2 = mergeFromMarkup ? TemplateFormatUtil.mergeBlocks(markupBlocks, result2, this.myNode.getTextRange()) : TemplateFormatUtil.mergeBlocks(result2, markupBlocks, this.myNode.getTextRange());
            for (Block resultBlock : result2) {
                ASTNode node;
                ASTNode aSTNode = node = resultBlock instanceof ASTBlock ? ((ASTBlock)resultBlock).getNode() : null;
                if (node != null && resultBlock instanceof IndentInheritingBlock) {
                    ((IndentInheritingBlock)resultBlock).setIndent(this.getChildIndent(node));
                }
                if (!(resultBlock instanceof BlockWithParent)) continue;
                ((BlockWithParent)resultBlock).setParent(this);
            }
        }
        return result2;
    }

    @Override
    protected List<Block> buildChildren() {
        try {
            return this.buildChildrenWithMerge();
        }
        catch (FragmentedTemplateException e) {
            this.myContainsErrorElements = true;
            return AbstractBlock.EMPTY;
        }
    }

    @NotNull
    private List<PsiElement> getXmlDocumentChildren(@NotNull PsiElement xmlDocument) {
        if (xmlDocument == null) {
            TemplateLanguageBlock.$$$reportNull$$$0(1);
        }
        ArrayList<PsiElement> children2 = new ArrayList<PsiElement>();
        for (PsiElement child = xmlDocument.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (this.myBuilder.isOuterLanguageElement(child)) continue;
            children2.add(child);
        }
        ArrayList<PsiElement> arrayList = children2;
        if (arrayList == null) {
            TemplateLanguageBlock.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    private static boolean containsErrorElement(@NotNull Block block) {
        ASTNode node;
        if (block == null) {
            TemplateLanguageBlock.$$$reportNull$$$0(3);
        }
        if (block instanceof ASTBlock && (node = ((ASTBlock)block).getNode()) != null) {
            return TemplateFormatUtil.isErrorElement(node.getPsi());
        }
        return false;
    }

    protected void addBlocksForNonMarkupChild(List<Block> result2, ASTNode child) {
        Block templateLanguageBlock = this.myBuilder.createTemplateLanguageBlock(child, this.mySettings, this.myXmlFormattingPolicy, this.getChildIndent(child), this.getChildAlignment(child), this.getChildWrap(child));
        if (templateLanguageBlock instanceof BlockWithParent) {
            ((BlockWithParent)templateLanguageBlock).setParent(this);
        }
        result2.add(templateLanguageBlock);
    }

    private static boolean isScriptBlock(Block block) {
        if (block instanceof TemplateXmlTagBlock) {
            return ((TemplateXmlTagBlock)block).isScriptBlock();
        }
        return false;
    }

    @Nullable
    protected Alignment getChildAlignment(ASTNode child) {
        return null;
    }

    @Override
    public Indent getIndent() {
        return this.myIndent;
    }

    @Override
    protected final Indent getChildIndent() {
        return Indent.getNoneIndent();
    }

    @NotNull
    protected abstract Indent getChildIndent(@NotNull ASTNode var1);

    public boolean isLeaf() {
        return this.myNode.getFirstChildNode() == null || this.myContainsErrorElements;
    }

    @Override
    public void setIndent(Indent indent) {
        this.myIndent = indent;
    }

    @Override
    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        ChildAttributes childAttributes = new ChildAttributes(Indent.getNormalIndent(), null);
        if (childAttributes == null) {
            TemplateLanguageBlock.$$$reportNull$$$0(4);
        }
        return childAttributes;
    }

    protected Indent getDefaultMarkupIndent() {
        return Indent.getNormalIndent();
    }

    public CodeStyleSettings getSettings() {
        return this.mySettings;
    }

    @Override
    public BlockWithParent getParent() {
        return this.myParent;
    }

    @Override
    public void setParent(BlockWithParent newParent) {
        this.myParent = newParent;
    }

    @Nullable
    protected Wrap getChildWrap(ASTNode child) {
        return Wrap.createWrap((WrapType)WrapType.NONE, (boolean)false);
    }

    protected abstract Spacing getSpacing(TemplateLanguageBlock var1);

    public XmlFormattingPolicy getXmlFormattingPolicy() {
        return this.myXmlFormattingPolicy;
    }

    public boolean containsErrorElements() {
        return this.myContainsErrorElements;
    }

    @Override
    @Nullable
    public Language getLanguage() {
        return this.myNode.getPsi().getLanguage();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlDocument";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xml/template/formatter/TemplateLanguageBlock";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xml/template/formatter/TemplateLanguageBlock";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getXmlDocumentChildren";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildAttributes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getXmlDocumentChildren";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "containsErrorElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

