/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.intentions;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.codeInsight.intentions.NameUsage;
import com.jetbrains.python.psi.resolve.PyResolveUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeclarationConflictChecker {
    private DeclarationConflictChecker() {
    }

    @NotNull
    public static List<Pair<PsiElement, PsiElement>> findDefinitions(@NotNull String name, @NotNull Collection<PsiReference> references, @NotNull Set<PsiElement> ignored) {
        if (name == null) {
            DeclarationConflictChecker.$$$reportNull$$$0(0);
        }
        if (references == null) {
            DeclarationConflictChecker.$$$reportNull$$$0(1);
        }
        if (ignored == null) {
            DeclarationConflictChecker.$$$reportNull$$$0(2);
        }
        ArrayList<Pair<PsiElement, PsiElement>> conflicts = new ArrayList<Pair<PsiElement, PsiElement>>();
        for (PsiReference ref : references) {
            PsiElement refElement = ref.getElement();
            ScopeOwner owner = ScopeUtil.getScopeOwner(refElement);
            if (owner == null) continue;
            for (PsiElement element : PyResolveUtil.resolveLocally(owner, name)) {
                if (ignored.contains(element)) continue;
                conflicts.add((Pair<PsiElement, PsiElement>)Pair.create((Object)refElement, (Object)element));
            }
        }
        ArrayList<Pair<PsiElement, PsiElement>> arrayList = conflicts;
        if (arrayList == null) {
            DeclarationConflictChecker.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    public static boolean showConflicts(Project project, List<Pair<PsiElement, PsiElement>> conflicts, String obscured, @Nullable String name) {
        if (conflicts.size() > 0) {
            Usage[] usages = new Usage[conflicts.size()];
            int i = 0;
            for (Pair<PsiElement, PsiElement> pair : conflicts) {
                usages[i] = new NameUsage((PsiElement)pair.getFirst(), (PsiElement)pair.getSecond(), name != null ? name : obscured, name != null);
                ++i;
            }
            UsageViewPresentation prsnt = new UsageViewPresentation();
            prsnt.setTabText(PyBundle.message("CONFLICT.name.$0.obscured", obscured));
            prsnt.setCodeUsagesString(PyBundle.message("CONFLICT.name.$0.obscured.cannot.convert", obscured));
            prsnt.setUsagesWord(PyBundle.message("CONFLICT.occurrence.sing", new Object[0]));
            prsnt.setUsagesString(PyBundle.message("CONFLICT.occurrence.pl", new Object[0]));
            UsageViewManager.getInstance((Project)project).showUsages(UsageTarget.EMPTY_ARRAY, usages, prsnt);
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "references";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignored";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/codeInsight/intentions/DeclarationConflictChecker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/codeInsight/intentions/DeclarationConflictChecker";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findDefinitions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findDefinitions";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

