/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.xdebugger.XDebugSession;
import com.jetbrains.python.run.PythonCommandLineState;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PyDebugSessionFactory {
    public static final ExtensionPointName<PyDebugSessionFactory> EP_NAME = ExtensionPointName.create((String)"Pythonid.debugSessionFactory");

    protected abstract boolean appliesTo(@NotNull Sdk var1);

    @NotNull
    public abstract XDebugSession createSession(@NotNull PythonCommandLineState var1, @NotNull ExecutionEnvironment var2) throws ExecutionException;

    @Contract(value="null -> null")
    @Nullable
    public static PyDebugSessionFactory findExtension(@Nullable Sdk sdk) {
        if (sdk == null) {
            return null;
        }
        for (PyDebugSessionFactory sessionCreator : (PyDebugSessionFactory[])EP_NAME.getExtensions()) {
            if (!sessionCreator.appliesTo(sdk)) continue;
            return sessionCreator;
        }
        return null;
    }
}

