/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.documentation;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PyNames;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.PythonDialectsTokenSetProvider;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.PythonHelpersLocator;
import com.jetbrains.python.documentation.DocumentationBuilderKit;
import com.jetbrains.python.documentation.PyDocumentationLink;
import com.jetbrains.python.documentation.PythonDocumentationProvider;
import com.jetbrains.python.documentation.docstrings.DocStringUtil;
import com.jetbrains.python.documentation.docstrings.PyStructuredDocstringFormatter;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.Property;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyCallable;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDocStringOwner;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyForStatement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTryExceptStatement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.StructuredDocString;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.impl.PyCallExpressionHelper;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.QualifiedNameFinder;
import com.jetbrains.python.psi.resolve.QualifiedResolveResult;
import com.jetbrains.python.psi.resolve.RootVisitor;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyDynamicallyEvaluatedType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.pyi.PyiUtil;
import com.jetbrains.python.toolbox.ChainIterable;
import com.jetbrains.python.toolbox.Maybe;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyDocumentationBuilder {
    private final PsiElement myElement;
    private final PsiElement myOriginalElement;
    private ChainIterable<String> myResult;
    private final ChainIterable<String> myProlog;
    private final ChainIterable<String> myBody;
    private final ChainIterable<String> myEpilog;
    private static final Pattern ourSpacesPattern = Pattern.compile("^\\s+");
    private final ChainIterable<String> myReassignmentChain;

    public PyDocumentationBuilder(PsiElement element, PsiElement originalElement) {
        this.myElement = element;
        this.myOriginalElement = originalElement;
        this.myResult = new ChainIterable();
        this.myProlog = new ChainIterable();
        this.myBody = new ChainIterable();
        this.myEpilog = new ChainIterable();
        this.myResult.add(this.myProlog).addWith(DocumentationBuilderKit.TagCode, this.myBody).add(this.myEpilog);
        this.myResult = DocumentationBuilderKit.wrapInTag("html", DocumentationBuilderKit.wrapInTag("body", this.myResult));
        this.myReassignmentChain = new ChainIterable();
    }

    @Nullable
    public String build() {
        String url;
        ASTNode node;
        TypeEvalContext context = TypeEvalContext.userInitiated(this.myElement.getProject(), this.myElement.getContainingFile());
        PsiElement outerElement = this.myOriginalElement != null ? this.myOriginalElement.getParent() : null;
        PsiElement elementDefinition = this.resolveToDocStringOwner(context);
        boolean isProperty = this.buildFromProperty(elementDefinition, outerElement, context);
        if (this.myProlog.isEmpty() && !isProperty && !this.isAttribute()) {
            this.myProlog.add(this.myReassignmentChain);
        }
        if (elementDefinition instanceof PyDocStringOwner) {
            this.buildFromDocstring(elementDefinition, isProperty);
        } else if (this.isAttribute()) {
            this.buildFromAttributeDoc();
        } else if (elementDefinition instanceof PyNamedParameter) {
            this.buildFromParameter(context, outerElement, elementDefinition);
        } else if (elementDefinition != null && outerElement instanceof PyReferenceExpression) {
            this.myBody.addItem(DocumentationBuilderKit.combUp("\nInferred type: "));
            PythonDocumentationProvider.describeTypeWithLinks(context.getType((PyReferenceExpression)outerElement), context, outerElement, this.myBody);
        }
        if (elementDefinition != null && (node = elementDefinition.getNode()) != null && PythonDialectsTokenSetProvider.INSTANCE.getKeywordTokens().contains(node.getElementType())) {
            PyForStatement statement;
            String documentationName = elementDefinition.getText();
            if (node.getElementType() == PyTokenTypes.AS_KEYWORD || node.getElementType() == PyTokenTypes.ELSE_KEYWORD) {
                PyTryExceptStatement statement2 = (PyTryExceptStatement)PsiTreeUtil.getParentOfType((PsiElement)elementDefinition, PyTryExceptStatement.class);
                if (statement2 != null) {
                    documentationName = "try";
                }
            } else if (node.getElementType() == PyTokenTypes.IN_KEYWORD && (statement = (PyForStatement)PsiTreeUtil.getParentOfType((PsiElement)elementDefinition, PyForStatement.class)) != null) {
                documentationName = "for";
            }
            this.buildForKeyword(documentationName);
        }
        if ((url = PythonDocumentationProvider.getUrlFor(this.myElement, this.myOriginalElement, false)) != null) {
            this.myEpilog.addItem("<br>");
            this.myEpilog.addWith(DocumentationBuilderKit.TagBold, DocumentationBuilderKit.$("External documentation:"));
            this.myEpilog.addItem("<br>");
            this.myEpilog.addItem("<a href=\"").addItem(url).addItem("\">").addItem(url).addItem("</a>");
        }
        if (this.myBody.isEmpty() && this.myEpilog.isEmpty()) {
            return null;
        }
        return this.myResult.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildForKeyword(@NotNull String name) {
        if (name == null) {
            PyDocumentationBuilder.$$$reportNull$$$0(0);
        }
        try {
            FileReader reader = new FileReader(PythonHelpersLocator.getHelperPath("/tools/python_keywords/" + name));
            try {
                String text = FileUtil.loadTextAndClose((Reader)reader);
                this.myEpilog.addItem(StringUtil.convertLineSeparators((String)text, (String)"\n"));
            }
            catch (IOException iOException) {
            }
            finally {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    private void buildFromParameter(@NotNull TypeEvalContext context, @Nullable PsiElement outerElement, @NotNull PsiElement elementDefinition) {
        PyType type;
        if (context == null) {
            PyDocumentationBuilder.$$$reportNull$$$0(1);
        }
        if (elementDefinition == null) {
            PyDocumentationBuilder.$$$reportNull$$$0(2);
        }
        this.myBody.addItem(DocumentationBuilderKit.combUp("Parameter " + PyUtil.getReadableRepr(elementDefinition, false)));
        boolean typeFromDocstringAdded = this.addTypeAndDescriptionFromDocstring((PyNamedParameter)elementDefinition, context);
        if (outerElement instanceof PyExpression && (type = context.getType((PyExpression)outerElement)) != null) {
            String targetName;
            PsiElement target2;
            String typeString = null;
            if (type instanceof PyDynamicallyEvaluatedType) {
                if (!typeFromDocstringAdded) {
                    typeString = "\nDynamically inferred type: ";
                }
            } else if (outerElement.getReference() != null && (target2 = outerElement.getReference().resolve()) instanceof PyTargetExpression && (targetName = ((PyTargetExpression)target2).getName()) != null && targetName.equals(((PyNamedParameter)elementDefinition).getName())) {
                typeString = "\nReassigned value has type: ";
            }
            if (typeString == null && !typeFromDocstringAdded) {
                typeString = "\nInferred type: ";
            }
            if (typeString != null) {
                this.myBody.addItem(DocumentationBuilderKit.combUp(typeString));
                PythonDocumentationProvider.describeTypeWithLinks(type, context, elementDefinition, this.myBody);
            }
        }
    }

    private boolean buildFromProperty(PsiElement elementDefinition, @Nullable PsiElement outerElement, @NotNull TypeEvalContext context) {
        if (context == null) {
            PyDocumentationBuilder.$$$reportNull$$$0(3);
        }
        if (this.myOriginalElement == null) {
            return false;
        }
        String elementName = this.myOriginalElement.getText();
        if (!PyNames.isIdentifier(elementName)) {
            return false;
        }
        if (!(outerElement instanceof PyQualifiedExpression)) {
            return false;
        }
        PyExpression qualifier = ((PyQualifiedExpression)outerElement).getQualifier();
        if (qualifier == null) {
            return false;
        }
        PyType type = context.getType(qualifier);
        if (!(type instanceof PyClassType)) {
            return false;
        }
        PyClass cls = ((PyClassType)type).getPyClass();
        Property property = cls.findProperty(elementName, true, null);
        if (property == null) {
            return false;
        }
        AccessDirection direction = AccessDirection.of((PyElement)outerElement);
        Maybe<PyCallable> accessor = property.getByDirection(direction);
        this.myProlog.addItem("property ").addWith(DocumentationBuilderKit.TagBold, DocumentationBuilderKit.$(new String[0]).addWith(DocumentationBuilderKit.TagCode, DocumentationBuilderKit.$(elementName))).addItem(" of ").add(PythonDocumentationProvider.describeClass(cls, Function.identity(), DocumentationBuilderKit.TO_ONE_LINE_AND_ESCAPE, true, true, context));
        if (accessor.isDefined() && property.getDoc() != null) {
            this.myBody.addItem(": ").addItem(property.getDoc()).addItem("<br>");
        } else {
            PyStringLiteralExpression docstring;
            PyCallable getter = property.getGetter().valueOrNull();
            if (getter != null && getter != this.myElement && getter instanceof PyFunction && (docstring = PyDocumentationBuilder.getEffectiveDocStringExpression((PyFunction)getter)) != null) {
                this.myProlog.addItem("<br>").addWith(DocumentationBuilderKit.TagItalic, DocumentationBuilderKit.$("Copied from getter:")).addItem("<br>").addItem(docstring.getStringValue());
            }
            this.myBody.addItem("<br>");
        }
        this.myBody.addItem("<br>");
        if (accessor.isDefined() && accessor.value() == null) {
            elementDefinition = null;
        }
        String accessorKind = PyDocumentationBuilder.getAccessorKind(direction);
        if (elementDefinition != null) {
            this.myEpilog.addWith(DocumentationBuilderKit.TagSmall, DocumentationBuilderKit.$("<br>", "<br>", accessorKind, " of property")).addItem("<br>");
        }
        if (!(elementDefinition instanceof PyDocStringOwner)) {
            this.myBody.addWith(DocumentationBuilderKit.TagItalic, elementDefinition != null ? DocumentationBuilderKit.$("Declaration: ") : DocumentationBuilderKit.$(accessorKind + " is not defined.")).addItem("<br>");
            if (elementDefinition != null) {
                this.myBody.addItem(DocumentationBuilderKit.combUp(PyUtil.getReadableRepr(elementDefinition, false)));
            }
        }
        return true;
    }

    @NotNull
    private static String getAccessorKind(@NotNull AccessDirection dir) {
        if (dir == null) {
            PyDocumentationBuilder.$$$reportNull$$$0(4);
        }
        String accessorKind = dir == AccessDirection.READ ? "Getter" : (dir == AccessDirection.WRITE ? "Setter" : "Deleter");
        String string = accessorKind;
        if (string == null) {
            PyDocumentationBuilder.$$$reportNull$$$0(5);
        }
        return string;
    }

    private void buildFromDocstring(@NotNull PsiElement elementDefinition, boolean isProperty) {
        if (elementDefinition == null) {
            PyDocumentationBuilder.$$$reportNull$$$0(6);
        }
        PyClass pyClass = null;
        PyStringLiteralExpression docStringExpression = PyDocumentationBuilder.getEffectiveDocStringExpression((PyDocStringOwner)elementDefinition);
        TypeEvalContext context = TypeEvalContext.userInitiated(elementDefinition.getProject(), elementDefinition.getContainingFile());
        if (elementDefinition instanceof PyClass) {
            pyClass = (PyClass)elementDefinition;
            this.myBody.add(PythonDocumentationProvider.describeDecorators(pyClass, DocumentationBuilderKit.WRAP_IN_ITALIC, DocumentationBuilderKit.ESCAPE_AND_SAVE_NEW_LINES_AND_SPACES, "<br>", "<br>"));
            this.myBody.add(PythonDocumentationProvider.describeClass(pyClass, DocumentationBuilderKit.WRAP_IN_BOLD, DocumentationBuilderKit.ESCAPE_AND_SAVE_NEW_LINES_AND_SPACES, false, true, context));
        } else if (elementDefinition instanceof PyFunction) {
            PyFunction pyFunction = (PyFunction)elementDefinition;
            if (!isProperty && (pyClass = pyFunction.getContainingClass()) != null) {
                this.myBody.addWith(DocumentationBuilderKit.TagSmall, PythonDocumentationProvider.describeClass(pyClass, Function.identity(), DocumentationBuilderKit.TO_ONE_LINE_AND_ESCAPE, true, true, context)).addItem("<br>").addItem("<br>");
            }
            this.myBody.add(PythonDocumentationProvider.describeDecorators(pyFunction, DocumentationBuilderKit.WRAP_IN_ITALIC, DocumentationBuilderKit.ESCAPE_AND_SAVE_NEW_LINES_AND_SPACES, "<br>", "<br>"));
            this.myBody.add(PythonDocumentationProvider.describeFunction(pyFunction, DocumentationBuilderKit.WRAP_IN_BOLD, DocumentationBuilderKit.ESCAPE_AND_SAVE_NEW_LINES_AND_SPACES, context));
            if (docStringExpression == null) {
                this.addInheritedDocString(pyFunction, pyClass);
            }
        } else if (elementDefinition instanceof PyFile) {
            this.addModulePath((PyFile)elementDefinition);
        }
        if (docStringExpression != null) {
            this.myBody.addItem("<br>");
            PyDocumentationBuilder.addFormattedDocString(this.myElement, docStringExpression.getStringValue(), this.myBody, this.myEpilog);
        }
    }

    private boolean isAttribute() {
        return this.myElement instanceof PyTargetExpression && PyUtil.isAttribute((PyTargetExpression)this.myElement);
    }

    @Nullable
    private PsiElement resolveToDocStringOwner(@NotNull TypeEvalContext context) {
        PyCallExpression call;
        Pair<String, PyFunction> wrapInfo;
        if (context == null) {
            PyDocumentationBuilder.$$$reportNull$$$0(7);
        }
        if (this.myElement instanceof PyTargetExpression) {
            PsiElement resolved;
            String targetName = this.myElement.getText();
            this.myReassignmentChain.addWith(DocumentationBuilderKit.TagSmall, DocumentationBuilderKit.$(PyBundle.message("QDOC.assigned.to.$0", targetName)).addItem("<br>"));
            PyExpression assignedValue = ((PyTargetExpression)this.myElement).findAssignedValue();
            if (assignedValue instanceof PyReferenceExpression && (resolved = PyDocumentationBuilder.resolveWithoutImplicits((PyReferenceExpression)assignedValue, context)) != null) {
                return resolved;
            }
            return assignedValue;
        }
        if (this.myElement instanceof PyReferenceExpression) {
            this.myReassignmentChain.addWith(DocumentationBuilderKit.TagSmall, DocumentationBuilderKit.$(PyBundle.message("QDOC.assigned.to.$0", this.myElement.getText())).addItem("<br>"));
            return PyDocumentationBuilder.resolveWithoutImplicits((PyReferenceExpression)this.myElement, context);
        }
        if (this.myElement instanceof PyCallExpression && (wrapInfo = PyCallExpressionHelper.interpretAsModifierWrappingCall(call = (PyCallExpression)this.myElement)) != null) {
            String wrapperName = (String)wrapInfo.getFirst();
            PyFunction wrappedFunction = (PyFunction)wrapInfo.getSecond();
            this.myReassignmentChain.addWith(DocumentationBuilderKit.TagSmall, DocumentationBuilderKit.$(PyBundle.message("QDOC.wrapped.in.$0", wrapperName)).addItem("<br>"));
            return wrappedFunction;
        }
        return this.myElement;
    }

    @Nullable
    private static PsiElement resolveWithoutImplicits(@NotNull PyReferenceExpression element, @NotNull TypeEvalContext context) {
        PyResolveContext resolveContext;
        QualifiedResolveResult resolveResult;
        if (element == null) {
            PyDocumentationBuilder.$$$reportNull$$$0(8);
        }
        if (context == null) {
            PyDocumentationBuilder.$$$reportNull$$$0(9);
        }
        return (resolveResult = element.followAssignmentsChain(resolveContext = PyResolveContext.noImplicits().withTypeEvalContext(context))).isImplicit() ? null : resolveResult.getElement();
    }

    private void addInheritedDocString(@NotNull PyFunction pyFunction, @Nullable PyClass pyClass) {
        if (pyFunction == null) {
            PyDocumentationBuilder.$$$reportNull$$$0(10);
        }
        boolean notFound = true;
        String methodName = pyFunction.getName();
        if (pyClass == null || methodName == null) {
            return;
        }
        boolean isConstructor = "__init__".equals(methodName);
        Iterable<PyClass> classes = pyClass.getAncestorClasses(null);
        if (isConstructor) {
            classes = new ChainIterable<PyClass>(pyClass).add(classes);
        }
        for (PyClass ancestor : classes) {
            String ancestorLink;
            String inheritedDoc;
            PyStringLiteralExpression docstringElement = null;
            PyFunction inherited = null;
            boolean isFromClass = false;
            if (isConstructor) {
                docstringElement = PyDocumentationBuilder.getEffectiveDocStringExpression(pyClass);
            }
            if (docstringElement != null) {
                isFromClass = true;
            } else {
                inherited = ancestor.findMethodByName(methodName, false, null);
            }
            if (inherited != null) {
                docstringElement = PyDocumentationBuilder.getEffectiveDocStringExpression(inherited);
            }
            if (docstringElement == null || (inheritedDoc = docstringElement.getStringValue()).length() <= 1) continue;
            this.myEpilog.addItem("<br>").addItem("<br>");
            String ancestorName = ancestor.getName();
            String ancestorQualifiedName = ancestor.getQualifiedName();
            TypeEvalContext context = TypeEvalContext.userInitiated(pyFunction.getProject(), pyFunction.getContainingFile());
            String string = pyClass == ancestor ? PyDocumentationLink.toContainingClass(ancestorName) : (ancestorLink = ancestorName != null && ancestorQualifiedName != null ? PyDocumentationLink.toPossibleClass(ancestorName, ancestorQualifiedName, (PsiElement)pyClass, context) : null);
            if (isFromClass) {
                this.myEpilog.addItem(PyBundle.message("QDOC.copied.from.class.$0", ancestorLink));
            } else {
                this.myEpilog.addItem(PyBundle.message("QDOC.copied.from.$0.$1", ancestorLink, methodName));
            }
            this.myEpilog.addItem("<br>").addItem("<br>");
            ChainIterable<String> formatted = new ChainIterable<String>();
            ChainIterable<String> unformatted = new ChainIterable<String>();
            PyDocumentationBuilder.addFormattedDocString(pyFunction, inheritedDoc, formatted, unformatted);
            this.myEpilog.addWith(DocumentationBuilderKit.TagCode, formatted).add(unformatted);
            notFound = false;
            break;
        }
        if (notFound && PyNames.UNDERSCORED_ATTRIBUTES.contains((Object)methodName)) {
            this.addPredefinedMethodDoc(pyFunction, methodName);
        }
    }

    private void addPredefinedMethodDoc(PyFunction fun, String methodName) {
        PyClass objectClass;
        PyFunction predefinedMethod;
        PyClassType objectType = PyBuiltinCache.getInstance(fun).getObjectType();
        if (objectType != null && (predefinedMethod = (objectClass = objectType.getPyClass()).findMethodByName(methodName, false, null)) != null) {
            String predefinedDoc;
            PyStringLiteralExpression predefinedDocstring = PyDocumentationBuilder.getEffectiveDocStringExpression(predefinedMethod);
            String string = predefinedDoc = predefinedDocstring != null ? predefinedDocstring.getStringValue() : null;
            if (predefinedDoc != null && predefinedDoc.length() > 1) {
                PyDocumentationBuilder.addFormattedDocString(fun, predefinedDoc, this.myBody, this.myBody);
                this.myEpilog.addItem("<br>").addItem("<br>").addItem(PyBundle.message("QDOC.copied.from.builtin", new Object[0]));
            }
        }
    }

    private static void addFormattedDocString(@NotNull PsiElement element, @NotNull String docstring, @NotNull ChainIterable<String> formattedOutput, @NotNull ChainIterable<String> unformattedOutput) {
        if (element == null) {
            PyDocumentationBuilder.$$$reportNull$$$0(11);
        }
        if (docstring == null) {
            PyDocumentationBuilder.$$$reportNull$$$0(12);
        }
        if (formattedOutput == null) {
            PyDocumentationBuilder.$$$reportNull$$$0(13);
        }
        if (unformattedOutput == null) {
            PyDocumentationBuilder.$$$reportNull$$$0(14);
        }
        Project project = element.getProject();
        List<String> formatted = PyStructuredDocstringFormatter.formatDocstring(element, docstring);
        if (formatted != null) {
            unformattedOutput.add(formatted);
            return;
        }
        ArrayList<String> result2 = new ArrayList<String>();
        String[] lines2 = PyDocumentationBuilder.removeCommonIndentation(docstring);
        boolean isFirstLine = true;
        int tabSize = CodeStyleSettingsManager.getSettings((Project)project).getTabSize((FileType)PythonFileType.INSTANCE);
        for (String line : lines2) {
            int leadingTabs;
            if (isFirstLine && ourSpacesPattern.matcher(line).matches()) continue;
            if (isFirstLine) {
                isFirstLine = false;
            } else {
                result2.add("<br>");
            }
            for (leadingTabs = 0; leadingTabs < line.length() && line.charAt(leadingTabs) == '\t'; ++leadingTabs) {
            }
            if (leadingTabs > 0) {
                line = StringUtil.repeatSymbol((char)' ', (int)(tabSize * leadingTabs)) + line.substring(leadingTabs);
            }
            result2.add(DocumentationBuilderKit.combUp(line));
        }
        formattedOutput.add(result2);
    }

    private boolean addTypeAndDescriptionFromDocstring(@NotNull PyNamedParameter parameter, @NotNull TypeEvalContext context) {
        PyFunction function;
        if (parameter == null) {
            PyDocumentationBuilder.$$$reportNull$$$0(15);
        }
        if (context == null) {
            PyDocumentationBuilder.$$$reportNull$$$0(16);
        }
        if ((function = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)parameter, PyFunction.class)) != null) {
            String docString = PyPsiUtils.strValue(PyDocumentationBuilder.getEffectiveDocStringExpression(function));
            Pair<String, String> typeAndDescr = PyDocumentationBuilder.getTypeAndDescription(docString, parameter);
            String type = (String)typeAndDescr.first;
            String description = (String)typeAndDescr.second;
            if (type != null) {
                this.myBody.addItem(": ").addItem(PyDocumentationLink.toParameterPossibleClass(type, parameter, context));
            }
            if (description != null) {
                this.myEpilog.addItem("<br>").addItem(description);
            }
            return type != null;
        }
        return false;
    }

    private static Pair<String, String> getTypeAndDescription(@Nullable String docString, @NotNull PyNamedParameter followed) {
        if (followed == null) {
            PyDocumentationBuilder.$$$reportNull$$$0(17);
        }
        String type = null;
        String desc = null;
        if (docString != null) {
            StructuredDocString structuredDocString = DocStringUtil.parse(docString);
            String name = followed.getName();
            type = structuredDocString.getParamType(name);
            desc = structuredDocString.getParamDescription(name);
        }
        return Pair.create(type, desc);
    }

    private void buildFromAttributeDoc() {
        PyClass cls = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)this.myElement, PyClass.class);
        assert (cls != null);
        String type = PyUtil.isInstanceAttribute((PyExpression)this.myElement) ? "Instance attribute " : "Class attribute ";
        this.myProlog.addItem(type).addWith(DocumentationBuilderKit.TagBold, DocumentationBuilderKit.$(new String[0]).addWith(DocumentationBuilderKit.TagCode, DocumentationBuilderKit.$(((PyTargetExpression)this.myElement).getName()))).addItem(" of class ").addItem(PyDocumentationLink.toContainingClass(DocumentationBuilderKit.WRAP_IN_CODE.apply(cls.getName()))).addItem("<br>");
        String docString = PyPsiUtils.strValue(PyDocumentationBuilder.getEffectiveDocStringExpression((PyTargetExpression)this.myElement));
        if (docString != null) {
            PyDocumentationBuilder.addFormattedDocString(this.myElement, docString, this.myBody, this.myEpilog);
        }
    }

    public static String[] removeCommonIndentation(@NotNull String docstring) {
        if (docstring == null) {
            PyDocumentationBuilder.$$$reportNull$$$0(18);
        }
        String[] lines2 = LineTokenizer.tokenize((CharSequence)docstring, (boolean)false);
        boolean isFirst = true;
        int cutWidth = Integer.MAX_VALUE;
        int firstIndentedLine = 0;
        for (String frag : lines2) {
            if (frag.length() == 0) continue;
            int padWidth = 0;
            Matcher matcher = ourSpacesPattern.matcher(frag);
            if (matcher.find()) {
                padWidth = matcher.end();
            }
            if (isFirst) {
                isFirst = false;
                if (padWidth == 0) {
                    firstIndentedLine = 1;
                    continue;
                }
            }
            if (padWidth >= cutWidth) continue;
            cutWidth = padWidth;
        }
        if (cutWidth > 0 && cutWidth < Integer.MAX_VALUE) {
            for (int i = firstIndentedLine; i < lines2.length; ++i) {
                if (lines2[i].length() < cutWidth) continue;
                lines2[i] = lines2[i].substring(cutWidth);
            }
        }
        ArrayList<String> result2 = new ArrayList<String>();
        for (String line : lines2) {
            if (line.startsWith(">>>")) break;
            result2.add(line);
        }
        return ArrayUtil.toStringArray(result2);
    }

    private void addModulePath(@NotNull PyFile followed) {
        VirtualFile file2;
        if (followed == null) {
            PyDocumentationBuilder.$$$reportNull$$$0(19);
        }
        if ((file2 = followed.getVirtualFile()) == null) {
            this.myProlog.addWith(DocumentationBuilderKit.TagSmall, DocumentationBuilderKit.$(PyBundle.message("QDOC.module.path.unknown", new Object[0])));
        } else {
            QualifiedName name = QualifiedNameFinder.findShortestImportableQName((PsiFileSystemItem)followed);
            if (name != null) {
                this.myProlog.add(DocumentationBuilderKit.$("Module ")).addWith(DocumentationBuilderKit.TagBold, DocumentationBuilderKit.$(((QualifiedName)ObjectUtils.chooseNotNull((Object)QualifiedNameFinder.canonizeQualifiedName(name, null), (Object)name)).toString()));
            } else {
                String path = file2.getPath();
                this.myProlog.addWith(DocumentationBuilderKit.TagSpan.withAttribute("path", path), DocumentationBuilderKit.$("").addWith(DocumentationBuilderKit.TagSmall, DocumentationBuilderKit.$(path)));
            }
        }
    }

    @Nullable
    static PyStringLiteralExpression getEffectiveDocStringExpression(@NotNull PyDocStringOwner owner) {
        PyStringLiteralExpression expression;
        if (owner == null) {
            PyDocumentationBuilder.$$$reportNull$$$0(20);
        }
        if ((expression = owner.getDocStringExpression()) != null && StringUtil.isNotEmpty((String)PyPsiUtils.strValue(expression))) {
            return expression;
        }
        PsiElement original = PyiUtil.getOriginalElement(owner);
        PyDocStringOwner originalOwner = PyUtil.as(original, PyDocStringOwner.class);
        return originalOwner != null ? originalOwner.getDocStringExpression() : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 9: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementDefinition";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/documentation/PyDocumentationBuilder";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pyFunction";
                break;
            }
            case 12: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docstring";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formattedOutput";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unformattedOutput";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "followed";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/documentation/PyDocumentationBuilder";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessorKind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildForKeyword";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildFromParameter";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "buildFromProperty";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getAccessorKind";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "buildFromDocstring";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "resolveToDocStringOwner";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "resolveWithoutImplicits";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addInheritedDocString";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addFormattedDocString";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addTypeAndDescriptionFromDocstring";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getTypeAndDescription";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "removeCommonIndentation";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "addModulePath";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getEffectiveDocStringExpression";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class RootFinder
    implements RootVisitor {
        private String myResult;
        private final String myPath;

        private RootFinder(String path) {
            this.myPath = path;
        }

        @Override
        public boolean visitRoot(@NotNull VirtualFile root, @Nullable Module module2, @Nullable Sdk sdk, boolean isModuleSource) {
            String vpath;
            if (root == null) {
                RootFinder.$$$reportNull$$$0(0);
            }
            if (this.myPath.startsWith(vpath = VfsUtilCore.urlToPath((String)root.getUrl()))) {
                this.myResult = vpath;
                return false;
            }
            return true;
        }

        String getResult() {
            return this.myResult;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/jetbrains/python/documentation/PyDocumentationBuilder$RootFinder", "visitRoot"));
        }
    }
}

