/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.editor;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.AutoHardWrapHandler;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegateAdapter;
import com.intellij.ide.DataManager;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.ASTNode;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actions.SplitLineAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.codeInsight.PyCodeInsightSettings;
import com.jetbrains.python.documentation.docstrings.DocStringFormat;
import com.jetbrains.python.documentation.docstrings.DocStringUtil;
import com.jetbrains.python.documentation.docstrings.GoogleCodeStyleDocString;
import com.jetbrains.python.documentation.docstrings.GoogleCodeStyleDocStringBuilder;
import com.jetbrains.python.documentation.docstrings.PyDocstringGenerator;
import com.jetbrains.python.documentation.docstrings.SectionBasedDocString;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyDecoratorList;
import com.jetbrains.python.psi.PyDictCompExpression;
import com.jetbrains.python.psi.PyDictLiteralExpression;
import com.jetbrains.python.psi.PyDocStringOwner;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyGeneratorExpression;
import com.jetbrains.python.psi.PyIndentUtil;
import com.jetbrains.python.psi.PyListCompExpression;
import com.jetbrains.python.psi.PyListLiteralExpression;
import com.jetbrains.python.psi.PyParameterList;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PySetCompExpression;
import com.jetbrains.python.psi.PySetLiteralExpression;
import com.jetbrains.python.psi.PySliceExpression;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PySubscriptionExpression;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.impl.PyStringLiteralExpressionImpl;
import java.util.regex.Matcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PythonEnterHandler
extends EnterHandlerDelegateAdapter {
    private int myPostprocessShift = 0;
    public static final Class[] IMPLICIT_WRAP_CLASSES = new Class[]{PyListLiteralExpression.class, PySetLiteralExpression.class, PyDictLiteralExpression.class, PyDictLiteralExpression.class, PyParenthesizedExpression.class, PyArgumentList.class, PyParameterList.class};
    private static final Class[] WRAPPABLE_CLASSES = new Class[]{PsiComment.class, PyParenthesizedExpression.class, PyListCompExpression.class, PyDictCompExpression.class, PySetCompExpression.class, PyDictLiteralExpression.class, PySetLiteralExpression.class, PyListLiteralExpression.class, PyArgumentList.class, PyParameterList.class, PyDecoratorList.class, PySliceExpression.class, PySubscriptionExpression.class, PyGeneratorExpression.class};

    @Override
    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile file2, @NotNull Editor editor, @NotNull Ref<Integer> caretOffset, @NotNull Ref<Integer> caretAdvance, @NotNull DataContext dataContext, EditorActionHandler originalHandler) {
        PsiElement prevElement;
        if (file2 == null) {
            PythonEnterHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            PythonEnterHandler.$$$reportNull$$$0(1);
        }
        if (caretOffset == null) {
            PythonEnterHandler.$$$reportNull$$$0(2);
        }
        if (caretAdvance == null) {
            PythonEnterHandler.$$$reportNull$$$0(3);
        }
        if (dataContext == null) {
            PythonEnterHandler.$$$reportNull$$$0(4);
        }
        int offset = (Integer)caretOffset.get();
        if (editor instanceof EditorWindow) {
            file2 = InjectedLanguageManager.getInstance((Project)file2.getProject()).getTopLevelFile((PsiElement)file2);
            editor = InjectedLanguageUtil.getTopLevelEditor(editor);
            offset = editor.getCaretModel().getOffset();
        }
        if (!(file2 instanceof PyFile)) {
            return EnterHandlerDelegate.Result.Continue;
        }
        Boolean isSplitLine = (Boolean)DataManager.getInstance().loadFromDataContext(dataContext, SplitLineAction.SPLIT_LINE_KEY);
        if (isSplitLine != null) {
            return EnterHandlerDelegate.Result.Continue;
        }
        Document doc = editor.getDocument();
        PsiDocumentManager.getInstance((Project)file2.getProject()).commitDocument(doc);
        PsiElement element = file2.findElementAt(offset);
        CodeInsightSettings codeInsightSettings = CodeInsightSettings.getInstance();
        if (codeInsightSettings.JAVADOC_STUB_ON_ENTER) {
            DocstringState state2;
            PsiElement comment = element;
            if (comment == null && offset != 0) {
                comment = file2.findElementAt(offset - 1);
            }
            int expectedStringStart = editor.getCaretModel().getOffset() - 3;
            if (comment != null && (state2 = PythonEnterHandler.canGenerateDocstring(comment, expectedStringStart, doc)) != DocstringState.NONE) {
                PythonEnterHandler.insertDocStringStub(editor, comment, state2);
                return EnterHandlerDelegate.Result.Continue;
            }
        }
        if (element == null) {
            return EnterHandlerDelegate.Result.Continue;
        }
        PsiElement elementParent = element.getParent();
        if (element.getNode().getElementType() == PyTokenTypes.LPAR) {
            elementParent = elementParent.getParent();
        }
        if (elementParent instanceof PyParenthesizedExpression || elementParent instanceof PyGeneratorExpression) {
            return EnterHandlerDelegate.Result.Continue;
        }
        if (offset > 0 && !PyTokenTypes.STRING_NODES.contains(element.getNode().getElementType()) && (prevElement = file2.findElementAt(offset - 1)) == element) {
            return EnterHandlerDelegate.Result.Continue;
        }
        if (PyTokenTypes.TRIPLE_NODES.contains(element.getNode().getElementType()) || element.getNode().getElementType() == PyTokenTypes.DOCSTRING) {
            return EnterHandlerDelegate.Result.Continue;
        }
        prevElement = file2.findElementAt(offset - 1);
        PyStringLiteralExpression string = (PyStringLiteralExpression)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file2, (int)offset, PyStringLiteralExpression.class, (boolean)false);
        if (string != null && prevElement != null && PyTokenTypes.STRING_NODES.contains(prevElement.getNode().getElementType()) && string.getTextOffset() < offset && !(element.getNode() instanceof PsiWhiteSpace)) {
            boolean isEscapedBackslash;
            String stringText = element.getText();
            int prefixLength = PyStringLiteralExpressionImpl.getPrefixLength(stringText);
            if (string.getTextOffset() + prefixLength >= offset) {
                return EnterHandlerDelegate.Result.Continue;
            }
            String pref = element.getText().substring(0, prefixLength);
            String quote = element.getText().substring(prefixLength, prefixLength + 1);
            boolean nextIsBackslash = "\\".equals(doc.getText(TextRange.create((int)(offset - 1), (int)offset)));
            boolean isEscapedQuote = quote.equals(doc.getText(TextRange.create((int)offset, (int)(offset + 1)))) && nextIsBackslash;
            boolean bl = isEscapedBackslash = "\\".equals(doc.getText(TextRange.create((int)(offset - 2), (int)(offset - 1)))) && nextIsBackslash;
            if (nextIsBackslash && !isEscapedQuote && !isEscapedBackslash) {
                return EnterHandlerDelegate.Result.Continue;
            }
            StringBuilder replacementString = new StringBuilder();
            this.myPostprocessShift = prefixLength + quote.length();
            if (PsiTreeUtil.getParentOfType((PsiElement)string, (Class[])IMPLICIT_WRAP_CLASSES) != null) {
                replacementString.append(quote).append(pref).append(quote);
                doc.insertString(offset, (CharSequence)replacementString);
                caretOffset.set((Object)((Integer)caretOffset.get() + 1));
                return EnterHandlerDelegate.Result.Continue;
            }
            if (isEscapedQuote) {
                replacementString.append(quote);
                caretOffset.set((Object)((Integer)caretOffset.get() + 1));
            }
            replacementString.append(quote).append(" \\").append(pref);
            if (!isEscapedQuote) {
                replacementString.append(quote);
            }
            doc.insertString(offset, (CharSequence)replacementString.toString());
            caretOffset.set((Object)((Integer)caretOffset.get() + 3));
            return EnterHandlerDelegate.Result.Continue;
        }
        if (!PyCodeInsightSettings.getInstance().INSERT_BACKSLASH_ON_WRAP) {
            return EnterHandlerDelegate.Result.Continue;
        }
        return PythonEnterHandler.checkInsertBackslash(file2, caretOffset, dataContext, offset, doc);
    }

    private static EnterHandlerDelegate.Result checkInsertBackslash(PsiFile file2, Ref<Integer> caretOffset, DataContext dataContext, int offset, Document doc) {
        boolean autoWrapInProgress;
        boolean bl = autoWrapInProgress = DataManager.getInstance().loadFromDataContext(dataContext, AutoHardWrapHandler.AUTO_WRAP_LINE_IN_PROGRESS_KEY) != null;
        if (PythonEnterHandler.needInsertBackslash(file2, offset, autoWrapInProgress)) {
            doc.insertString(offset, (CharSequence)"\\");
            caretOffset.set((Object)((Integer)caretOffset.get() + 1));
        }
        return EnterHandlerDelegate.Result.Continue;
    }

    public static boolean needInsertBackslash(PsiFile file2, int offset, boolean autoWrapInProgress) {
        PsiElement beforeCaret;
        if (offset > 0 && (beforeCaret = file2.findElementAt(offset - 1)) instanceof PsiWhiteSpace && beforeCaret.getText().indexOf(92) >= 0) {
            return false;
        }
        PsiElement atCaret = file2.findElementAt(offset);
        if (atCaret == null) {
            return false;
        }
        ASTNode nodeAtCaret = atCaret.getNode();
        return PythonEnterHandler.needInsertBackslash(nodeAtCaret, autoWrapInProgress);
    }

    public static boolean needInsertBackslash(ASTNode nodeAtCaret, boolean autoWrapInProgress) {
        PsiElement next;
        PsiElement statementAfter;
        PsiElement statementBefore = PythonEnterHandler.findStatementBeforeCaret(nodeAtCaret);
        if (statementBefore != (statementAfter = PythonEnterHandler.findStatementAfterCaret(nodeAtCaret))) {
            return false;
        }
        if (statementBefore == null) {
            return false;
        }
        if (PsiTreeUtil.hasErrorElements((PsiElement)statementBefore) && !autoWrapInProgress) {
            return false;
        }
        if (PythonEnterHandler.inFromImportParentheses(statementBefore, nodeAtCaret.getTextRange().getStartOffset())) {
            return false;
        }
        PsiElement wrappableBefore = PythonEnterHandler.findWrappable(nodeAtCaret, true);
        PsiElement wrappableAfter = PythonEnterHandler.findWrappable(nodeAtCaret, false);
        if (!(wrappableBefore instanceof PsiComment)) {
            while (wrappableBefore != null && (next = PsiTreeUtil.getParentOfType((PsiElement)wrappableBefore, (Class[])WRAPPABLE_CLASSES)) != null) {
                wrappableBefore = next;
            }
        }
        if (!(wrappableAfter instanceof PsiComment)) {
            while (wrappableAfter != null && (next = PsiTreeUtil.getParentOfType((PsiElement)wrappableAfter, (Class[])WRAPPABLE_CLASSES)) != null) {
                wrappableAfter = next;
            }
        }
        if (wrappableBefore instanceof PsiComment || wrappableAfter instanceof PsiComment) {
            return false;
        }
        if (wrappableAfter == null) {
            return !(wrappableBefore instanceof PyDecoratorList);
        }
        return wrappableBefore != wrappableAfter;
    }

    private static void insertDocStringStub(Editor editor, PsiElement element, DocstringState state2) {
        PyDocStringOwner docOwner = (PyDocStringOwner)PsiTreeUtil.getParentOfType((PsiElement)element, PyDocStringOwner.class);
        if (docOwner != null) {
            int caretOffset = editor.getCaretModel().getOffset();
            Document document = editor.getDocument();
            String quotes = document.getText(TextRange.from((int)(caretOffset - 3), (int)3));
            String docString = PyDocstringGenerator.forDocStringOwner(docOwner).withInferredParameters(true).withQuotes(quotes).forceNewMode().buildDocString();
            if (state2 == DocstringState.INCOMPLETE) {
                document.insertString(caretOffset, (CharSequence)docString.substring(3));
            } else if (state2 == DocstringState.EMPTY) {
                document.replaceString(caretOffset, caretOffset + 3, (CharSequence)docString.substring(3));
            }
        }
    }

    @Nullable
    private static PsiElement findWrappable(ASTNode nodeAtCaret, boolean before) {
        PsiElement wrappable;
        PsiElement psiElement = wrappable = before ? PythonEnterHandler.findBeforeCaret(nodeAtCaret, WRAPPABLE_CLASSES) : PythonEnterHandler.findAfterCaret(nodeAtCaret, WRAPPABLE_CLASSES);
        if (wrappable == null) {
            PsiElement emptyTuple;
            PsiElement psiElement2 = emptyTuple = before ? PythonEnterHandler.findBeforeCaret(nodeAtCaret, PyTupleExpression.class) : PythonEnterHandler.findAfterCaret(nodeAtCaret, PyTupleExpression.class);
            if (emptyTuple != null && emptyTuple.getNode().getFirstChildNode().getElementType() == PyTokenTypes.LPAR) {
                wrappable = emptyTuple;
            }
        }
        return wrappable;
    }

    @Nullable
    private static PsiElement findStatementBeforeCaret(ASTNode node) {
        return PythonEnterHandler.findBeforeCaret(node, PyStatement.class);
    }

    @Nullable
    private static PsiElement findStatementAfterCaret(ASTNode node) {
        return PythonEnterHandler.findAfterCaret(node, PyStatement.class);
    }

    private static PsiElement findBeforeCaret(ASTNode atCaret, Class<? extends PsiElement> ... classes) {
        while (atCaret != null) {
            if ((atCaret = TreeUtil.prevLeaf(atCaret)) == null || atCaret.getElementType() == TokenType.WHITE_SPACE) continue;
            return PythonEnterHandler.getNonStrictParentOfType(atCaret.getPsi(), classes);
        }
        return null;
    }

    private static PsiElement findAfterCaret(ASTNode atCaret, Class<? extends PsiElement> ... classes) {
        while (atCaret != null) {
            if (atCaret.getElementType() != TokenType.WHITE_SPACE) {
                return PythonEnterHandler.getNonStrictParentOfType(atCaret.getPsi(), classes);
            }
            atCaret = TreeUtil.nextLeaf(atCaret);
        }
        return null;
    }

    @Nullable
    private static <T extends PsiElement> T getNonStrictParentOfType(@NotNull PsiElement element, Class<? extends T> ... classes) {
        if (element == null) {
            PythonEnterHandler.$$$reportNull$$$0(5);
        }
        if (classes == null) {
            PythonEnterHandler.$$$reportNull$$$0(6);
        }
        for (PsiElement run2 = element; run2 != null; run2 = run2.getParent()) {
            for (Class<T> clazz : classes) {
                if (!clazz.isInstance(run2)) continue;
                return (T)run2;
            }
            if (run2 instanceof PsiFile || run2 instanceof PyStatementList) break;
        }
        return null;
    }

    private static boolean inFromImportParentheses(PsiElement statement, int offset) {
        if (!(statement instanceof PyFromImportStatement)) {
            return false;
        }
        PyFromImportStatement fromImportStatement = (PyFromImportStatement)statement;
        PsiElement leftParen = fromImportStatement.getLeftParen();
        return leftParen != null && offset >= leftParen.getTextRange().getEndOffset();
    }

    @Override
    public EnterHandlerDelegate.Result postProcessEnter(@NotNull PsiFile file2, @NotNull Editor editor, @NotNull DataContext dataContext) {
        if (file2 == null) {
            PythonEnterHandler.$$$reportNull$$$0(7);
        }
        if (editor == null) {
            PythonEnterHandler.$$$reportNull$$$0(8);
        }
        if (dataContext == null) {
            PythonEnterHandler.$$$reportNull$$$0(9);
        }
        if (!(file2 instanceof PyFile)) {
            return EnterHandlerDelegate.Result.Continue;
        }
        if (this.myPostprocessShift > 0) {
            editor.getCaretModel().moveCaretRelatively(this.myPostprocessShift, 0, false, false, false);
            this.myPostprocessShift = 0;
            return EnterHandlerDelegate.Result.Continue;
        }
        PythonEnterHandler.addGoogleDocStringSectionIndent(file2, editor, editor.getCaretModel().getOffset());
        return super.postProcessEnter(file2, editor, dataContext);
    }

    private static void addGoogleDocStringSectionIndent(@NotNull PsiFile file2, @NotNull Editor editor, int offset) {
        int lineNum;
        TextRange lineRange;
        Matcher matcher;
        String docStringText;
        DocStringFormat format;
        PyStringLiteralExpression pyString;
        if (file2 == null) {
            PythonEnterHandler.$$$reportNull$$$0(10);
        }
        if (editor == null) {
            PythonEnterHandler.$$$reportNull$$$0(11);
        }
        Document document = editor.getDocument();
        PsiDocumentManager.getInstance((Project)file2.getProject()).commitDocument(document);
        PsiElement element = file2.findElementAt(offset);
        if (element != null && (pyString = DocStringUtil.getParentDefinitionDocString(element)) != null && (format = DocStringUtil.guessDocStringFormat(docStringText = pyString.getText(), pyString)) == DocStringFormat.GOOGLE && offset + 1 < document.getTextLength() && (matcher = GoogleCodeStyleDocString.SECTION_HEADER.matcher(document.getText(lineRange = TextRange.create((int)document.getLineStartOffset((lineNum = document.getLineNumber(offset)) - 1), (int)document.getLineEndOffset(lineNum - 1))))).matches() && SectionBasedDocString.isValidSectionTitle(matcher.group(1))) {
            document.insertString(offset, (CharSequence)GoogleCodeStyleDocStringBuilder.getDefaultSectionIndent(file2.getProject()));
            editor.getCaretModel().moveCaretRelatively(2, 0, false, false, false);
        }
    }

    @NotNull
    public static DocstringState canGenerateDocstring(@NotNull PsiElement element, int firstQuoteOffset, @NotNull Document document) {
        if (element == null) {
            PythonEnterHandler.$$$reportNull$$$0(12);
        }
        if (document == null) {
            PythonEnterHandler.$$$reportNull$$$0(13);
        }
        if (firstQuoteOffset < 0 || firstQuoteOffset > document.getTextLength() - 3) {
            DocstringState docstringState = DocstringState.NONE;
            if (docstringState == null) {
                PythonEnterHandler.$$$reportNull$$$0(14);
            }
            return docstringState;
        }
        String quotes = document.getText(TextRange.from((int)firstQuoteOffset, (int)3));
        if (!quotes.equals("\"\"\"") && !quotes.equals("'''")) {
            DocstringState docstringState = DocstringState.NONE;
            if (docstringState == null) {
                PythonEnterHandler.$$$reportNull$$$0(15);
            }
            return docstringState;
        }
        PyStringLiteralExpression pyString = DocStringUtil.getParentDefinitionDocString(element);
        if (pyString != null) {
            String nodeText = element.getText();
            int prefixLength = PyStringLiteralExpressionImpl.getPrefixLength(nodeText);
            nodeText = nodeText.substring(prefixLength);
            String literalText = pyString.getText();
            if (literalText.endsWith(nodeText) && nodeText.startsWith(quotes) && firstQuoteOffset == pyString.getTextOffset() + prefixLength) {
                PsiErrorElement error = (PsiErrorElement)PsiTreeUtil.getNextSiblingOfType((PsiElement)pyString, PsiErrorElement.class);
                if (error == null) {
                    error = (PsiErrorElement)PsiTreeUtil.getNextSiblingOfType((PsiElement)pyString.getParent(), PsiErrorElement.class);
                }
                if (error != null) {
                    DocstringState docstringState = DocstringState.INCOMPLETE;
                    if (docstringState == null) {
                        PythonEnterHandler.$$$reportNull$$$0(16);
                    }
                    return docstringState;
                }
                if (nodeText.equals(quotes + quotes)) {
                    DocstringState docstringState = DocstringState.EMPTY;
                    if (docstringState == null) {
                        PythonEnterHandler.$$$reportNull$$$0(17);
                    }
                    return docstringState;
                }
                if (nodeText.length() < 6 || !nodeText.endsWith(quotes)) {
                    DocstringState docstringState = DocstringState.INCOMPLETE;
                    if (docstringState == null) {
                        PythonEnterHandler.$$$reportNull$$$0(18);
                    }
                    return docstringState;
                }
                String docstringIndent = PyIndentUtil.getLineIndent(document, document.getLineNumber(firstQuoteOffset));
                for (String line : LineTokenizer.tokenizeIntoList((CharSequence)nodeText, (boolean)false)) {
                    String lineIndent;
                    String lineContent = line.substring((lineIndent = PyIndentUtil.getLineIndent(line)).length());
                    if (!lineContent.startsWith("def ") && !lineContent.startsWith("class ") || docstringIndent.length() <= lineIndent.length() || !docstringIndent.startsWith(lineIndent)) continue;
                    DocstringState docstringState = DocstringState.INCOMPLETE;
                    if (docstringState == null) {
                        PythonEnterHandler.$$$reportNull$$$0(19);
                    }
                    return docstringState;
                }
            }
        }
        DocstringState docstringState = DocstringState.NONE;
        if (docstringState == null) {
            PythonEnterHandler.$$$reportNull$$$0(20);
        }
        return docstringState;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caretOffset";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caretAdvance";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 5: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classes";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/editor/PythonEnterHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/editor/PythonEnterHandler";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "canGenerateDocstring";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "preprocessEnter";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getNonStrictParentOfType";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "postProcessEnter";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addGoogleDocStringSectionIndent";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "canGenerateDocstring";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static enum DocstringState {
        NONE,
        INCOMPLETE,
        EMPTY;

    }
}

