/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.template.TemplateBuilder;
import com.intellij.codeInsight.template.TemplateBuilderFactory;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.impl.ParamHelper;
import com.jetbrains.python.psi.impl.PyFunctionBuilder;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class UnresolvedRefCreateFunctionQuickFix
implements LocalQuickFix {
    private final String myFunctionName;
    private final SmartPsiElementPointer<PyCallExpression> myCallExpr;
    private final SmartPsiElementPointer<PyReferenceExpression> myReferenceExpr;

    public UnresolvedRefCreateFunctionQuickFix(PyCallExpression element, PyReferenceExpression reference) {
        SmartPointerManager manager = SmartPointerManager.getInstance((Project)element.getProject());
        this.myCallExpr = manager.createSmartPsiElementPointer((PsiElement)element);
        this.myReferenceExpr = manager.createSmartPsiElementPointer((PsiElement)reference);
        this.myFunctionName = reference.getReferencedName();
    }

    @Nls
    @NotNull
    public String getName() {
        String string = PyBundle.message("QFIX.NAME.unresolved.reference.create.function", this.myFunctionName);
        if (string == null) {
            UnresolvedRefCreateFunctionQuickFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = PyBundle.message("QFIX.unresolved.reference.create.function", new Object[0]);
        if (string == null) {
            UnresolvedRefCreateFunctionQuickFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        PsiElement parent;
        if (project == null) {
            UnresolvedRefCreateFunctionQuickFix.$$$reportNull$$$0(2);
        }
        if (descriptor2 == null) {
            UnresolvedRefCreateFunctionQuickFix.$$$reportNull$$$0(3);
        }
        PyCallExpression callExpr = (PyCallExpression)this.myCallExpr.getElement();
        PyReferenceExpression referenceExpr = (PyReferenceExpression)this.myReferenceExpr.getElement();
        if (callExpr == null || !callExpr.isValid() || referenceExpr == null || !referenceExpr.isValid()) {
            return;
        }
        PyFunctionBuilder functionBuilder = new PyFunctionBuilder(referenceExpr.getText(), (PsiElement)callExpr);
        PyArgumentList argumentList = callExpr.getArgumentList();
        if (argumentList != null && !PsiTreeUtil.isAncestor((PsiElement)argumentList, (PsiElement)referenceExpr, (boolean)false)) {
            for (PyExpression param : argumentList.getArguments()) {
                if (param instanceof PyKeywordArgument) {
                    functionBuilder.parameter(((PyKeywordArgument)param).getKeyword());
                    continue;
                }
                if (param instanceof PyReferenceExpression) {
                    PyReferenceExpression refex = (PyReferenceExpression)param;
                    functionBuilder.parameter(refex.getReferencedName());
                    continue;
                }
                functionBuilder.parameter("param");
            }
        } else {
            functionBuilder.parameter("args");
        }
        PyFunction function = functionBuilder.buildFunction(project, LanguageLevel.getDefault());
        InjectedLanguageManager instance = InjectedLanguageManager.getInstance((Project)project);
        PsiLanguageInjectionHost host = instance.getInjectionHost((PsiElement)callExpr);
        Object insertAnchor = host != null ? host : callExpr;
        PyFunction parentFunction = (PyFunction)PsiTreeUtil.getTopmostParentOfType((PsiElement)insertAnchor, PyFunction.class);
        if (parentFunction != null) {
            PyClass parentClass = (PyClass)PsiTreeUtil.getTopmostParentOfType((PsiElement)parentFunction, PyClass.class);
            if (parentClass != null) {
                parent = parentClass.getParent();
                function = (PyFunction)parent.addBefore((PsiElement)function, (PsiElement)parentClass);
            } else {
                parent = parentFunction.getParent();
                function = (PyFunction)parent.addBefore((PsiElement)function, (PsiElement)parentFunction);
            }
        } else {
            PyStatement statement = (PyStatement)PsiTreeUtil.getTopmostParentOfType((PsiElement)insertAnchor, PyStatement.class);
            if (statement != null && (parent = statement.getParent()) != null) {
                function = (PyFunction)parent.addBefore((PsiElement)function, (PsiElement)statement);
            }
        }
        function = CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement(function);
        final TemplateBuilder builder = TemplateBuilderFactory.getInstance().createTemplateBuilder((PsiElement)function);
        ParamHelper.walkDownParamArray(function.getParameterList().getParameters(), new ParamHelper.ParamVisitor(){

            @Override
            public void visitNamedParameter(PyNamedParameter param, boolean first, boolean last) {
                builder.replaceElement((PsiElement)param, param.getName());
            }
        });
        builder.replaceElement((PsiElement)function.getStatementList(), "pass");
        FileEditor editor = FileEditorManager.getInstance((Project)project).getSelectedEditor(insertAnchor.getContainingFile().getVirtualFile());
        if (!(editor instanceof TextEditor)) {
            return;
        }
        builder.run(((TextEditor)editor).getEditor(), false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/quickfix/UnresolvedRefCreateFunctionQuickFix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/quickfix/UnresolvedRefCreateFunctionQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

