/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.packaging;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.packaging.PyPackage;
import com.jetbrains.python.packaging.PyPackageManager;
import com.jetbrains.python.packaging.PyPackageManagerImpl;
import com.jetbrains.python.packaging.PyPackageRequirementsSettings;
import com.jetbrains.python.packaging.PyPackageVersionComparator;
import com.jetbrains.python.packaging.PyRequirement;
import com.jetbrains.python.packaging.setupPy.SetupTaskIntrospector;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyListLiteralExpression;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.QualifiedResolveResult;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.remote.PyCredentialsContribution;
import com.jetbrains.python.sdk.CredentialsTypeExChecker;
import com.jetbrains.python.sdk.PythonSdkType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyPackageUtil {
    public static final String SETUPTOOLS = "setuptools";
    public static final String PIP = "pip";
    public static final String DISTRIBUTE = "distribute";
    private static final Logger LOG = Logger.getInstance(PyPackageUtil.class);
    @NotNull
    private static final String REQUIRES = "requires";
    @NotNull
    private static final String INSTALL_REQUIRES = "install_requires";
    @NotNull
    private static final String[] SETUP_PY_REQUIRES_KWARGS_NAMES = new String[]{"requires", "install_requires", "setup_requires", "tests_require"};
    @NotNull
    private static final String DEPENDENCY_LINKS = "dependency_links";

    private PyPackageUtil() {
    }

    public static boolean hasSetupPy(@NotNull Module module2) {
        if (module2 == null) {
            PyPackageUtil.$$$reportNull$$$0(0);
        }
        return PyPackageUtil.findSetupPy(module2) != null;
    }

    @Nullable
    public static PyFile findSetupPy(@NotNull Module module2) {
        if (module2 == null) {
            PyPackageUtil.$$$reportNull$$$0(1);
        }
        for (VirtualFile root : PyUtil.getSourceRoots(module2)) {
            PsiFile file2;
            VirtualFile child = root.findChild("setup.py");
            if (child == null || !((file2 = PsiManager.getInstance((Project)module2.getProject()).findFile(child)) instanceof PyFile)) continue;
            return (PyFile)file2;
        }
        return null;
    }

    public static boolean hasRequirementsTxt(@NotNull Module module2) {
        if (module2 == null) {
            PyPackageUtil.$$$reportNull$$$0(2);
        }
        return PyPackageUtil.findRequirementsTxt(module2) != null;
    }

    @Nullable
    public static VirtualFile findRequirementsTxt(@NotNull Module module2) {
        String requirementsPath;
        if (module2 == null) {
            PyPackageUtil.$$$reportNull$$$0(3);
        }
        if (!(requirementsPath = PyPackageRequirementsSettings.getInstance(module2).getRequirementsPath()).isEmpty()) {
            VirtualFile file2 = LocalFileSystem.getInstance().findFileByPath(requirementsPath);
            if (file2 != null) {
                return file2;
            }
            ModuleRootManager manager = ModuleRootManager.getInstance((Module)module2);
            for (VirtualFile root : manager.getContentRoots()) {
                VirtualFile fileInRoot = root.findFileByRelativePath(requirementsPath);
                if (fileInRoot == null) continue;
                return fileInRoot;
            }
        }
        return null;
    }

    @Nullable
    private static PyListLiteralExpression findSetupPyInstallRequires(@NotNull Module module2, @Nullable PyCallExpression setupCall) {
        if (module2 == null) {
            PyPackageUtil.$$$reportNull$$$0(4);
        }
        if (setupCall == null) {
            return null;
        }
        return Stream.of(REQUIRES, INSTALL_REQUIRES).map(setupCall::getKeywordArgument).map(requires -> {
            if (module2 == null) {
                PyPackageUtil.$$$reportNull$$$0(45);
            }
            return PyPackageUtil.resolveRequiresValue(module2, requires);
        }).filter(requires -> requires != null).findFirst().orElse(null);
    }

    @Nullable
    public static List<PyRequirement> findSetupPyRequires(@NotNull Module module2) {
        PyCallExpression setupCall;
        if (module2 == null) {
            PyPackageUtil.$$$reportNull$$$0(5);
        }
        if ((setupCall = PyPackageUtil.findSetupCall(module2)) == null) {
            return null;
        }
        List<PyRequirement> requirementsFromRequires = PyPackageUtil.getSetupPyRequiresFromArguments(module2, setupCall, SETUP_PY_REQUIRES_KWARGS_NAMES);
        List<PyRequirement> requirementsFromLinks = PyPackageUtil.getSetupPyRequiresFromArguments(module2, setupCall, DEPENDENCY_LINKS);
        return PyPackageUtil.mergeSetupPyRequirements(requirementsFromRequires, requirementsFromLinks);
    }

    @NotNull
    private static List<PyRequirement> getSetupPyRequiresFromArguments(@NotNull Module module2, @NotNull PyCallExpression setupCall, String ... argumentNames) {
        if (module2 == null) {
            PyPackageUtil.$$$reportNull$$$0(6);
        }
        if (setupCall == null) {
            PyPackageUtil.$$$reportNull$$$0(7);
        }
        if (argumentNames == null) {
            PyPackageUtil.$$$reportNull$$$0(8);
        }
        List<PyRequirement> list2 = PyPackageUtil.fix(PyRequirement.fromText(Stream.of(argumentNames).map(setupCall::getKeywordArgument).map(requires -> {
            if (module2 == null) {
                PyPackageUtil.$$$reportNull$$$0(44);
            }
            return PyPackageUtil.resolveRequiresValue(module2, requires);
        }).filter(requires -> requires != null).flatMap(requires -> Stream.of(requires.getElements())).filter(PyStringLiteralExpression.class::isInstance).map(requirement -> ((PyStringLiteralExpression)requirement).getStringValue()).collect(Collectors.joining("\n"))));
        if (list2 == null) {
            PyPackageUtil.$$$reportNull$$$0(9);
        }
        return list2;
    }

    @Deprecated
    @NotNull
    public static PyRequirement fix(@NotNull PyRequirement requirement) {
        if (requirement == null) {
            PyPackageUtil.$$$reportNull$$$0(10);
        }
        PyRequirement pyRequirement = requirement.withVersionComparator(PyPackageVersionComparator.getSTR_COMPARATOR());
        if (pyRequirement == null) {
            PyPackageUtil.$$$reportNull$$$0(11);
        }
        return pyRequirement;
    }

    @Deprecated
    @NotNull
    public static List<PyRequirement> fix(@NotNull List<PyRequirement> requirements) {
        if (requirements == null) {
            PyPackageUtil.$$$reportNull$$$0(12);
        }
        List list2 = ContainerUtil.map(requirements, PyPackageUtil::fix);
        if (list2 == null) {
            PyPackageUtil.$$$reportNull$$$0(13);
        }
        return list2;
    }

    @NotNull
    private static List<PyRequirement> mergeSetupPyRequirements(@NotNull List<PyRequirement> requirementsFromRequires, @NotNull List<PyRequirement> requirementsFromLinks) {
        if (requirementsFromRequires == null) {
            PyPackageUtil.$$$reportNull$$$0(14);
        }
        if (requirementsFromLinks == null) {
            PyPackageUtil.$$$reportNull$$$0(15);
        }
        if (!requirementsFromLinks.isEmpty()) {
            Map nameToRequirements = requirementsFromRequires.stream().collect(Collectors.groupingBy(PyRequirement::getName, LinkedHashMap::new, Collectors.toList()));
            for (PyRequirement requirementFromLinks : requirementsFromLinks) {
                nameToRequirements.replace(requirementFromLinks.getName(), Collections.singletonList(requirementFromLinks));
            }
            List list2 = nameToRequirements.values().stream().flatMap(Collection::stream).collect(Collectors.toCollection(ArrayList::new));
            if (list2 == null) {
                PyPackageUtil.$$$reportNull$$$0(16);
            }
            return list2;
        }
        List<PyRequirement> list3 = requirementsFromRequires;
        if (list3 == null) {
            PyPackageUtil.$$$reportNull$$$0(17);
        }
        return list3;
    }

    @Nullable
    private static PyListLiteralExpression resolveRequiresValue(@NotNull Module module2, @Nullable PyExpression requires) {
        if (module2 == null) {
            PyPackageUtil.$$$reportNull$$$0(18);
        }
        if (requires instanceof PyListLiteralExpression) {
            return (PyListLiteralExpression)requires;
        }
        if (requires instanceof PyReferenceExpression) {
            TypeEvalContext context = TypeEvalContext.deepCodeInsight(module2.getProject());
            PyResolveContext resolveContext = PyResolveContext.noImplicits().withTypeEvalContext(context);
            QualifiedResolveResult result2 = ((PyReferenceExpression)requires).followAssignmentsChain(resolveContext);
            PsiElement element = result2.getElement();
            if (element instanceof PyListLiteralExpression) {
                return (PyListLiteralExpression)element;
            }
        }
        return null;
    }

    @NotNull
    public static List<String> getPackageNames(@NotNull Module module2) {
        if (module2 == null) {
            PyPackageUtil.$$$reportNull$$$0(19);
        }
        ArrayList<String> packageNames = new ArrayList<String>();
        Project project = module2.getProject();
        VirtualFile[] roots = ModuleRootManager.getInstance((Module)module2).getSourceRoots();
        if (roots.length == 0) {
            roots = ModuleRootManager.getInstance((Module)module2).getContentRoots();
        }
        for (VirtualFile root : roots) {
            PyPackageUtil.collectPackageNames(project, root, packageNames);
        }
        ArrayList<String> arrayList = packageNames;
        if (arrayList == null) {
            PyPackageUtil.$$$reportNull$$$0(20);
        }
        return arrayList;
    }

    @NotNull
    public static String requirementsToString(@NotNull List<PyRequirement> requirements) {
        if (requirements == null) {
            PyPackageUtil.$$$reportNull$$$0(21);
        }
        String string = StringUtil.join(requirements, requirement -> String.format("'%s'", requirement.toString()), (String)", ");
        if (string == null) {
            PyPackageUtil.$$$reportNull$$$0(22);
        }
        return string;
    }

    @Nullable
    public static PyCallExpression findSetupCall(@NotNull PyFile file2) {
        if (file2 == null) {
            PyPackageUtil.$$$reportNull$$$0(23);
        }
        final Ref result2 = new Ref(null);
        file2.acceptChildren(new PyRecursiveElementVisitor(){

            @Override
            public void visitPyCallExpression(PyCallExpression node) {
                PyExpression callee = node.getCallee();
                String name = PyUtil.getReadableRepr((PsiElement)callee, true);
                if ("setup".equals(name)) {
                    result2.set((Object)node);
                }
            }

            @Override
            public void visitPyElement(PyElement node) {
                if (!(node instanceof ScopeOwner)) {
                    super.visitPyElement(node);
                }
            }
        });
        return (PyCallExpression)result2.get();
    }

    @Nullable
    public static PyCallExpression findSetupCall(@NotNull Module module2) {
        if (module2 == null) {
            PyPackageUtil.$$$reportNull$$$0(24);
        }
        return Optional.ofNullable(PyPackageUtil.findSetupPy(module2)).map(PyPackageUtil::findSetupCall).orElse(null);
    }

    private static void collectPackageNames(@NotNull Project project, final @NotNull VirtualFile root, final @NotNull List<String> results) {
        if (project == null) {
            PyPackageUtil.$$$reportNull$$$0(25);
        }
        if (root == null) {
            PyPackageUtil.$$$reportNull$$$0(26);
        }
        if (results == null) {
            PyPackageUtil.$$$reportNull$$$0(27);
        }
        final ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        VfsUtilCore.visitChildrenRecursively((VirtualFile)root, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

            public boolean visitFile(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (!fileIndex.isExcluded(file2) && file2.isDirectory() && file2.findChild("__init__.py") != null) {
                    results.add(VfsUtilCore.getRelativePath((VirtualFile)file2, (VirtualFile)root, (char)'.'));
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/python/packaging/PyPackageUtil$2", "visitFile"));
            }
        });
    }

    public static boolean packageManagementEnabled(@Nullable Sdk sdk) {
        if (!PythonSdkType.isRemote(sdk)) {
            return true;
        }
        return new CredentialsTypeExChecker(){

            @Override
            protected boolean checkLanguageContribution(PyCredentialsContribution languageContribution) {
                return languageContribution.isPackageManagementEnabled();
            }
        }.withSshContribution(true).withVagrantContribution(true).withWebDeploymentContribution(true).check(sdk);
    }

    @NotNull
    public static List<PyPackage> refreshAndGetPackagesModally(@NotNull Sdk sdk) {
        if (sdk == null) {
            PyPackageUtil.$$$reportNull$$$0(28);
        }
        Application app = ApplicationManager.getApplication();
        assert (!app.isWriteAccessAllowed()) : "This method can't be called on WriteAction because refreshAndGetPackages would be called on AWT thread in this case (see runProcessWithProgressSynchronously) and may lead to freeze";
        Ref packagesRef = Ref.create();
        Throwable callStacktrace = new Throwable();
        LOG.debug("Showing modal progress for collecting installed packages", new Throwable());
        PyUtil.runWithProgress(null, PyBundle.message("sdk.scanning.installed.packages", new Object[0]), true, false, (Consumer<ProgressIndicator>)((Consumer)indicator -> {
            if (sdk == null) {
                PyPackageUtil.$$$reportNull$$$0(43);
            }
            indicator.setIndeterminate(true);
            try {
                PyPackageManager manager = PyPackageManager.getInstance(sdk);
                packagesRef.set(manager.refreshAndGetPackages(false));
            }
            catch (ExecutionException e) {
                packagesRef.set(Collections.emptyList());
                e.initCause(callStacktrace);
                LOG.warn((Throwable)e);
            }
        }));
        List list2 = (List)packagesRef.get();
        if (list2 == null) {
            PyPackageUtil.$$$reportNull$$$0(29);
        }
        return list2;
    }

    public static boolean updatePackagesSynchronouslyWithGuard(@NotNull PyPackageManager manager, @NotNull AtomicBoolean isUpdating) {
        if (manager == null) {
            PyPackageUtil.$$$reportNull$$$0(30);
        }
        if (isUpdating == null) {
            PyPackageUtil.$$$reportNull$$$0(31);
        }
        assert (!ApplicationManager.getApplication().isDispatchThread());
        if (!isUpdating.compareAndSet(false, true)) {
            return false;
        }
        try {
            if (manager instanceof PyPackageManagerImpl) {
                LOG.info("Refreshing installed packages for SDK " + ((PyPackageManagerImpl)manager).getSdk().getHomePath());
            }
            manager.refreshAndGetPackages(true);
        }
        catch (ExecutionException executionException) {
        }
        finally {
            isUpdating.set(false);
        }
        return true;
    }

    @Nullable
    public static PyPackage findPackage(@NotNull List<PyPackage> packages, @NotNull String name) {
        if (packages == null) {
            PyPackageUtil.$$$reportNull$$$0(32);
        }
        if (name == null) {
            PyPackageUtil.$$$reportNull$$$0(33);
        }
        for (PyPackage pkg : packages) {
            if (!name.equalsIgnoreCase(pkg.getName())) continue;
            return pkg;
        }
        return null;
    }

    public static boolean hasManagement(@NotNull List<PyPackage> packages) {
        if (packages == null) {
            PyPackageUtil.$$$reportNull$$$0(34);
        }
        return PyPackageUtil.findPackage(packages, SETUPTOOLS) != null || PyPackageUtil.findPackage(packages, DISTRIBUTE) != null || PyPackageUtil.findPackage(packages, PIP) != null;
    }

    @Nullable
    public static List<PyRequirement> getRequirementsFromTxt(@NotNull Module module2) {
        VirtualFile requirementsTxt;
        if (module2 == null) {
            PyPackageUtil.$$$reportNull$$$0(35);
        }
        if ((requirementsTxt = PyPackageUtil.findRequirementsTxt(module2)) != null) {
            return PyPackageUtil.fix(PyRequirement.fromFile(requirementsTxt));
        }
        return null;
    }

    public static void addRequirementToTxtOrSetupPy(@NotNull Module module2, @NotNull String requirementName, @NotNull LanguageLevel languageLevel) {
        VirtualFile requirementsTxt;
        if (module2 == null) {
            PyPackageUtil.$$$reportNull$$$0(36);
        }
        if (requirementName == null) {
            PyPackageUtil.$$$reportNull$$$0(37);
        }
        if (languageLevel == null) {
            PyPackageUtil.$$$reportNull$$$0(38);
        }
        if ((requirementsTxt = PyPackageUtil.findRequirementsTxt(module2)) != null && requirementsTxt.isWritable()) {
            Document document = FileDocumentManager.getInstance().getDocument(requirementsTxt);
            if (document != null) {
                document.insertString(0, (CharSequence)(requirementName + "\n"));
            }
            return;
        }
        PyFile setupPy = PyPackageUtil.findSetupPy(module2);
        if (setupPy == null) {
            return;
        }
        PyCallExpression setupCall = PyPackageUtil.findSetupCall(setupPy);
        PyListLiteralExpression installRequires = PyPackageUtil.findSetupPyInstallRequires(module2, setupCall);
        PyElementGenerator generator = PyElementGenerator.getInstance(module2.getProject());
        if (installRequires != null && installRequires.isWritable()) {
            String text = String.format("'%s'", requirementName);
            PyExpression generated = generator.createExpressionFromText(languageLevel, text);
            installRequires.add((PsiElement)generated);
            return;
        }
        if (setupCall != null) {
            PyArgumentList argumentList = setupCall.getArgumentList();
            PyKeywordArgument requiresArg = PyPackageUtil.generateRequiresKwarg(setupPy, requirementName, languageLevel, generator);
            if (argumentList != null && requiresArg != null) {
                argumentList.addArgument(requiresArg);
            }
        }
    }

    @Nullable
    private static PyKeywordArgument generateRequiresKwarg(@NotNull PyFile setupPy, @NotNull String requirementName, @NotNull LanguageLevel languageLevel, @NotNull PyElementGenerator generator) {
        String keyword;
        String text;
        PyExpression generated;
        if (setupPy == null) {
            PyPackageUtil.$$$reportNull$$$0(39);
        }
        if (requirementName == null) {
            PyPackageUtil.$$$reportNull$$$0(40);
        }
        if (languageLevel == null) {
            PyPackageUtil.$$$reportNull$$$0(41);
        }
        if (generator == null) {
            PyPackageUtil.$$$reportNull$$$0(42);
        }
        if ((generated = generator.createExpressionFromText(languageLevel, text = String.format("foo(%s=['%s'])", keyword = SetupTaskIntrospector.usesSetuptools(setupPy) ? INSTALL_REQUIRES : REQUIRES, requirementName))) instanceof PyCallExpression) {
            PyCallExpression callExpression = (PyCallExpression)generated;
            return Stream.of(callExpression.getArguments()).filter(PyKeywordArgument.class::isInstance).map(PyKeywordArgument.class::cast).filter(kwarg -> keyword.equals(kwarg.getKeyword())).findFirst().orElse(null);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 11: 
            case 13: 
            case 16: 
            case 17: 
            case 20: 
            case 22: 
            case 29: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 11: 
            case 13: 
            case 16: 
            case 17: 
            case 20: 
            case 22: 
            case 29: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "setupCall";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentNames";
                break;
            }
            case 9: 
            case 11: 
            case 13: 
            case 16: 
            case 17: 
            case 20: 
            case 22: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/packaging/PyPackageUtil";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requirement";
                break;
            }
            case 12: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requirements";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requirementsFromRequires";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requirementsFromLinks";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
            case 28: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isUpdating";
                break;
            }
            case 32: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packages";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 37: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requirementName";
                break;
            }
            case 38: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevel";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "setupPy";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/packaging/PyPackageUtil";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSetupPyRequiresFromArguments";
                break;
            }
            case 11: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "fix";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "mergeSetupPyRequirements";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageNames";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "requirementsToString";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "refreshAndGetPackagesModally";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "hasSetupPy";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findSetupPy";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "hasRequirementsTxt";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findRequirementsTxt";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findSetupPyInstallRequires";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findSetupPyRequires";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getSetupPyRequiresFromArguments";
                break;
            }
            case 9: 
            case 11: 
            case 13: 
            case 16: 
            case 17: 
            case 20: 
            case 22: 
            case 29: {
                break;
            }
            case 10: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "fix";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "mergeSetupPyRequirements";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "resolveRequiresValue";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getPackageNames";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "requirementsToString";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "findSetupCall";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "collectPackageNames";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "refreshAndGetPackagesModally";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "updatePackagesSynchronouslyWithGuard";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "findPackage";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "hasManagement";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getRequirementsFromTxt";
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "addRequirementToTxtOrSetupPy";
                break;
            }
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "generateRequiresKwarg";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "lambda$refreshAndGetPackagesModally$7";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getSetupPyRequiresFromArguments$2";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findSetupPyInstallRequires$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 11: 
            case 13: 
            case 16: 
            case 17: 
            case 20: 
            case 22: 
            case 29: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

