/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.testing;

import com.google.common.collect.ObjectArrays;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextBrowseFolderListener;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.ui.TextAccessor;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.ui.components.JBTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ThreeState;
import com.jetbrains.PySymbolFieldWithBrowseButton;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.run.AbstractPyCommonOptionsForm;
import com.jetbrains.python.run.PyCommonOptionsFormFactory;
import com.jetbrains.python.testing.PyAbstractTestConfiguration;
import com.jetbrains.python.testing.PyTestsSharedKt;
import com.jetbrains.python.testing.TestTargetType;
import com.jetbrains.reflection.ReflectionUtilsKt;
import com.jetbrains.reflection.SimplePropertiesProvider;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PyTestSharedForm
implements SimplePropertiesProvider {
    private static final Pattern CAPITAL_LETTER = Pattern.compile("(?=\\p{Upper})");
    private JPanel myPanel;
    private JPanel myTargets;
    private JPanel myOptionsPanel;
    private JBLabel myLabel;
    private JPanel myCustomOptionsPanel;
    private JPanel myPanelForTargetFields;
    private final ButtonGroup myButtonGroup;
    private AbstractPyCommonOptionsForm myOptionsForm;
    private final Map<String, OptionHolder> myCustomOptions;
    private final TextFieldWithBrowseButton myPathTarget;
    private final PySymbolFieldWithBrowseButton myPythonTarget;

    @NotNull
    JPanel getPanel() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            PyTestSharedForm.$$$reportNull$$$0(0);
        }
        return jPanel;
    }

    @Override
    @NotNull
    public List<String> getPropertyNames() {
        ArrayList<String> arrayList = new ArrayList<String>(this.myCustomOptions.keySet());
        if (arrayList == null) {
            PyTestSharedForm.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @Override
    public void setPropertyValue(@NotNull String propertyName, @Nullable String propertyValue) {
        if (propertyName == null) {
            PyTestSharedForm.$$$reportNull$$$0(2);
        }
        this.myCustomOptions.get(propertyName).myOptionValue.setText(propertyValue != null ? propertyValue : "");
    }

    @Override
    @Nullable
    public String getPropertyValue(@NotNull String propertyName) {
        if (propertyName == null) {
            PyTestSharedForm.$$$reportNull$$$0(3);
        }
        return this.myCustomOptions.get(propertyName).myOptionValue.getText();
    }

    private PyTestSharedForm(@Nullable Module module2, @NotNull PyAbstractTestConfiguration configuration) {
        if (configuration == null) {
            PyTestSharedForm.$$$reportNull$$$0(4);
        }
        this.$$$setupUI$$$();
        this.myButtonGroup = new ButtonGroup();
        this.myCustomOptions = new LinkedHashMap<String, OptionHolder>();
        this.myPathTarget = new TextFieldWithBrowseButton();
        Project project = configuration.getProject();
        this.myPathTarget.addBrowseFolderListener(new TextBrowseFolderListener(FileChooserDescriptorFactory.createSingleFolderDescriptor()));
        TypeEvalContext context = TypeEvalContext.userInitiated(project, null);
        ThreeState testClassRequired = configuration.isTestClassRequired();
        this.myPythonTarget = new PySymbolFieldWithBrowseButton(module2 != null ? module2 : ModuleManager.getInstance((Project)project).getModules()[0], (Function1<? super PsiElement, Boolean>)((Function1)element -> {
            if (element instanceof PsiDirectory) {
                return true;
            }
            return PyTestsSharedKt.isTestElement(element, testClassRequired, context);
        }), (Function0<? extends VirtualFile>)((Function0)() -> {
            String workingDirectory;
            if (configuration == null) {
                PyTestSharedForm.$$$reportNull$$$0(15);
            }
            if (StringUtil.isEmpty((String)(workingDirectory = configuration.getWorkingDirectory()))) {
                return null;
            }
            return LocalFileSystem.getInstance().findFileByPath(workingDirectory);
        }));
    }

    @NotNull
    public static PyTestSharedForm create(@NotNull PyAbstractTestConfiguration configuration, CustomOption ... customOptions) {
        if (configuration == null) {
            PyTestSharedForm.$$$reportNull$$$0(5);
        }
        if (customOptions == null) {
            PyTestSharedForm.$$$reportNull$$$0(6);
        }
        PyTestSharedForm form = new PyTestSharedForm(configuration.getModule(), configuration);
        for (TestTargetType testTargetType : TestTargetType.values()) {
            JBRadioButton button = new JBRadioButton(StringUtil.capitalize((String)testTargetType.name().toLowerCase(Locale.getDefault())));
            button.setActionCommand(testTargetType.name());
            button.addActionListener(o -> form.onTargetTypeChanged());
            form.myButtonGroup.add((AbstractButton)button);
            form.myTargets.add((Component)button);
        }
        form.myButtonGroup.getElements().nextElement().setSelected(true);
        form.myOptionsForm = PyCommonOptionsFormFactory.getInstance().createForm(configuration.getCommonOptionsFormData());
        GridConstraints constraints = new GridConstraints();
        constraints.setFill(3);
        form.myOptionsPanel.add((Component)form.myOptionsForm.getMainPanel(), constraints);
        form.myLabel.setText(configuration.getTestFrameworkName());
        form.addCustomOptions((CustomOption[])ObjectArrays.concat((Object[])customOptions, (Object)new CustomOption(PyTestsSharedKt.getAdditionalArgumentsPropertyName(), TestTargetType.values())));
        configuration.copyTo(ReflectionUtilsKt.getProperties(form, null, true));
        PyTestSharedForm pyTestSharedForm = form;
        if (pyTestSharedForm == null) {
            PyTestSharedForm.$$$reportNull$$$0(7);
        }
        return pyTestSharedForm;
    }

    private void addCustomOptions(CustomOption ... customOptions) {
        if (customOptions == null) {
            PyTestSharedForm.$$$reportNull$$$0(8);
        }
        if (customOptions.length == 0) {
            return;
        }
        HashMap<String, JBTextField> optionValueFields = new HashMap<String, JBTextField>();
        for (CustomOption option : customOptions) {
            JBTextField textField2 = new JBTextField();
            optionValueFields.put(option.myName, textField2);
        }
        this.myCustomOptionsPanel.setLayout((LayoutManager)new GridLayoutManager(customOptions.length, 2));
        for (int i = 0; i < customOptions.length; ++i) {
            CustomOption option = customOptions[i];
            JBTextField textField3 = (JBTextField)optionValueFields.get(option.myName);
            GridConstraints labelConstraints = new GridConstraints();
            labelConstraints.setFill(2);
            labelConstraints.setRow(i);
            labelConstraints.setColumn(0);
            labelConstraints.setHSizePolicy(1);
            JLabel label = new JLabel(StringUtil.capitalize((String)CAPITAL_LETTER.matcher(option.myName).replaceAll(" ")));
            label.setHorizontalAlignment(2);
            this.myCustomOptionsPanel.add((Component)label, labelConstraints);
            GridConstraints textConstraints = new GridConstraints();
            textConstraints.setFill(3);
            textConstraints.setRow(i);
            textConstraints.setColumn(1);
            textConstraints.setHSizePolicy(2);
            this.myCustomOptionsPanel.add((Component)textField3, textConstraints);
            this.myCustomOptions.put(option.myName, new OptionHolder(option, label, (JTextField)textField3));
        }
    }

    @NotNull
    AbstractPyCommonOptionsForm getOptionsForm() {
        AbstractPyCommonOptionsForm abstractPyCommonOptionsForm = this.myOptionsForm;
        if (abstractPyCommonOptionsForm == null) {
            PyTestSharedForm.$$$reportNull$$$0(9);
        }
        return abstractPyCommonOptionsForm;
    }

    @NotNull
    public String getTarget() {
        String targetText = this.getActiveTextField().getText().trim();
        String string = this.getTargetType() == TestTargetType.PATH ? FileUtil.toSystemIndependentName((String)targetText) : targetText;
        if (string == null) {
            PyTestSharedForm.$$$reportNull$$$0(10);
        }
        return string;
    }

    public void setTarget(@NotNull String targetText) {
        if (targetText == null) {
            PyTestSharedForm.$$$reportNull$$$0(11);
        }
        this.getActiveTextField().setText(targetText);
    }

    private void onTargetTypeChanged() {
        TestTargetType targetType = this.getTargetType();
        for (OptionHolder optionHolder : this.myCustomOptions.values()) {
            optionHolder.setType(targetType);
        }
        Arrays.stream(this.myPanelForTargetFields.getComponents()).forEach(this.myPanelForTargetFields::remove);
        GridBagConstraints cons = new GridBagConstraints();
        cons.fill = 2;
        cons.weightx = 1.0;
        if (targetType == TestTargetType.PATH) {
            this.myPanelForTargetFields.add((Component)this.myPathTarget, cons);
        } else if (targetType == TestTargetType.PYTHON) {
            this.myPanelForTargetFields.add((Component)((Object)this.myPythonTarget), cons);
        }
    }

    @NotNull
    private TextAccessor getActiveTextField() {
        Object object = this.getTargetType() == TestTargetType.PATH ? this.myPathTarget : this.myPythonTarget;
        if (object == null) {
            PyTestSharedForm.$$$reportNull$$$0(12);
        }
        return object;
    }

    @NotNull
    public TestTargetType getTargetType() {
        TestTargetType testTargetType = TestTargetType.valueOf(this.myButtonGroup.getSelection().getActionCommand());
        if (testTargetType == null) {
            PyTestSharedForm.$$$reportNull$$$0(13);
        }
        return testTargetType;
    }

    public void setTargetType(@NotNull TestTargetType target2) {
        if (target2 == null) {
            PyTestSharedForm.$$$reportNull$$$0(14);
        }
        Enumeration<AbstractButton> elements = this.myButtonGroup.getElements();
        while (elements.hasMoreElements()) {
            AbstractButton button = elements.nextElement();
            if (TestTargetType.valueOf(button.getActionCommand()) != target2) continue;
            this.myButtonGroup.setSelected(button.getModel(), true);
            break;
        }
        this.onTargetTypeChanged();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 11: 
            case 14: 
            case 15: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 11: 
            case 14: 
            case 15: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/testing/PyTestSharedForm";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 4: 
            case 5: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customOptions";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetText";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertyNames";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 11: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/testing/PyTestSharedForm";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsForm";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getTarget";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveTextField";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetType";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setPropertyValue";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyValue";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addCustomOptions";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setTarget";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setTargetType";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "lambda$new$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 11: 
            case 14: 
            case 15: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        JPanel jPanel3;
        JBLabel jBLabel;
        JPanel jPanel4;
        JPanel jPanel5;
        this.myPanel = jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel5).setEnabled(false);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel6, new GridConstraints(0, 0, 1, 1, 1, 1, 3, 3, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Target");
        jPanel6.add((Component)jBLabel2, new GridConstraints(1, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myTargets = jPanel4 = new JPanel();
        jPanel4.setLayout(new FlowLayout(1, 5, 5));
        jPanel6.add((Component)jPanel4, new GridConstraints(1, 1, 1, 1, 8, 2, 3, 3, null, null, null));
        this.myLabel = jBLabel = new JBLabel();
        jPanel6.add((Component)jBLabel, new GridConstraints(0, 0, 1, 2, 0, 3, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel5.add((Component)spacer, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myOptionsPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel3, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myCustomOptionsPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel2, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myPanelForTargetFields = jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel5.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private static final class OptionHolder {
        @NotNull
        private final CustomOption myOption;
        @NotNull
        private final JLabel myOptionLabel;
        @NotNull
        private final JTextField myOptionValue;

        private OptionHolder(@NotNull CustomOption option, @NotNull JLabel optionLabel, @NotNull JTextField optionValue) {
            if (option == null) {
                OptionHolder.$$$reportNull$$$0(0);
            }
            if (optionLabel == null) {
                OptionHolder.$$$reportNull$$$0(1);
            }
            if (optionValue == null) {
                OptionHolder.$$$reportNull$$$0(2);
            }
            this.myOption = option;
            this.myOptionLabel = optionLabel;
            this.myOptionValue = optionValue;
        }

        private void setType(@NotNull TestTargetType type) {
            if (type == null) {
                OptionHolder.$$$reportNull$$$0(3);
            }
            boolean visible = this.myOption.mySupportedTypes.contains((Object)type);
            this.myOptionLabel.setVisible(visible);
            this.myOptionValue.setVisible(visible);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "option";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "optionLabel";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "optionValue";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/testing/PyTestSharedForm$OptionHolder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setType";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static final class CustomOption {
        @NotNull
        private final String myName;
        private final EnumSet<TestTargetType> mySupportedTypes;

        CustomOption(@NotNull String name, TestTargetType ... supportedTypes) {
            if (name == null) {
                CustomOption.$$$reportNull$$$0(0);
            }
            if (supportedTypes == null) {
                CustomOption.$$$reportNull$$$0(1);
            }
            this.myName = name;
            this.mySupportedTypes = EnumSet.copyOf(Arrays.asList(supportedTypes));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "name";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "supportedTypes";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/python/testing/PyTestSharedForm$CustomOption";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

