/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.actions.actionVisibility;

import com.intellij.cvsSupport2.actions.cvsContext.CvsContext;
import com.intellij.cvsSupport2.actions.cvsContext.CvsContextWrapper;
import com.intellij.cvsSupport2.actions.cvsContext.CvsLightweightFile;
import com.intellij.cvsSupport2.application.CvsEntriesManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class CvsActionVisibility {
    private boolean myCanBePerformedOnFile = true;
    private boolean myCanBePerformedOnDirectory = true;
    private boolean myCanBePerformedOnSeveralFiles = false;
    private final List<Condition> myConditions = new ArrayList<Condition>();
    private boolean myCanBePerformedOnLocallyDeletedFile = false;
    private boolean myCanBePerformedOnCvsLightweightFile = false;

    public void addCondition(Condition condition) {
        this.myConditions.add(condition);
    }

    private boolean isEnabled(CvsContext context) {
        boolean result;
        boolean bl = result = context.cvsIsActive() && this.hasSuitableType(context);
        if (!result) {
            return false;
        }
        for (Condition condition : this.myConditions) {
            if (condition.isPerformedOn(context)) continue;
            return false;
        }
        return true;
    }

    public void shouldNotBePerformedOnFile() {
        this.myCanBePerformedOnFile = false;
    }

    public void shouldNotBePerformedOnDirectory() {
        this.myCanBePerformedOnDirectory = false;
    }

    public void canBePerformedOnSeveralFiles() {
        this.myCanBePerformedOnSeveralFiles = true;
    }

    private boolean hasSuitableType(CvsContext context) {
        File[] selectedIOFiles = context.getSelectedIOFiles();
        VirtualFile[] selectedFiles = context.getSelectedFiles();
        CvsLightweightFile[] lightweightFiles = context.getSelectedLightweightFiles();
        if (selectedFiles == null) {
            selectedFiles = VirtualFile.EMPTY_ARRAY;
        }
        if (selectedIOFiles == null) {
            selectedIOFiles = new File[]{};
        }
        if (lightweightFiles == null) {
            lightweightFiles = new CvsLightweightFile[]{};
        }
        if (selectedFiles.length == 0 && lightweightFiles.length == 0 && !this.myCanBePerformedOnLocallyDeletedFile) {
            return false;
        }
        if (selectedFiles.length == 0 && selectedIOFiles.length == 0 && !this.myCanBePerformedOnCvsLightweightFile) {
            return false;
        }
        int selectedFileCount = selectedFiles.length + selectedIOFiles.length + lightweightFiles.length;
        if (selectedFileCount == 0) {
            return false;
        }
        if (selectedFileCount > 1 && !this.myCanBePerformedOnSeveralFiles) {
            return false;
        }
        if (this.containsFileFromUnsupportedFileSystem(selectedFiles)) {
            return false;
        }
        if ((this.containsDirectory(selectedFiles) || this.containsDirectory(selectedIOFiles)) && !this.myCanBePerformedOnDirectory) {
            return false;
        }
        return !this.containsFile(selectedFiles) && !this.containsFile(selectedIOFiles) || this.myCanBePerformedOnFile;
    }

    private boolean containsFileFromUnsupportedFileSystem(VirtualFile[] selectedFiles) {
        for (VirtualFile selectedFile : selectedFiles) {
            if (selectedFile.isInLocalFileSystem()) continue;
            return true;
        }
        return false;
    }

    private boolean containsFile(VirtualFile[] selectedFiles) {
        for (VirtualFile selectedFile : selectedFiles) {
            if (selectedFile.isDirectory()) continue;
            return true;
        }
        return false;
    }

    private boolean containsDirectory(VirtualFile[] selectedFiles) {
        for (VirtualFile selectedFile : selectedFiles) {
            if (!selectedFile.isDirectory()) continue;
            return true;
        }
        return false;
    }

    private boolean containsDirectory(File[] selectedFiles) {
        for (File selectedFile : selectedFiles) {
            if (!selectedFile.isDirectory()) continue;
            return true;
        }
        return false;
    }

    private boolean containsFile(File[] selectedFiles) {
        for (File selectedFile : selectedFiles) {
            if (!selectedFile.isFile()) continue;
            return true;
        }
        return false;
    }

    public void canBePerformedOnLocallyDeletedFile() {
        this.myCanBePerformedOnLocallyDeletedFile = true;
    }

    public void applyToEvent(AnActionEvent e) {
        if (!CvsEntriesManager.getInstance().isActive()) {
            Presentation presentation = e.getPresentation();
            presentation.setVisible(false);
            presentation.setEnabled(false);
            return;
        }
        CvsContext cvsContext = CvsContextWrapper.createInstance(e);
        Presentation presentation = e.getPresentation();
        presentation.setEnabled(this.isEnabled(cvsContext));
        presentation.setVisible(cvsContext.cvsIsActive());
    }

    public void canBePerformedOnCvsLightweightFile() {
        this.myCanBePerformedOnCvsLightweightFile = true;
    }

    public static interface Condition {
        public boolean isPerformedOn(CvsContext var1);
    }
}

