/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.cvsBrowser;

import com.intellij.cvsSupport2.cvsBrowser.ChildrenLoader;
import com.intellij.cvsSupport2.cvsBrowser.RemoteResourceDataProvider;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public class CvsElement
extends DefaultMutableTreeNode
implements Comparable<CvsElement> {
    public static final CvsElement[] EMPTY_ARRAY = new CvsElement[0];
    protected RemoteResourceDataProvider myDataProvider;
    protected String myPath;
    protected final String myName;
    private final Icon myIcon;
    private boolean myCanBeCheckedOut = true;
    private ChildrenLoader<CvsElement> myChildrenLoader;
    private boolean myLoading;

    public CvsElement(String name, Icon icon) {
        this.myName = name;
        this.myIcon = icon;
    }

    public void setChildrenLoader(ChildrenLoader<CvsElement> childrenLoader) {
        this.myChildrenLoader = childrenLoader;
    }

    public void setDataProvider(RemoteResourceDataProvider dataProvider) {
        this.myDataProvider = dataProvider;
    }

    public RemoteResourceDataProvider getDataProvider() {
        return this.myDataProvider;
    }

    public String getName() {
        return this.myName;
    }

    public void setPath(String path) {
        this.myPath = path.startsWith("./") ? path.substring(2) : path;
    }

    @Override
    public TreeNode getChildAt(int childIndex) {
        return (TreeNode)this.getMyChildren().get(childIndex);
    }

    @Override
    public int getChildCount() {
        return this.getMyChildren().size();
    }

    @Override
    public int getIndex(TreeNode node) {
        return this.getMyChildren().indexOf(node);
    }

    @Override
    public boolean getAllowsChildren() {
        if (this.children != null) {
            return this.getChildCount() > 0;
        }
        return !this.myDataProvider.equals(RemoteResourceDataProvider.NOT_EXPANDABLE);
    }

    public Enumeration children() {
        return this.getMyChildren().elements();
    }

    private Vector getMyChildren() {
        if (this.children == null) {
            this.myChildrenLoader.loadChildren(this);
        }
        return this.children;
    }

    public void insertSorted(MutableTreeNode newChild, Comparator comparator) {
        if (this.children == null) {
            this.insert(newChild, 0);
        } else {
            int insertionPoint = Collections.binarySearch(this.children, newChild, comparator);
            if (insertionPoint < 0) {
                this.insert(newChild, -insertionPoint - 1);
            }
        }
    }

    @Override
    public String toString() {
        return this.myName;
    }

    public Icon getIcon() {
        return this.myIcon;
    }

    public String getElementPath() {
        return this.myPath;
    }

    public String getCheckoutPath() {
        return this.getElementPath();
    }

    public boolean canBeCheckedOut() {
        return this.myCanBeCheckedOut;
    }

    public void cannotBeCheckedOut() {
        this.myCanBeCheckedOut = false;
    }

    public String getCheckoutDirectoryName() {
        return new File(this.getCheckoutPath()).getName();
    }

    public VirtualFile getVirtualFile() {
        return null;
    }

    public String createPathForChild(String name) {
        return this.getElementPath() + "/" + name;
    }

    public File getCvsLightFile() {
        return null;
    }

    @Override
    public int compareTo(CvsElement other) {
        int result = this.myName.compareToIgnoreCase(other.myName);
        if (result != 0) {
            return result;
        }
        return this.myName.compareTo(other.myName);
    }

    public boolean isLoading() {
        return this.myLoading;
    }

    public void setLoading(boolean loading) {
        this.myLoading = loading;
    }
}

