formal_charge_dict = {
'NHE': [
   (
      'N<0>',
      {
         0: 0,
      },
   ),
],
'NME': [
   (
      'C<0>N<1>',
      {
         0: 0,
         1: 0,
      },
   ),
],
'ACE': [
   (
      'C<0>(=O<1>)C<2>',
      {
         0: 0,
         1: 0,
         2: 0,
      },
   ),
],
'ALA': [
   (
      'N<0>C<1>(C<2>)C<3>=O<4>',
      {
         0: 0,
         1: 0,
         2: 0,
         3: 0,
         4: 0,
      },
   ),
],
'ARG': [
   (
      'N<0>C<1>(C<2>C<3>C<4>N<5>C<6>(N<7>)=N<8>)C<9>=O<10>',
      {
         0: 0,
         1: 0,
         2: 0,
         3: 0,
         4: 0,
         5: 0,
         6: 0,
         7: 0,
         8: 1,
         9: 0,
        10: 0,
      },
   ),
],
'ASP': [
   (
      'N<0>C<1>(C<2>C<3>(O<4>)=O<5>)C<6>=O<7>',
      {
         0: 0,
         1: 0,
         2: 0,
         3: 0,
         4: -1,
         5: 0,
         6: 0,
         7: 0,
      },
   ),
],
'ASN': [
   (
      'N<0>C<1>(C<2>C<3>(=O<4>)N<5>)C<6>=O<7>',
      {
         0: 0,
         1: 0,
         2: 0,
         3: 0,
         4: 0,
         5: 0,
         6: 0,
         7: 0,
      },
   ),
],
'CYS': [
   (
      'N<0>C<1>(C<2>S<3>)C<4>=O<5>',
      {
         0: 0,
         1: 0,
         2: 0,
         3: 0,
         4: 0,
         5: 0,
      },
   ),
],
'CYX': [
   (
      'N<0>C<1>(C<2>S<3>)C<4>=O<5>',
      {
         0: 0,
         1: 0,
         2: 0,
         3: 0,
         4: 0,
         5: 0,
      },
   ),
],
'GLN': [
   (
      'N<0>C<1>(C<2>C<3>C<4>(=O<5>)N<6>)C<7>=O<8>',
      {
         0: 0,
         1: 0,
         2: 0,
         3: 0,
         4: 0,
         5: 0,
         6: 0,
         7: 0,
         8: 0,
      },
   ),
],
'GLU': [
   (
      'N<0>C<1>(C<2>C<3>C<4>(O<5>)=O<6>)C<7>=O<8>',
      {
         0: 0,
         1: 0,
         2: 0,
         3: 0,
         4: 0,
         5: -1,
         6: 0,
         7: 0,
         8: 0,
      },
   ),
],
'GLY': [
   (
      'N<0>C<1>C<2>=O<3>',
      {
         0: 0,
         1: 0,
         2: 0,
         3: 0,
      },
   ),
],
'HIS': [
   (
      'N<0>C<1>(C<2>C<3>1-N<4>=C<5>N<6>C<7>=1)C<8>=O<9>',
      {
         0: 0,
         1: 0,
         2: 0,
         3: 0,
         4: 0,
         5: 0,
         6: 0,
         7: 0,
         8: 0,
         9: 0,
      },
   ),
],
'HIP': [
   (
      'N<0>C<1>(C<2>C<3>1-N<4>=C<5>N<6>C<7>=1)C<8>=O<9>',
      {
         0: 0,
         1: 0,
         2: 0,
         3: 0,
         4: 1,
         5: 0,
         6: 0,
         7: 0,
         8: 0,
         9: 0,
      },
   ),
],
'HID': [
   (
      'N<0>C<1>(C<2>C<3>1-N<4>C<5>=N<6>C<7>=1)C<8>=O<9>',
      {
         0: 0,
         1: 0,
         2: 0,
         3: 0,
         4: 0,
         5: 0,
         6: 0,
         7: 0,
         8: 0,
         9: 0,
      },
   ),
],
'ILE': [
   (
      'N<0>C<1>(C<2>(C<3>)C<4>C<5>)C<6>=O<7>',
      {
         0: 0,
         1: 0,
         2: 0,
         3: 0,
         4: 0,
         5: 0,
         6: 0,
         7: 0,
      },
   ),
],
'LEU': [
   (
      'N<0>C<1>(C<2>C<3>(C<4>)C<5>)C<6>=O<7>',
      {
         0: 0,
         1: 0,
         2: 0,
         3: 0,
         4: 0,
         5: 0,
         6: 0,
         7: 0,
      },
   ),
],
'LYS': [
   (
      'N<0>C<1>(C<2>C<3>C<4>C<5>N<6>)C<7>=O<8>',
      {
         0: 0,
         1: 0,
         2: 0,
         3: 0,
         4: 0,
         5: 0,
         6: 1,
         7: 0,
         8: 0,
      },
   ),
],
'MET': [
   (
      'N<0>C<1>(C<2>C<3>S<4>C<5>)C<6>=O<7>',
      {
         0: 0,
         1: 0,
         2: 0,
         3: 0,
         4: 0,
         5: 0,
         6: 0,
         7: 0,
      },
   ),
],
'PHE': [
   (
      'N<0>C<1>(C<2>C<3>1C<4>=C<5>C<6>=C<7>C<8>=1)C<9>=O<10>',
      {
         0: 0,
         1: 0,
         2: 0,
         3: 0,
         4: 0,
         5: 0,
         6: 0,
         7: 0,
         8: 0,
         9: 0,
        10: 0,
      },
   ),
],
'PRO': [
   (
      'N<0>1C<1>C<2>C<3>C<4>1C<5>=O<6>',
      {
         0: 0,
         1: 0,
         2: 0,
         3: 0,
         4: 0,
         5: 0,
         6: 0,
      },
   ),
],
'SER': [
   (
      'N<0>C<1>(C<2>O<3>)C<4>=O<5>',
      {
         0: 0,
         1: 0,
         2: 0,
         3: 0,
         4: 0,
         5: 0,
      },
   ),
],
'THR': [
   (
      'N<0>C<1>(C<2>(O<3>)C<4>)C<5>=O<6>',
      {
         0: 0,
         1: 0,
         2: 0,
         3: 0,
         4: 0,
         5: 0,
         6: 0,
      },
   ),
],
'TRP': [
   (
      'N<0>C<1>(C<2>C<3>1=C<4>N<5>C<6>=2C<7>=C<8>C<9>=C<10>C<11>1=2)C<12>=O<13>',
      {
         0: 0,
         1: 0,
         2: 0,
         3: 0,
         4: 0,
         5: 0,
         6: 0,
         7: 0,
         8: 0,
         9: 0,
        10: 0,
        11: 0,
        12: 0,
        13: 0,
      },
   ),
],
'TYR': [
   (
      'N<0>C<1>(C<2>C<3>1C<4>=C<5>C<6>(O<7>)=C<8>C<9>=1)C<10>=O<11>',
      {
         0: 0,
         1: 0,
         2: 0,
         3: 0,
         4: 0,
         5: 0,
         6: 0,
         7: 0,
         8: 0,
         9: 0,
        10: 0,
        11: 0,
      },
   ),
],
'VAL': [
   (
      'N<0>C<1>(C<2>(C<3>)C<4>)C<5>=O<6>',
      {
         0: 0,
         1: 0,
         2: 0,
         3: 0,
         4: 0,
         5: 0,
         6: 0,
      },
   ),
],
'HOH': [
   (
      'O<0>',
      {
         0: 0,
      },
   ),
],
'WAT': [
   (
      'O<0>',
      {
       0: 0,
      },
   ),
],
'TIP': [
   (
      'O<0>',
      {
       0: 0,
      },
   ),
],
}

for alias in (
    ( 'HIE', 'HIS'), # default HIS is HISE
    ( 'HISE', 'HIS'),
    ( 'HISD', 'HID'),
    ( 'HISP', 'HIP'),
    ( 'GLUM', 'GLU'), # default -1
    ( 'ASPM', 'ASP'), # default -1
    ( 'LYSP', 'LYS'), # default +1
    ( 'ARGP', 'ARG'), # default +1
    ):
    formal_charge_dict[alias[0]] = formal_charge_dict[alias[1]]

