#  SHIBOKEN_INCLUDE_DIR        - Directories to include to use SHIBOKEN
#  SHIBOKEN_LIBRARY            - Files to link against to use SHIBOKEN
#  SHIBOKEN_BINARY             - Executable name
#  SHIBOKEN_BUILD_TYPE         - Tells if Shiboken was compiled in Release or Debug mode.
#  SHIBOKEN_PYTHON_INTERPRETER - Python interpreter (regular or debug) to be used with the bindings.
#  SHIBOKEN_PYTHON_LIBRARIES   - Python libraries (regular or debug) Shiboken is linked against.

SET(SHIBOKEN_INCLUDE_DIR "/usr/include/shiboken")
if(MSVC)
    SET(SHIBOKEN_LIBRARY "/usr/lib/libshiboken.cpython-36m-aarch64-linux-gnu.lib")
elseif(CYGWIN)
    SET(SHIBOKEN_LIBRARY "/usr/lib/shiboken.cpython-36m-aarch64-linux-gnu")
elseif(WIN32)
    SET(SHIBOKEN_LIBRARY "/usr/bin/libshiboken.cpython-36m-aarch64-linux-gnu.so")
else()
    SET(SHIBOKEN_LIBRARY "/usr/lib/libshiboken.cpython-36m-aarch64-linux-gnu.so")
endif()
SET(SHIBOKEN_PYTHON_INCLUDE_DIR "/usr/include/python3.6m")
SET(SHIBOKEN_PYTHON_INCLUDE_DIR "/usr/include/python3.6m")
SET(SHIBOKEN_PYTHON_INTERPRETER "/usr/bin/python3")
SET(SHIBOKEN_PYTHON_LIBRARIES "/usr/lib/libpython3.6m.so")
SET(SHIBOKEN_PYTHON_SUFFIX ".cpython-36m-aarch64-linux-gnu")
message(STATUS "libshiboken built for Release")


set(SHIBOKEN_BINARY "/usr/bin/shiboken")
