/*
 * Decompiled with CFR 0.152.
 */
package xsbt.api;

import java.io.Serializable;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.sys.package$;
import scala.util.Try$;
import xsbti.api.Access;
import xsbti.api.Annotated;
import xsbti.api.Annotation;
import xsbti.api.ClassDefinition;
import xsbti.api.ClassLike;
import xsbti.api.ClassLikeDef;
import xsbti.api.Constant;
import xsbti.api.Def;
import xsbti.api.Definition;
import xsbti.api.DefinitionType;
import xsbti.api.EmptyType;
import xsbti.api.Existential;
import xsbti.api.Id;
import xsbti.api.IdQualifier;
import xsbti.api.Modifiers;
import xsbti.api.ParameterList;
import xsbti.api.ParameterModifier;
import xsbti.api.ParameterRef;
import xsbti.api.Parameterized;
import xsbti.api.ParameterizedDefinition;
import xsbti.api.Path;
import xsbti.api.PathComponent;
import xsbti.api.Polymorphic;
import xsbti.api.Private;
import xsbti.api.Projection;
import xsbti.api.Protected;
import xsbti.api.Public;
import xsbti.api.Qualifier;
import xsbti.api.Singleton;
import xsbti.api.Structure;
import xsbti.api.Super;
import xsbti.api.This;
import xsbti.api.ThisQualifier;
import xsbti.api.Type;
import xsbti.api.TypeAlias;
import xsbti.api.TypeDeclaration;
import xsbti.api.TypeParameter;
import xsbti.api.Unqualified;
import xsbti.api.Val;
import xsbti.api.Var;
import xsbti.api.Variance;

public final class ShowAPI$ {
    public static ShowAPI$ MODULE$;
    private int numDecls;
    private volatile boolean bitmap$0;

    static {
        new ShowAPI$();
    }

    private int numDecls$lzycompute() {
        ShowAPI$ showAPI$ = this;
        synchronized (showAPI$) {
            if (!this.bitmap$0) {
                this.numDecls = BoxesRunTime.unboxToInt((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> Integer.parseInt((String)package$.MODULE$.props().get("sbt.inc.apidiff.decls").get())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
                this.bitmap$0 = true;
            }
        }
        return this.numDecls;
    }

    private int numDecls() {
        return !this.bitmap$0 ? this.numDecls$lzycompute() : this.numDecls;
    }

    private ClassDefinition[] truncateDecls(ClassDefinition[] decls) {
        return this.numDecls() <= 0 ? decls : (ClassDefinition[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])decls)).take(this.numDecls());
    }

    private String lines(Seq<String> ls) {
        return ls.mkString("\n", "\n", "\n");
    }

    public String showApi(ClassLike c, int nesting) {
        return this.showDefinition((Definition)c, nesting);
    }

    public String showDefinition(Definition d, int nesting) {
        String string;
        Definition definition = d;
        if (definition instanceof Val) {
            Val val = (Val)definition;
            string = this.showMonoDef((Definition)val, "val", nesting) + ": " + this.showType(val.tpe(), nesting);
        } else if (definition instanceof Var) {
            Var var = (Var)definition;
            string = this.showMonoDef((Definition)var, "var", nesting) + ": " + this.showType(var.tpe(), nesting);
        } else if (definition instanceof Def) {
            Def def = (Def)definition;
            string = this.showPolyDef((ParameterizedDefinition)def, "def", nesting) + this.showValueParams((Seq<ParameterList>)Predef$.MODULE$.wrapRefArray((Object[])def.valueParameters()), nesting) + ": " + this.showType(def.returnType(), nesting);
        } else if (definition instanceof TypeAlias) {
            TypeAlias typeAlias = (TypeAlias)definition;
            string = this.showPolyDef((ParameterizedDefinition)typeAlias, "type", nesting) + " = " + this.showType(typeAlias.tpe(), nesting);
        } else if (definition instanceof TypeDeclaration) {
            TypeDeclaration typeDeclaration = (TypeDeclaration)definition;
            string = this.showPolyDef((ParameterizedDefinition)typeDeclaration, "type", nesting) + this.showBounds(typeDeclaration.lowerBound(), typeDeclaration.upperBound(), nesting);
        } else if (definition instanceof ClassLike) {
            ClassLike classLike = (ClassLike)definition;
            string = this.showMonoDef(d, this.showDefinitionType(classLike.definitionType()), nesting) + this.showTypeParameters((Seq<TypeParameter>)Predef$.MODULE$.wrapRefArray((Object[])classLike.typeParameters()), nesting) + " extends " + this.showTemplate(classLike, nesting);
        } else if (definition instanceof ClassLikeDef) {
            ClassLikeDef classLikeDef = (ClassLikeDef)definition;
            string = this.showPolyDef((ParameterizedDefinition)classLikeDef, this.showDefinitionType(classLikeDef.definitionType()), nesting);
        } else {
            throw new MatchError((Object)definition);
        }
        return string;
    }

    private String showTemplate(ClassLike cl, int nesting) {
        String string;
        if (nesting <= 0) {
            string = "<nesting level reached>";
        } else {
            String showSelf = cl.selfType() instanceof EmptyType ? "" : " self: " + this.showNestedType(cl.selfType(), nesting) + " =>";
            string = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cl.structure().parents())).map((Function1 & Serializable & scala.Serializable)tp -> MODULE$.showNestedType((Type)tp, nesting), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString("", " with ", " {") + showSelf + this.lines((Seq<String>)((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.truncateDecls(cl.structure().inherited()))).map((Function1 & Serializable & scala.Serializable)d -> "^inherited^ " + MODULE$.showNestedDefinition((Definition)d, nesting), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit())))) + this.lines((Seq<String>)((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.truncateDecls(cl.structure().declared()))).map((Function1 & Serializable & scala.Serializable)d -> MODULE$.showNestedDefinition((Definition)d, nesting), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit())))) + "}";
        }
        return string;
    }

    public String showType(Type t2, int nesting) {
        String string;
        Type type = t2;
        if (type instanceof Projection) {
            Projection projection = (Projection)type;
            string = this.showType(projection.prefix(), nesting) + "#" + projection.id();
        } else if (type instanceof ParameterRef) {
            ParameterRef parameterRef = (ParameterRef)type;
            string = "<" + parameterRef.id() + ">";
        } else if (type instanceof Singleton) {
            Singleton singleton = (Singleton)type;
            string = this.showPath(singleton.path());
        } else if (type instanceof EmptyType) {
            string = "<empty>";
        } else if (type instanceof Parameterized) {
            Parameterized parameterized = (Parameterized)type;
            string = this.showType(parameterized.baseType(), nesting) + new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])parameterized.typeArguments())).map((Function1 & Serializable & scala.Serializable)t -> MODULE$.showType((Type)t, nesting), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString("[", ", ", "]");
        } else if (type instanceof Constant) {
            Constant constant = (Constant)type;
            string = this.showType(constant.baseType(), nesting) + "(" + constant.value() + ")";
        } else if (type instanceof Annotated) {
            Annotated annotated = (Annotated)type;
            string = this.showAnnotations((Seq<Annotation>)Predef$.MODULE$.wrapRefArray((Object[])annotated.annotations()), nesting) + " " + this.showType(annotated.baseType(), nesting);
        } else if (type instanceof Structure) {
            Structure structure2 = (Structure)type;
            string = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])structure2.parents())).map((Function1 & Serializable & scala.Serializable)t -> MODULE$.showType((Type)t, nesting), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(" with ") + (nesting <= 0 ? "{ <nesting level reached> }" : new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.truncateDecls(structure2.declared()))).map((Function1 & Serializable & scala.Serializable)d -> MODULE$.showNestedDefinition((Definition)d, nesting), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(" {", "\n", "}"));
        } else if (type instanceof Existential) {
            Existential existential = (Existential)type;
            string = this.showType(existential.baseType(), nesting) + (nesting <= 0 ? " forSome { <nesting level reached> }" : new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])existential.clause())).map((Function1 & Serializable & scala.Serializable)t -> "type " + MODULE$.showNestedTypeParameter((TypeParameter)t, nesting), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(" forSome { ", "; ", " }"));
        } else if (type instanceof Polymorphic) {
            Polymorphic polymorphic = (Polymorphic)type;
            string = this.showType(polymorphic.baseType(), nesting) + (nesting <= 0 ? " [ <nesting level reached> ]" : this.showNestedTypeParameters((Seq<TypeParameter>)Predef$.MODULE$.wrapRefArray((Object[])polymorphic.parameters()), nesting));
        } else {
            throw new MatchError((Object)type);
        }
        return string;
    }

    private String showPath(Path p) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])p.components())).map((Function1 & Serializable & scala.Serializable)pc -> MODULE$.showPathComponent((PathComponent)pc), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(".");
    }

    private String showPathComponent(PathComponent pc) {
        String string;
        PathComponent pathComponent = pc;
        if (pathComponent instanceof Super) {
            Super super_ = (Super)pathComponent;
            string = "super[" + this.showPath(super_.qualifier()) + "]";
        } else if (pathComponent instanceof This) {
            string = "this";
        } else if (pathComponent instanceof Id) {
            Id id = (Id)pathComponent;
            string = id.id();
        } else {
            throw new MatchError((Object)pathComponent);
        }
        return string;
    }

    private String space(String s) {
        return s.isEmpty() ? s : s + " ";
    }

    private String showMonoDef(Definition d, String label, int nesting) {
        return this.space(this.showAnnotations((Seq<Annotation>)Predef$.MODULE$.wrapRefArray((Object[])d.annotations()), nesting)) + this.space(this.showAccess(d.access())) + this.space(this.showModifiers(d.modifiers())) + this.space(label) + d.name();
    }

    private String showPolyDef(ParameterizedDefinition d, String label, int nesting) {
        return this.showMonoDef((Definition)d, label, nesting) + this.showTypeParameters((Seq<TypeParameter>)Predef$.MODULE$.wrapRefArray((Object[])d.typeParameters()), nesting);
    }

    private String showTypeParameters(Seq<TypeParameter> tps, int nesting) {
        return tps.isEmpty() ? "" : ((TraversableOnce)tps.map((Function1 & Serializable & scala.Serializable)tp -> MODULE$.showTypeParameter((TypeParameter)tp, nesting), Seq$.MODULE$.canBuildFrom())).mkString("[", ", ", "]");
    }

    private String showTypeParameter(TypeParameter tp, int nesting) {
        return this.showAnnotations((Seq<Annotation>)Predef$.MODULE$.wrapRefArray((Object[])tp.annotations()), nesting) + " " + this.showVariance(tp.variance()) + tp.id() + this.showTypeParameters((Seq<TypeParameter>)Predef$.MODULE$.wrapRefArray((Object[])tp.typeParameters()), nesting) + " " + this.showBounds(tp.lowerBound(), tp.upperBound(), nesting);
    }

    private String showAnnotations(Seq<Annotation> as, int nesting) {
        return ((TraversableOnce)as.map((Function1 & Serializable & scala.Serializable)a -> MODULE$.showAnnotation((Annotation)a, nesting), Seq$.MODULE$.canBuildFrom())).mkString(" ");
    }

    private String showAnnotation(Annotation a2, int nesting) {
        return "@" + this.showType(a2.base(), nesting) + (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])a2.arguments())).isEmpty() ? "" : new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])a2.arguments())).map((Function1 & Serializable & scala.Serializable)a -> a.name() + " = " + a.value(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString("(", ", ", ")"));
    }

    private String showBounds(Type lower, Type upper, int nesting) {
        return ">: " + this.showType(lower, nesting) + " <: " + this.showType(upper, nesting);
    }

    private String showValueParams(Seq<ParameterList> ps, int nesting) {
        return ((TraversableOnce)ps.map((Function1 & Serializable & scala.Serializable)pl -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pl.parameters())).map((Function1 & Serializable & scala.Serializable)mp -> mp.name() + ": " + MODULE$.showParameterModifier(MODULE$.showType(mp.tpe(), nesting), mp.modifier()) + (mp.hasDefault() ? "= ..." : ""), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(pl.isImplicit() ? "(implicit " : "(", ", ", ")"), Seq$.MODULE$.canBuildFrom())).mkString("");
    }

    private String showParameterModifier(String base, ParameterModifier pm) {
        String string;
        ParameterModifier parameterModifier = pm;
        if (ParameterModifier.Plain.equals(parameterModifier)) {
            string = base;
        } else if (ParameterModifier.Repeated.equals(parameterModifier)) {
            string = base + "*";
        } else if (ParameterModifier.ByName.equals(parameterModifier)) {
            string = "=> " + base;
        } else {
            throw new MatchError((Object)parameterModifier);
        }
        return string;
    }

    private String showDefinitionType(DefinitionType d) {
        String string;
        DefinitionType definitionType = d;
        if (DefinitionType.Trait.equals(definitionType)) {
            string = "trait";
        } else if (DefinitionType.ClassDef.equals(definitionType)) {
            string = "class";
        } else if (DefinitionType.Module.equals(definitionType)) {
            string = "object";
        } else if (DefinitionType.PackageModule.equals(definitionType)) {
            string = "package object";
        } else {
            throw new MatchError((Object)definitionType);
        }
        return string;
    }

    private String showAccess(Access a) {
        String string;
        Access access = a;
        if (access instanceof Public) {
            string = "";
        } else if (access instanceof Protected) {
            Protected protected_ = (Protected)access;
            string = "protected" + this.showQualifier(protected_.qualifier());
        } else if (access instanceof Private) {
            Private private_ = (Private)access;
            string = "private" + this.showQualifier(private_.qualifier());
        } else {
            throw new MatchError((Object)access);
        }
        return string;
    }

    private String showQualifier(Qualifier q) {
        String string;
        Qualifier qualifier = q;
        if (qualifier instanceof Unqualified) {
            string = "";
        } else if (qualifier instanceof ThisQualifier) {
            string = "[this]";
        } else if (qualifier instanceof IdQualifier) {
            IdQualifier idQualifier = (IdQualifier)qualifier;
            string = "[" + idQualifier.value() + "]";
        } else {
            throw new MatchError((Object)qualifier);
        }
        return string;
    }

    private String showModifiers(Modifiers m) {
        return ((TraversableOnce)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)m.isOverride()), (Object)"override"), new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)m.isFinal()), (Object)"final"), new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)m.isSealed()), (Object)"sealed"), new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)m.isImplicit()), (Object)"implicit"), new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)m.isAbstract()), (Object)"abstract"), new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)m.isLazy()), (Object)"lazy")})).collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<Object, String>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 != null) {
                    boolean bl = A1._1$mcZ$sp();
                    String mod = (String)A1._2();
                    if (bl) {
                        object = mod;
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple2<Object, String> x1) {
                boolean bl;
                Tuple2<Object, String> tuple2 = x1;
                boolean bl2 = tuple2 != null && (bl = tuple2._1$mcZ$sp());
                return bl2;
            }
        }, List$.MODULE$.canBuildFrom())).mkString(" ");
    }

    private String showVariance(Variance v) {
        String string;
        Variance variance = v;
        if (Variance.Invariant.equals(variance)) {
            string = "";
        } else if (Variance.Covariant.equals(variance)) {
            string = "+";
        } else if (Variance.Contravariant.equals(variance)) {
            string = "-";
        } else {
            throw new MatchError((Object)variance);
        }
        return string;
    }

    private String showNestedType(Type tp, int nesting) {
        return this.showType(tp, nesting - 1);
    }

    private String showNestedTypeParameter(TypeParameter tp, int nesting) {
        return this.showTypeParameter(tp, nesting - 1);
    }

    private String showNestedTypeParameters(Seq<TypeParameter> tps, int nesting) {
        return this.showTypeParameters(tps, nesting - 1);
    }

    private String showNestedDefinition(Definition d, int nesting) {
        return this.showDefinition(d, nesting - 1);
    }

    private ShowAPI$() {
        MODULE$ = this;
    }
}

