/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.ant;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import javax.xml.transform.TransformerConfigurationException;
import org.apache.ivy.Ivy;
import org.apache.ivy.ant.AntMessageLogger;
import org.apache.ivy.ant.IvyTask;
import org.apache.ivy.core.IvyContext;
import org.apache.ivy.core.cache.DefaultRepositoryCacheManager;
import org.apache.ivy.core.settings.IvySettings;
import org.apache.ivy.osgi.obr.xml.OBRXMLWriter;
import org.apache.ivy.osgi.repo.FSManifestIterable;
import org.apache.ivy.osgi.repo.ResolverManifestIterable;
import org.apache.ivy.plugins.resolver.BasicResolver;
import org.apache.ivy.util.Message;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ProjectComponent;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class BuildBundleRepoDescriptorTask
extends IvyTask {
    private String resolverName = null;
    private File file = null;
    private String cacheName = null;
    private String encoding = "UTF-8";
    private boolean indent = true;
    private File baseDir;
    private boolean quiet;

    public void setResolver(String string) {
        this.resolverName = string;
    }

    public void setCache(String string) {
        this.cacheName = string;
    }

    public void setOut(File file) {
        this.file = file;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public void setIndent(boolean bl) {
        this.indent = bl;
    }

    public void setBaseDir(File file) {
        this.baseDir = file;
    }

    public void setQuiet(boolean bl) {
        this.quiet = bl;
    }

    @Override
    protected void prepareTask() {
        if (this.baseDir == null) {
            super.prepareTask();
        }
    }

    @Override
    public void doExecute() throws BuildException {
        Iterator iterator;
        Object object;
        Object object2;
        Object object3;
        if (this.file == null) {
            throw new BuildException("No output file specified: use the attribute 'out'");
        }
        if (this.resolverName != null) {
            if (this.baseDir != null) {
                throw new BuildException("specify only one of 'resolver' or 'baseDir'");
            }
            if (this.cacheName != null) {
                throw new BuildException("specify only one of 'resolver' or 'cache'");
            }
            object3 = this.getIvyInstance();
            object2 = ((Ivy)object3).getSettings();
            object = ((IvySettings)object2).getResolver(this.resolverName);
            if (object == null) {
                throw new BuildException("the resolver '" + this.resolverName + "' was not found");
            }
            if (!(object instanceof BasicResolver)) {
                throw new BuildException("the type of resolver '" + object.getClass().getName() + "' is not supported.");
            }
            iterator = new ResolverManifestIterable((BasicResolver)object).iterator();
        } else if (this.baseDir != null) {
            if (this.cacheName != null) {
                throw new BuildException("specify only one of 'baseDir' or 'cache'");
            }
            if (!this.baseDir.isDirectory()) {
                throw new BuildException(this.baseDir + " is not a directory");
            }
            iterator = new FSManifestIterable(this.baseDir).iterator();
        } else if (this.cacheName != null) {
            object3 = this.getIvyInstance();
            object2 = ((Ivy)object3).getSettings().getRepositoryCacheManager(this.cacheName);
            if (!(object2 instanceof DefaultRepositoryCacheManager)) {
                throw new BuildException("the type of cache '" + object2.getClass().getName() + "' is not supported.");
            }
            object = ((DefaultRepositoryCacheManager)object2).getBasedir();
            iterator = new FSManifestIterable((File)object).iterator();
        } else {
            throw new BuildException("No resolver, cache or basedir specified: please provide one of them through the attribute 'resolver', 'cache' or 'dir'");
        }
        try {
            object3 = new FileOutputStream(this.file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new BuildException(this.file + " was not found", (Throwable)fileNotFoundException);
        }
        try {
            object2 = OBRXMLWriter.newHandler((OutputStream)object3, this.encoding, this.indent);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw new BuildException("Sax configuration error: " + transformerConfigurationException.getMessage(), (Throwable)transformerConfigurationException);
        }
        IvyContext.getContext().getMessageLogger();
        class AntMessageLogger2
        extends AntMessageLogger {
            AntMessageLogger2() {
                super((ProjectComponent)BuildBundleRepoDescriptorTask.this);
            }
        }
        Message.setDefaultLogger(new AntMessageLogger2());
        try {
            OBRXMLWriter.writeManifests(iterator, (ContentHandler)object2, this.quiet);
        }
        catch (SAXException sAXException) {
            throw new BuildException("Sax serialisation error: " + sAXException.getMessage(), (Throwable)sAXException);
        }
        try {
            ((OutputStream)object3).flush();
            ((OutputStream)object3).close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Message.sumupProblems();
    }
}

