/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.ant;

import java.io.File;
import java.net.MalformedURLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.ivy.Ivy;
import org.apache.ivy.ant.IvyTask;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.Configuration;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.resolve.ResolvedModuleRevision;
import org.apache.ivy.core.settings.IvySettings;
import org.apache.ivy.plugins.parser.ModuleDescriptorParserRegistry;
import org.apache.tools.ant.BuildException;

public class IvyInfo
extends IvyTask {
    private File file = null;
    private String organisation;
    private String module;
    private String branch;
    private String revision;
    private String property = "ivy";

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public String getModule() {
        return this.module;
    }

    public void setModule(String string) {
        this.module = string;
    }

    public String getOrganisation() {
        return this.organisation;
    }

    public void setOrganisation(String string) {
        this.organisation = string;
    }

    public String getRevision() {
        return this.revision;
    }

    public void setRevision(String string) {
        this.revision = string;
    }

    public String getBranch() {
        return this.branch;
    }

    public void setBranch(String string) {
        this.branch = string;
    }

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String string) {
        this.property = string;
    }

    @Override
    public void doExecute() throws BuildException {
        Ivy ivy = this.getIvyInstance();
        IvySettings ivySettings = ivy.getSettings();
        try {
            if (this.organisation != null || this.module != null || this.revision != null || this.branch != null) {
                ResolvedModuleRevision resolvedModuleRevision;
                if (this.organisation == null) {
                    throw new BuildException("no organisation provided for ivy info task");
                }
                if (this.module == null) {
                    throw new BuildException("no module name provided for ivy info task");
                }
                if (this.revision == null) {
                    throw new BuildException("no revision provided for ivy info task");
                }
                if (this.branch == null) {
                    ivySettings.getDefaultBranch(new ModuleId(this.organisation, this.module));
                }
                if ((resolvedModuleRevision = ivy.findModule(ModuleRevisionId.newInstance(this.organisation, this.module, this.branch, this.revision))) != null) {
                    ModuleDescriptor moduleDescriptor = resolvedModuleRevision.getDescriptor();
                    ModuleRevisionId moduleRevisionId = resolvedModuleRevision.getId();
                    this.setProperties(moduleDescriptor, moduleRevisionId);
                }
            } else {
                if (this.file == null) {
                    this.file = this.getProject().resolveFile(this.getProperty(ivySettings, "ivy.dep.file"));
                }
                ModuleDescriptor moduleDescriptor = ModuleDescriptorParserRegistry.getInstance().parseDescriptor(ivySettings, this.file.toURI().toURL(), this.doValidate(ivySettings));
                ModuleRevisionId moduleRevisionId = moduleDescriptor.getModuleRevisionId();
                this.setProperties(moduleDescriptor, moduleRevisionId);
            }
        }
        catch (MalformedURLException malformedURLException) {
            throw new BuildException("unable to convert given ivy file to url: " + this.file + ": " + malformedURLException, (Throwable)malformedURLException);
        }
        catch (ParseException parseException) {
            this.log(parseException.getMessage(), 0);
            throw new BuildException("syntax errors in ivy file: " + parseException, (Throwable)parseException);
        }
        catch (Exception exception) {
            throw new BuildException("impossible to resolve dependencies: " + exception, (Throwable)exception);
        }
    }

    private void setProperties(ModuleDescriptor moduleDescriptor, ModuleRevisionId moduleRevisionId) {
        Artifact[] artifactArray;
        this.getProject().setProperty(this.property + ".organisation", moduleRevisionId.getOrganisation());
        this.getProject().setProperty(this.property + ".module", moduleRevisionId.getName());
        if (moduleRevisionId.getBranch() != null) {
            this.getProject().setProperty(this.property + ".branch", moduleRevisionId.getBranch());
        }
        this.getProject().setProperty(this.property + ".revision", moduleRevisionId.getRevision());
        this.getProject().setProperty(this.property + ".status", moduleDescriptor.getStatus());
        if (moduleDescriptor.getPublicationDate() != null) {
            this.getProject().setProperty(this.property + ".publication", Long.toString(moduleDescriptor.getPublicationDate().getTime()));
        }
        Map map = moduleRevisionId.getExtraAttributes();
        for (Map.Entry object2 : map.entrySet()) {
            this.getProject().setProperty(this.property + ".extra." + object2.getKey(), (String)object2.getValue());
        }
        this.getProject().setProperty(this.property + ".configurations", this.mergeConfs(moduleDescriptor.getConfigurationsNames()));
        Configuration[] configurationArray = moduleDescriptor.getConfigurations();
        ArrayList<Artifact[]> arrayList = new ArrayList<Artifact[]>();
        for (int stringArray = 0; stringArray < configurationArray.length; ++stringArray) {
            artifactArray = configurationArray[stringArray].getName();
            if (Configuration.Visibility.PUBLIC.equals(configurationArray[stringArray].getVisibility())) {
                arrayList.add(artifactArray);
            }
            if (configurationArray[stringArray].getDescription() == null) continue;
            this.getProject().setProperty(this.property + ".configuration." + (String)artifactArray + ".desc", configurationArray[stringArray].getDescription());
        }
        String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
        this.getProject().setProperty(this.property + ".public.configurations", this.mergeConfs(stringArray));
        artifactArray = moduleDescriptor.getAllArtifacts();
        for (int i = 0; i < artifactArray.length; ++i) {
            int n = i + 1;
            this.getProject().setProperty(this.property + ".artifact." + n + ".name", artifactArray[i].getName());
            this.getProject().setProperty(this.property + ".artifact." + n + ".type", artifactArray[i].getType());
            this.getProject().setProperty(this.property + ".artifact." + n + ".ext", artifactArray[i].getExt());
            this.getProject().setProperty(this.property + ".artifact." + n + ".conf", this.mergeConfs(artifactArray[i].getConfigurations()));
            Map map2 = artifactArray[i].getExtraAttributes();
            for (Map.Entry entry : map2.entrySet()) {
                this.getProject().setProperty(this.property + ".artifact." + n + ".extra." + entry.getKey(), (String)entry.getValue());
            }
        }
    }
}

