/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.event;

import java.util.Arrays;
import javax.swing.event.EventListenerList;
import org.apache.ivy.core.event.FilteredIvyListener;
import org.apache.ivy.core.event.IvyEvent;
import org.apache.ivy.core.event.IvyEventFilter;
import org.apache.ivy.core.event.IvyListener;
import org.apache.ivy.plugins.repository.TransferEvent;
import org.apache.ivy.plugins.repository.TransferListener;
import org.apache.ivy.util.filter.Filter;

public class EventManager
implements TransferListener {
    private EventListenerList listeners = new EventListenerList();

    public void addIvyListener(IvyListener ivyListener) {
        this.listeners.add(IvyListener.class, ivyListener);
    }

    public void addIvyListener(IvyListener ivyListener, String string) {
        this.addIvyListener(ivyListener, new IvyEventFilter(string, null, null));
    }

    public void addIvyListener(IvyListener ivyListener, Filter filter) {
        this.listeners.add(IvyListener.class, new FilteredIvyListener(ivyListener, filter));
    }

    public void removeIvyListener(IvyListener ivyListener) {
        this.listeners.remove(IvyListener.class, ivyListener);
        IvyListener[] ivyListenerArray = (IvyListener[])this.listeners.getListeners(IvyListener.class);
        for (int i = 0; i < ivyListenerArray.length; ++i) {
            if (!(ivyListenerArray[i] instanceof FilteredIvyListener) || !ivyListener.equals(((FilteredIvyListener)ivyListenerArray[i]).getIvyListener())) continue;
            this.listeners.remove(IvyListener.class, ivyListenerArray[i]);
        }
    }

    public boolean hasIvyListener(IvyListener ivyListener) {
        return Arrays.asList(this.listeners.getListeners(IvyListener.class)).contains(ivyListener);
    }

    public void fireIvyEvent(IvyEvent ivyEvent) {
        Object[] objectArray = this.listeners.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != IvyListener.class) continue;
            ((IvyListener)objectArray[i + 1]).progress(ivyEvent);
        }
    }

    public void addTransferListener(TransferListener transferListener) {
        this.listeners.add(TransferListener.class, transferListener);
    }

    public void removeTransferListener(TransferListener transferListener) {
        this.listeners.remove(TransferListener.class, transferListener);
    }

    public boolean hasTransferListener(TransferListener transferListener) {
        return Arrays.asList(this.listeners.getListeners(TransferListener.class)).contains(transferListener);
    }

    protected void fireTransferEvent(TransferEvent transferEvent) {
        Object[] objectArray = this.listeners.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != TransferListener.class) continue;
            ((TransferListener)objectArray[i + 1]).transferProgress(transferEvent);
        }
    }

    @Override
    public void transferProgress(TransferEvent transferEvent) {
        this.fireTransferEvent(transferEvent);
        this.fireIvyEvent(transferEvent);
    }
}

