/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.publish;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.apache.ivy.core.IvyContext;
import org.apache.ivy.core.IvyPatternHelper;
import org.apache.ivy.core.event.EventManager;
import org.apache.ivy.core.event.publish.EndArtifactPublishEvent;
import org.apache.ivy.core.event.publish.StartArtifactPublishEvent;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.DefaultArtifact;
import org.apache.ivy.core.module.descriptor.MDArtifact;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.publish.PublishEngineSettings;
import org.apache.ivy.core.publish.PublishOptions;
import org.apache.ivy.plugins.parser.xml.UpdateOptions;
import org.apache.ivy.plugins.parser.xml.XmlModuleDescriptorParser;
import org.apache.ivy.plugins.parser.xml.XmlModuleDescriptorUpdater;
import org.apache.ivy.plugins.resolver.DependencyResolver;
import org.apache.ivy.util.ConfigurationUtils;
import org.apache.ivy.util.Message;
import org.xml.sax.SAXException;

public class PublishEngine {
    private PublishEngineSettings settings;
    private EventManager eventManager;

    public PublishEngine(PublishEngineSettings publishEngineSettings, EventManager eventManager) {
        this.settings = publishEngineSettings;
        this.eventManager = eventManager;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection publish(ModuleRevisionId moduleRevisionId, Collection collection, String string, PublishOptions publishOptions) throws IOException {
        Object object;
        Object object2;
        ModuleDescriptor moduleDescriptor;
        long l;
        block13: {
            Message.info(":: publishing :: " + moduleRevisionId.getModuleId());
            Message.verbose("\tvalidate = " + publishOptions.isValidate());
            l = System.currentTimeMillis();
            publishOptions.setSrcIvyPattern(this.settings.substitute(publishOptions.getSrcIvyPattern()));
            if (publishOptions.getPubBranch() == null) {
                publishOptions.setPubbranch(moduleRevisionId.getBranch());
            }
            if (publishOptions.getPubrevision() == null) {
                publishOptions.setPubrevision(moduleRevisionId.getRevision());
            }
            ModuleRevisionId moduleRevisionId2 = ModuleRevisionId.newInstance(moduleRevisionId, publishOptions.getPubBranch(), publishOptions.getPubrevision());
            moduleDescriptor = null;
            if (publishOptions.getSrcIvyPattern() != null) {
                object2 = this.settings.resolveFile(IvyPatternHelper.substitute(publishOptions.getSrcIvyPattern(), DefaultArtifact.newIvyArtifact(moduleRevisionId2, new Date())));
                if (!((File)object2).exists()) {
                    throw new IllegalArgumentException("ivy file to publish not found for " + moduleRevisionId + ": call deliver before (" + object2 + ")");
                }
                object = ((File)object2).toURI().toURL();
                try {
                    moduleDescriptor = XmlModuleDescriptorParser.getInstance().parseDescriptor(this.settings, (URL)object, false);
                    if (publishOptions.isUpdate()) {
                        File file = File.createTempFile("ivy", ".xml");
                        file.deleteOnExit();
                        String[] stringArray = ConfigurationUtils.replaceWildcards(publishOptions.getConfs(), moduleDescriptor);
                        HashSet<String> hashSet = new HashSet<String>(Arrays.asList(moduleDescriptor.getConfigurationsNames()));
                        hashSet.removeAll(Arrays.asList(stringArray));
                        try {
                            XmlModuleDescriptorUpdater.update((URL)object, file, new UpdateOptions().setSettings(this.settings).setStatus(publishOptions.getStatus() == null ? moduleDescriptor.getStatus() : publishOptions.getStatus()).setRevision(publishOptions.getPubrevision()).setBranch(publishOptions.getPubBranch()).setPubdate(publishOptions.getPubdate() == null ? new Date() : publishOptions.getPubdate()).setMerge(publishOptions.isMerge()).setMergedDescriptor(moduleDescriptor).setConfsToExclude(hashSet.toArray(new String[hashSet.size()])));
                            object2 = file;
                            moduleDescriptor = XmlModuleDescriptorParser.getInstance().parseDescriptor(this.settings, ((File)object2).toURI().toURL(), false);
                            publishOptions.setSrcIvyPattern(((File)object2).getAbsolutePath());
                            break block13;
                        }
                        catch (SAXException sAXException) {
                            throw new IllegalStateException("bad ivy file for " + moduleRevisionId + ": " + object2 + ": " + sAXException);
                        }
                    }
                    if (!publishOptions.getPubrevision().equals(moduleDescriptor.getModuleRevisionId().getRevision())) {
                        throw new IllegalArgumentException("cannot publish " + object2 + " as " + publishOptions.getPubrevision() + ": bad revision found in ivy file (Revision: " + moduleDescriptor.getModuleRevisionId().getRevision() + "). Use forcedeliver or update.");
                    }
                    break block13;
                }
                catch (ParseException parseException) {
                    throw new IllegalStateException("bad ivy file for " + moduleRevisionId + ": " + object2 + ": " + parseException);
                }
            }
            object2 = this.settings.getResolutionCacheManager();
            try {
                moduleDescriptor = object2.getResolvedModuleDescriptor(moduleRevisionId);
            }
            catch (ParseException parseException) {
                throw new IllegalStateException("bad ivy file in cache for " + moduleRevisionId + ": " + parseException);
            }
            moduleDescriptor.setResolvedModuleRevisionId(moduleRevisionId2);
        }
        object2 = this.settings.getResolver(string);
        if (object2 == null) {
            throw new IllegalArgumentException("unknown resolver " + string);
        }
        object = this.publish(moduleDescriptor, collection, (DependencyResolver)object2, publishOptions);
        Message.verbose("\tpublish done (" + (System.currentTimeMillis() - l) + "ms)");
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection publish(ModuleDescriptor moduleDescriptor, Collection collection, DependencyResolver dependencyResolver, PublishOptions publishOptions) throws IOException {
        Object object;
        Object object22;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        LinkedHashSet<Artifact> linkedHashSet = new LinkedHashSet<Artifact>();
        String[] stringArray = ConfigurationUtils.replaceWildcards(publishOptions.getConfs(), moduleDescriptor);
        for (int i = 0; i < stringArray.length; ++i) {
            Artifact[] artifactArray = moduleDescriptor.getArtifacts(stringArray[i]);
            for (int j = 0; j < artifactArray.length; ++j) {
                linkedHashSet.add(artifactArray[j]);
            }
        }
        Artifact[] artifactArray = publishOptions.getExtraArtifacts();
        if (artifactArray != null) {
            for (int i = 0; i < artifactArray.length; ++i) {
                linkedHashSet.add(new MDArtifact(moduleDescriptor, artifactArray[i].getName(), artifactArray[i].getType(), artifactArray[i].getExt(), artifactArray[i].getUrl(), artifactArray[i].getQualifiedExtraAttributes()));
            }
        }
        LinkedHashMap<Object, File> linkedHashMap = new LinkedHashMap<Object, File>();
        for (Artifact object4 : linkedHashSet) {
            for (Object object22 : collection) {
                object = this.settings.resolveFile(IvyPatternHelper.substitute(this.settings.substitute((String)object22), object4));
                if (!((File)object).exists()) continue;
                linkedHashMap.put(object4, (File)object);
                break;
            }
            if (linkedHashMap.containsKey(object4)) continue;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("missing artifact " + object4 + ":\n");
            object22 = collection.iterator();
            while (object22.hasNext()) {
                object = (String)object22.next();
                stringBuffer.append("\t" + this.settings.resolveFile(IvyPatternHelper.substitute((String)object, object4)) + " file does not exist\n");
            }
            if (publishOptions.isWarnOnMissing() || publishOptions.isHaltOnMissing()) {
                Message.warn(stringBuffer.toString());
            } else {
                Message.verbose(stringBuffer.toString());
            }
            if (publishOptions.isHaltOnMissing()) {
                throw new IOException("missing artifact " + object4);
            }
            arrayList.add(object4);
        }
        if (publishOptions.getSrcIvyPattern() != null) {
            Artifact artifact = MDArtifact.newIvyArtifact(moduleDescriptor);
            File file = this.settings.resolveFile(IvyPatternHelper.substitute(publishOptions.getSrcIvyPattern(), artifact));
            if (!file.exists()) {
                String string = "missing ivy file for " + moduleDescriptor.getModuleRevisionId() + ": \n" + file + " file does not exist";
                if (publishOptions.isWarnOnMissing() || publishOptions.isHaltOnMissing()) {
                    Message.warn(string);
                } else {
                    Message.verbose(string);
                }
                if (publishOptions.isHaltOnMissing()) {
                    throw new IOException("missing ivy artifact " + artifact);
                }
                arrayList.add(artifact);
            } else {
                linkedHashMap.put(artifact, file);
            }
        }
        boolean bl = false;
        try {
            dependencyResolver.beginPublishTransaction(moduleDescriptor.getModuleRevisionId(), publishOptions.isOverwrite());
            for (Map.Entry entry : linkedHashMap.entrySet()) {
                object22 = (Artifact)entry.getKey();
                object = (File)entry.getValue();
                this.publish((Artifact)object22, (File)object, dependencyResolver, publishOptions.isOverwrite());
            }
            dependencyResolver.commitPublishTransaction();
            bl = true;
        }
        finally {
            if (!bl) {
                dependencyResolver.abortPublishTransaction();
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void publish(Artifact artifact, File file, DependencyResolver dependencyResolver, boolean bl) throws IOException {
        IvyContext.getContext().checkInterrupted();
        this.eventManager.fireIvyEvent(new StartArtifactPublishEvent(dependencyResolver, artifact, file, bl));
        boolean bl2 = false;
        try {
            if (file.exists()) {
                dependencyResolver.publish(artifact, file, bl);
                bl2 = true;
            }
        }
        finally {
            this.eventManager.fireIvyEvent(new EndArtifactPublishEvent(dependencyResolver, artifact, file, bl, bl2));
        }
    }
}

