/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.retrieve;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.ivy.core.IvyContext;
import org.apache.ivy.core.IvyPatternHelper;
import org.apache.ivy.core.cache.ResolutionCacheManager;
import org.apache.ivy.core.event.EventManager;
import org.apache.ivy.core.event.retrieve.EndRetrieveArtifactEvent;
import org.apache.ivy.core.event.retrieve.EndRetrieveEvent;
import org.apache.ivy.core.event.retrieve.StartRetrieveArtifactEvent;
import org.apache.ivy.core.event.retrieve.StartRetrieveEvent;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ArtifactRevisionId;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.report.ArtifactDownloadReport;
import org.apache.ivy.core.resolve.ResolveOptions;
import org.apache.ivy.core.retrieve.RetrieveEngineSettings;
import org.apache.ivy.core.retrieve.RetrieveOptions;
import org.apache.ivy.core.retrieve.RetrieveReport;
import org.apache.ivy.plugins.report.XmlReportParser;
import org.apache.ivy.util.FileUtil;
import org.apache.ivy.util.Message;

public class RetrieveEngine {
    private static final int KILO = 1024;
    private RetrieveEngineSettings settings;
    private EventManager eventManager;

    public RetrieveEngine(RetrieveEngineSettings retrieveEngineSettings, EventManager eventManager) {
        this.settings = retrieveEngineSettings;
        this.eventManager = eventManager;
    }

    public int retrieve(ModuleRevisionId moduleRevisionId, String string, RetrieveOptions retrieveOptions) throws IOException {
        RetrieveOptions retrieveOptions2 = new RetrieveOptions(retrieveOptions);
        retrieveOptions2.setDestArtifactPattern(string);
        RetrieveReport retrieveReport = this.retrieve(moduleRevisionId, retrieveOptions2);
        return retrieveReport.getNbrArtifactsCopied();
    }

    public RetrieveReport retrieve(ModuleRevisionId moduleRevisionId, RetrieveOptions retrieveOptions) throws IOException {
        RetrieveReport retrieveReport = new RetrieveReport();
        ModuleId moduleId = moduleRevisionId.getModuleId();
        if ("default".equals(retrieveOptions.getLog())) {
            Message.info(":: retrieving :: " + moduleId + (retrieveOptions.isSync() ? " [sync]" : ""));
        } else {
            Message.verbose(":: retrieving :: " + moduleId + (retrieveOptions.isSync() ? " [sync]" : ""));
        }
        Message.verbose("\tcheckUpToDate=" + this.settings.isCheckUpToDate());
        long l = System.currentTimeMillis();
        String string = IvyPatternHelper.substituteVariables(retrieveOptions.getDestArtifactPattern(), this.settings.getVariables());
        String string2 = IvyPatternHelper.substituteVariables(retrieveOptions.getDestIvyPattern(), this.settings.getVariables());
        String[] stringArray = this.getConfs(moduleRevisionId, retrieveOptions);
        if ("default".equals(retrieveOptions.getLog())) {
            Message.info("\tconfs: " + Arrays.asList(stringArray));
        } else {
            Message.verbose("\tconfs: " + Arrays.asList(stringArray));
        }
        if (this.eventManager != null) {
            this.eventManager.fireIvyEvent(new StartRetrieveEvent(moduleRevisionId, stringArray, retrieveOptions));
        }
        try {
            Object object;
            Object object2;
            Set set;
            Object object3;
            Map map = this.determineArtifactsToCopy(moduleRevisionId, string, retrieveOptions);
            File file = this.settings.resolveFile(IvyPatternHelper.getTokenRoot(string));
            retrieveReport.setRetrieveRoot(file);
            File file2 = string2 == null ? null : this.settings.resolveFile(IvyPatternHelper.getTokenRoot(string2));
            HashSet hashSet = new HashSet();
            HashSet hashSet2 = new HashSet();
            long l2 = 0L;
            for (Object object4 : map.keySet()) {
                object3 = ((ArtifactDownloadReport)object4).getLocalFile();
                if (object3 == null) {
                    Message.verbose("\tno local file available for " + object4 + ": skipping");
                    continue;
                }
                set = (Set)map.get(object4);
                Message.verbose("\tretrieving " + object3);
                object2 = set.iterator();
                while (object2.hasNext()) {
                    IvyContext.getContext().checkInterrupted();
                    object = this.settings.resolveFile((String)object2.next());
                    if (!this.settings.isCheckUpToDate() || !this.upToDate((File)object3, (File)object, retrieveOptions)) {
                        Message.verbose("\t\tto " + object);
                        if (this.eventManager != null) {
                            this.eventManager.fireIvyEvent(new StartRetrieveArtifactEvent((ArtifactDownloadReport)object4, (File)object));
                        }
                        if (retrieveOptions.isMakeSymlinks()) {
                            FileUtil.symlink((File)object3, (File)object, null, true);
                        } else {
                            FileUtil.copy((File)object3, (File)object, null, true);
                        }
                        if (this.eventManager != null) {
                            this.eventManager.fireIvyEvent(new EndRetrieveArtifactEvent((ArtifactDownloadReport)object4, (File)object));
                        }
                        l2 += ((File)object).length();
                        retrieveReport.addCopiedFile((File)object, (ArtifactDownloadReport)object4);
                    } else {
                        Message.verbose("\t\tto " + object + " [NOT REQUIRED]");
                        retrieveReport.addUpToDateFile((File)object, (ArtifactDownloadReport)object4);
                    }
                    if ("ivy".equals(((ArtifactDownloadReport)object4).getType())) {
                        hashSet2.addAll(FileUtil.getPathFiles(file2, (File)object));
                        continue;
                    }
                    hashSet.addAll(FileUtil.getPathFiles(file, (File)object));
                }
            }
            if (retrieveOptions.isSync()) {
                Object object4;
                Message.verbose("\tsyncing...");
                String[] stringArray2 = this.settings.getIgnorableFilenames();
                object4 = Arrays.asList(stringArray2);
                object3 = FileUtil.listAll(file, (Collection)object4);
                Collection collection = set = file2 == null ? null : FileUtil.listAll(file2, (Collection)object4);
                if (file.equals(file2)) {
                    object2 = hashSet;
                    object2.addAll(hashSet2);
                    object = object3;
                    object.addAll(set);
                    this.sync((Collection)object2, (Collection)object);
                } else {
                    this.sync(hashSet, (Collection)object3);
                    if (set != null) {
                        this.sync(hashSet2, set);
                    }
                }
            }
            long l3 = System.currentTimeMillis() - l;
            object3 = "\t" + retrieveReport.getNbrArtifactsCopied() + " artifacts copied" + (this.settings.isCheckUpToDate() ? ", " + retrieveReport.getNbrArtifactsUpToDate() + " already retrieved" : "") + " (" + l2 / 1024L + "kB/" + l3 + "ms)";
            if ("default".equals(retrieveOptions.getLog())) {
                Message.info((String)object3);
            } else {
                Message.verbose((String)object3);
            }
            Message.verbose("\tretrieve done (" + l3 + "ms)");
            if (this.eventManager != null) {
                this.eventManager.fireIvyEvent(new EndRetrieveEvent(moduleRevisionId, stringArray, l3, retrieveReport.getNbrArtifactsCopied(), retrieveReport.getNbrArtifactsUpToDate(), l2, retrieveOptions));
            }
            return retrieveReport;
        }
        catch (Exception exception) {
            throw new RuntimeException("problem during retrieve of " + moduleId + ": " + exception, exception);
        }
    }

    private String[] getConfs(ModuleRevisionId moduleRevisionId, RetrieveOptions retrieveOptions) throws IOException {
        String[] stringArray = retrieveOptions.getConfs();
        if (stringArray == null || stringArray.length == 1 && "*".equals(stringArray[0])) {
            try {
                ModuleDescriptor moduleDescriptor = this.getCache().getResolvedModuleDescriptor(moduleRevisionId);
                Message.verbose("no explicit confs given for retrieve, using ivy file: " + moduleDescriptor.getResource().getName());
                stringArray = moduleDescriptor.getConfigurationsNames();
                retrieveOptions.setConfs(stringArray);
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (Exception exception) {
                IOException iOException = new IOException(exception.getMessage());
                iOException.initCause(exception);
                throw iOException;
            }
        }
        return stringArray;
    }

    private ResolutionCacheManager getCache() {
        return this.settings.getResolutionCacheManager();
    }

    private void sync(Collection collection, Collection collection2) {
        HashSet<File> hashSet = new HashSet<File>();
        for (File file : collection2) {
            hashSet.add(file.getAbsoluteFile());
        }
        for (File file : collection) {
            hashSet.remove(file.getAbsoluteFile());
        }
        for (File file : hashSet) {
            if (!file.exists()) continue;
            Message.verbose("\t\tdeleting " + file);
            FileUtil.forceDelete(file);
        }
    }

    public Map determineArtifactsToCopy(ModuleRevisionId moduleRevisionId, String string, RetrieveOptions retrieveOptions) throws ParseException, IOException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Collection<ArtifactDownloadReport> collection;
        Object object5;
        ModuleId moduleId = moduleRevisionId.getModuleId();
        if (retrieveOptions.getResolveId() == null) {
            retrieveOptions.setResolveId(ResolveOptions.getDefaultResolveId(moduleId));
        }
        ResolutionCacheManager resolutionCacheManager = this.getCache();
        String[] stringArray = this.getConfs(moduleRevisionId, retrieveOptions);
        String string2 = IvyPatternHelper.substituteVariables(retrieveOptions.getDestIvyPattern(), this.settings.getVariables());
        HashMap hashMap = new HashMap();
        HashMap hashMap2 = new HashMap();
        HashMap hashMap3 = new HashMap();
        HashMap hashMap4 = new HashMap();
        XmlReportParser xmlReportParser = new XmlReportParser();
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = stringArray[i];
            object5 = resolutionCacheManager.getConfigurationResolveReportInCache(retrieveOptions.getResolveId(), string3);
            xmlReportParser.parse((File)object5);
            collection = new ArrayList<ArtifactDownloadReport>(Arrays.asList(xmlReportParser.getArtifactReports()));
            if (string2 != null) {
                object4 = xmlReportParser.getRealDependencyRevisionIds();
                for (int j = 0; j < ((Object)object4).length; ++j) {
                    collection.add(xmlReportParser.getMetadataArtifactReport((ModuleRevisionId)object4[j]));
                }
            }
            for (ArtifactDownloadReport artifactDownloadReport : collection) {
                Object object6 = object3 = "ivy".equals(artifactDownloadReport.getType()) ? string2 : string;
                if (!"ivy".equals(artifactDownloadReport.getType()) && !retrieveOptions.getArtifactFilter().accept(artifactDownloadReport.getArtifact())) continue;
                String string4 = IvyPatternHelper.substitute((String)object3, artifactDownloadReport.getArtifact().getModuleRevisionId(), artifactDownloadReport.getArtifact(), string3, artifactDownloadReport.getArtifactOrigin());
                object2 = (Set)hashMap.get(artifactDownloadReport);
                if (object2 == null) {
                    object2 = new HashSet<String>();
                    hashMap.put(artifactDownloadReport, object2);
                }
                object = this.settings.resolveFile(string4).getAbsolutePath();
                String[] stringArray2 = new String[]{object};
                if (retrieveOptions.getMapper() != null) {
                    stringArray2 = retrieveOptions.getMapper().mapFileName((String)object);
                }
                for (int j = 0; j < stringArray2.length; ++j) {
                    object2.add(stringArray2[j]);
                    HashSet<ArtifactRevisionId> hashSet = (HashSet<ArtifactRevisionId>)hashMap2.get(stringArray2[j]);
                    HashSet<ArtifactDownloadReport> hashSet2 = (HashSet<ArtifactDownloadReport>)hashMap3.get(stringArray2[j]);
                    HashSet<String> hashSet3 = (HashSet<String>)hashMap4.get(stringArray2[j]);
                    if (hashSet == null) {
                        hashSet = new HashSet<ArtifactRevisionId>();
                        hashMap2.put(stringArray2[j], hashSet);
                    }
                    if (hashSet2 == null) {
                        hashSet2 = new HashSet<ArtifactDownloadReport>();
                        hashMap3.put(stringArray2[j], hashSet2);
                    }
                    if (hashSet3 == null) {
                        hashSet3 = new HashSet<String>();
                        hashMap4.put(stringArray2[j], hashSet3);
                    }
                    if (!hashSet.add(artifactDownloadReport.getArtifact().getId())) continue;
                    hashSet2.add(artifactDownloadReport);
                    hashSet3.add(string3);
                }
            }
        }
        for (String string3 : hashMap2.keySet()) {
            int n;
            object5 = (Set)hashMap2.get(string3);
            collection = (Set)hashMap4.get(string3);
            if (object5.size() <= 1) continue;
            object4 = new ArrayList((Collection)hashMap3.get(string3));
            Collections.sort(object4, this.getConflictResolvingPolicy());
            ArtifactDownloadReport artifactDownloadReport = (ArtifactDownloadReport)object4.get(object4.size() - 1);
            object3 = artifactDownloadReport.getArtifact().getModuleRevisionId();
            for (n = object4.size() - 2; n >= 0; --n) {
                object2 = (ArtifactDownloadReport)object4.get(n);
                if (!((ModuleRevisionId)object3).equals(((ArtifactDownloadReport)object2).getArtifact().getModuleRevisionId())) continue;
                throw new RuntimeException("Multiple artifacts of the module " + object3 + " are retrieved to the same file! Update the retrieve pattern " + " to fix this error.");
            }
            Message.info("\tconflict on " + string3 + " in " + collection + ": " + ((ModuleRevisionId)object3).getRevision() + " won");
            for (n = object4.size() - 2; n >= 0; --n) {
                object2 = (ArtifactDownloadReport)object4.get(n);
                Message.verbose("\t\tremoving conflict looser artifact: " + ((ArtifactDownloadReport)object2).getArtifact());
                object = (Set)hashMap.get(object2);
                object.remove(string3);
                if (!object.isEmpty()) continue;
                hashMap.remove(object2);
            }
        }
        return hashMap;
    }

    private boolean upToDate(File file, File file2, RetrieveOptions retrieveOptions) {
        if (!file2.exists()) {
            return false;
        }
        String string = retrieveOptions.getOverwriteMode();
        if ("always".equals(string)) {
            return false;
        }
        if ("never".equals(string)) {
            return true;
        }
        if ("newer".equals(string)) {
            return file.lastModified() <= file2.lastModified();
        }
        if ("different".equals(string)) {
            return file.lastModified() == file2.lastModified();
        }
        return false;
    }

    private Comparator getConflictResolvingPolicy() {
        return new Comparator(){

            public int compare(Object object, Object object2) {
                Artifact artifact = ((ArtifactDownloadReport)object).getArtifact();
                Artifact artifact2 = ((ArtifactDownloadReport)object2).getArtifact();
                if (artifact.getPublicationDate().after(artifact2.getPublicationDate())) {
                    return 1;
                }
                if (artifact.getPublicationDate().before(artifact2.getPublicationDate())) {
                    return -1;
                }
                return 0;
            }
        };
    }
}

