/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.sort;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.sort.ModuleInSort;
import org.apache.ivy.core.sort.NonMatchingVersionReporter;
import org.apache.ivy.plugins.version.VersionMatcher;

class CollectionOfModulesToSort {
    private final List moduleDescriptors;
    private final VersionMatcher versionMatcher;
    private final Map modulesByModuleId;
    private final NonMatchingVersionReporter nonMatchingVersionReporter;

    public CollectionOfModulesToSort(Collection collection, VersionMatcher versionMatcher, NonMatchingVersionReporter nonMatchingVersionReporter) {
        this.versionMatcher = versionMatcher;
        this.nonMatchingVersionReporter = nonMatchingVersionReporter;
        this.modulesByModuleId = new HashMap();
        this.moduleDescriptors = new ArrayList(collection.size());
        for (ModuleDescriptor moduleDescriptor : collection) {
            ModuleInSort moduleInSort = new ModuleInSort(moduleDescriptor);
            this.moduleDescriptors.add(moduleInSort);
            this.addToModulesByModuleId(moduleDescriptor, moduleInSort);
        }
    }

    private void addToModulesByModuleId(ModuleDescriptor moduleDescriptor, ModuleInSort moduleInSort) {
        ModuleId moduleId = moduleDescriptor.getModuleRevisionId().getModuleId();
        LinkedList<ModuleInSort> linkedList = new LinkedList<ModuleInSort>();
        linkedList.add(moduleInSort);
        List list = this.modulesByModuleId.put(moduleId, linkedList);
        if (list != null) {
            linkedList.addAll(list);
        }
    }

    public Iterator iterator() {
        return this.moduleDescriptors.iterator();
    }

    public int size() {
        return this.moduleDescriptors.size();
    }

    public ModuleInSort getModuleDescriptorDependency(DependencyDescriptor dependencyDescriptor) {
        Collection collection = (Collection)this.modulesByModuleId.get(dependencyDescriptor.getDependencyId());
        if (collection == null) {
            return null;
        }
        for (ModuleInSort moduleInSort : collection) {
            if (moduleInSort.match(dependencyDescriptor, this.versionMatcher)) {
                return moduleInSort;
            }
            this.nonMatchingVersionReporter.reportNonMatchingVersion(dependencyDescriptor, moduleInSort.getSortedModuleDescriptor());
        }
        return null;
    }
}

