/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.osgi.core;

import java.net.URI;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.ivy.osgi.core.BundleCapability;
import org.apache.ivy.osgi.core.BundleRequirement;
import org.apache.ivy.osgi.core.ExportPackage;
import org.apache.ivy.osgi.util.Version;

public class BundleInfo {
    public static final Version DEFAULT_VERSION = new Version(1, 0, 0, null);
    public static final String PACKAGE_TYPE = "package";
    public static final String BUNDLE_TYPE = "bundle";
    public static final String SERVICE_TYPE = "service";
    private String symbolicName;
    private String presentationName;
    private String id;
    private Version version;
    private Set requirements = new LinkedHashSet();
    private Set capabilities = new LinkedHashSet();
    private List executionEnvironments = Collections.EMPTY_LIST;
    private String description;
    private String documentation;
    private String license;
    private Integer size;
    private URI uri;

    public BundleInfo(String string, Version version) {
        this.symbolicName = string;
        this.version = version;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("BundleInfo [executionEnvironments=");
        stringBuffer.append(this.executionEnvironments);
        stringBuffer.append(", capabilities=");
        stringBuffer.append(this.capabilities);
        stringBuffer.append(", requirements=");
        stringBuffer.append(this.requirements);
        stringBuffer.append(", symbolicName=");
        stringBuffer.append(this.symbolicName);
        stringBuffer.append(", version=");
        stringBuffer.append(this.version);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public String getSymbolicName() {
        return this.symbolicName;
    }

    public Version getVersion() {
        return this.version == null ? DEFAULT_VERSION : this.version;
    }

    public Version getRawVersion() {
        return this.version;
    }

    public void setUri(URI uRI) {
        this.uri = uRI;
    }

    public URI getUri() {
        return this.uri;
    }

    public void setId(String string) {
        this.id = string;
    }

    public String getId() {
        return this.id;
    }

    public void setPresentationName(String string) {
        this.presentationName = string;
    }

    public String getPresentationName() {
        return this.presentationName;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDocumentation(String string) {
        this.documentation = string;
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public void setLicense(String string) {
        this.license = string;
    }

    public String getLicense() {
        return this.license;
    }

    public void setSize(Integer n) {
        this.size = n;
    }

    public Integer getSize() {
        return this.size;
    }

    public void addRequirement(BundleRequirement bundleRequirement) {
        this.requirements.add(bundleRequirement);
    }

    public Set getRequirements() {
        return this.requirements;
    }

    public void addCapability(BundleCapability bundleCapability) {
        this.capabilities.add(bundleCapability);
    }

    public Set getCapabilities() {
        return this.capabilities;
    }

    public List getExecutionEnvironments() {
        return this.executionEnvironments;
    }

    public void setExecutionEnvironments(List list) {
        this.executionEnvironments = list;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.capabilities == null ? 0 : ((Object)this.capabilities).hashCode());
        n = 31 * n + (this.requirements == null ? 0 : ((Object)this.requirements).hashCode());
        n = 31 * n + (this.symbolicName == null ? 0 : this.symbolicName.hashCode());
        n = 31 * n + (this.version == null ? 0 : this.version.hashCode());
        n = 31 * n + (this.executionEnvironments == null ? 0 : ((Object)this.executionEnvironments).hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof BundleInfo)) {
            return false;
        }
        BundleInfo bundleInfo = (BundleInfo)object;
        if (this.capabilities == null ? bundleInfo.capabilities != null : !((Object)this.capabilities).equals(bundleInfo.capabilities)) {
            return false;
        }
        if (this.requirements == null ? bundleInfo.requirements != null : !((Object)this.requirements).equals(bundleInfo.requirements)) {
            return false;
        }
        if (this.symbolicName == null ? bundleInfo.symbolicName != null : !this.symbolicName.equals(bundleInfo.symbolicName)) {
            return false;
        }
        if (this.version == null ? bundleInfo.version != null : !this.version.equals(bundleInfo.version)) {
            return false;
        }
        return !(this.executionEnvironments == null ? bundleInfo.executionEnvironments != null : !((Object)this.executionEnvironments).equals(bundleInfo.executionEnvironments));
    }

    public Set getRequires() {
        LinkedHashSet<BundleRequirement> linkedHashSet = new LinkedHashSet<BundleRequirement>();
        for (BundleRequirement bundleRequirement : this.requirements) {
            if (!bundleRequirement.getType().equals(BUNDLE_TYPE)) continue;
            linkedHashSet.add(bundleRequirement);
        }
        return linkedHashSet;
    }

    public Set getImports() {
        LinkedHashSet<BundleRequirement> linkedHashSet = new LinkedHashSet<BundleRequirement>();
        for (BundleRequirement bundleRequirement : this.requirements) {
            if (!bundleRequirement.getType().equals(PACKAGE_TYPE)) continue;
            linkedHashSet.add(bundleRequirement);
        }
        return linkedHashSet;
    }

    public Set getExports() {
        LinkedHashSet<ExportPackage> linkedHashSet = new LinkedHashSet<ExportPackage>();
        for (BundleCapability bundleCapability : this.capabilities) {
            if (!PACKAGE_TYPE.equals(bundleCapability.getType())) continue;
            linkedHashSet.add((ExportPackage)bundleCapability);
        }
        return linkedHashSet;
    }

    public Set getServices() {
        LinkedHashSet<BundleCapability> linkedHashSet = new LinkedHashSet<BundleCapability>();
        for (BundleCapability bundleCapability : this.capabilities) {
            if (!SERVICE_TYPE.equals(bundleCapability.getType())) continue;
            linkedHashSet.add(bundleCapability);
        }
        return linkedHashSet;
    }
}

