/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.repository.sftp;

import java.io.IOException;
import java.io.InputStream;
import org.apache.ivy.plugins.repository.Resource;
import org.apache.ivy.plugins.repository.sftp.SFTPRepository;

public class SFTPResource
implements Resource {
    private SFTPRepository repository;
    private String path;
    private transient boolean init = false;
    private transient boolean exists;
    private transient long lastModified;
    private transient long contentLength;

    public SFTPResource(SFTPRepository sFTPRepository, String string) {
        this.repository = sFTPRepository;
        this.path = string;
    }

    @Override
    public String getName() {
        return this.path;
    }

    @Override
    public Resource clone(String string) {
        return new SFTPResource(this.repository, string);
    }

    @Override
    public long getLastModified() {
        this.init();
        return this.lastModified;
    }

    @Override
    public long getContentLength() {
        this.init();
        return this.contentLength;
    }

    @Override
    public boolean exists() {
        this.init();
        return this.exists;
    }

    private void init() {
        if (!this.init) {
            Resource resource = this.repository.resolveResource(this.path);
            this.contentLength = resource.getContentLength();
            this.lastModified = resource.getLastModified();
            this.exists = resource.exists();
            this.init = true;
        }
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public boolean isLocal() {
        return false;
    }

    @Override
    public InputStream openStream() throws IOException {
        return this.repository.openStream(this);
    }
}

