/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.lock;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.ivy.plugins.lock.AbstractLockStrategy;
import org.apache.ivy.plugins.lock.DeleteOnExitHook;
import org.apache.ivy.plugins.lock.FileBasedLockStrategy$FileLocker;
import org.apache.ivy.util.Message;

public abstract class FileBasedLockStrategy
extends AbstractLockStrategy {
    private FileBasedLockStrategy$FileLocker locker;
    private long timeout = 120000L;
    private Map currentLockCounters = new HashMap();

    protected FileBasedLockStrategy() {
        this(new FileBasedLockStrategy$FileLocker(false), false);
    }

    protected FileBasedLockStrategy(boolean bl) {
        this(new FileBasedLockStrategy$FileLocker(bl), bl);
    }

    private FileBasedLockStrategy(FileBasedLockStrategy$FileLocker fileBasedLockStrategy$FileLocker, boolean bl) {
        super(bl);
        this.locker = fileBasedLockStrategy$FileLocker;
    }

    protected final boolean acquireLock(File file2) {
        if (this.isDebugLocking()) {
            FileBasedLockStrategy.debugLocking("acquiring lock on " + file2);
        }
        long l = System.currentTimeMillis();
        do {
            FileBasedLockStrategy fileBasedLockStrategy = this;
            synchronized (fileBasedLockStrategy) {
                File file3 = file2;
                Integer n = (Integer)this.currentLockCounters.get(file3);
                if (n != null && n > 0) {
                    int n2 = this.incrementLock(file2);
                    if (this.isDebugLocking()) {
                        FileBasedLockStrategy.debugLocking("reentrant lock acquired on " + file2 + " in " + (System.currentTimeMillis() - l) + "ms - hold locks = " + n2);
                    }
                    return true;
                }
                if (this.locker.tryLock(file2)) {
                    if (this.isDebugLocking()) {
                        FileBasedLockStrategy.debugLocking("lock acquired on " + file2 + " in " + (System.currentTimeMillis() - l) + "ms");
                    }
                    this.incrementLock(file2);
                    return true;
                }
            }
            Thread.sleep(100L);
        } while (System.currentTimeMillis() - l < this.timeout);
        return false;
    }

    protected final void releaseLock(File file2) {
        FileBasedLockStrategy fileBasedLockStrategy = this;
        synchronized (fileBasedLockStrategy) {
            File file3 = file2;
            FileBasedLockStrategy fileBasedLockStrategy2 = this;
            Integer n = (Integer)fileBasedLockStrategy2.currentLockCounters.get(file3);
            int n2 = n == null ? 0 : n - 1;
            fileBasedLockStrategy2.currentLockCounters.put(file3, new Integer(n2));
            int n3 = n2;
            if (n3 == 0) {
                File file4 = file2;
                file4.delete();
                DeleteOnExitHook.remove(file4);
                if (this.isDebugLocking()) {
                    FileBasedLockStrategy.debugLocking("lock released on " + file2);
                }
            } else if (this.isDebugLocking()) {
                FileBasedLockStrategy.debugLocking("reentrant lock released on " + file2 + " - hold locks = " + n3);
            }
            return;
        }
    }

    private static void debugLocking(String string) {
        Message.info(Thread.currentThread() + " " + System.currentTimeMillis() + " " + string);
    }

    private int incrementLock(File file2) {
        Integer n = (Integer)this.currentLockCounters.get(file2);
        int n2 = n == null ? 1 : n + 1;
        this.currentLockCounters.put(file2, new Integer(n2));
        return n2;
    }

    static /* synthetic */ void access$000(String string) {
        FileBasedLockStrategy.debugLocking(string);
    }
}

