class Manager(object):

	def __init__(self, manager, editor):
		self.__init_attributes(manager, editor)
		self.__sigid1 = manager.connect("destroy", self.__destroy_cb)
		from Window import Window
		Window(manager, editor)
		from WindowPositioner import Positioner
		Positioner(manager, editor)
		from TreeView import TreeView
		TreeView(manager, editor)

	def __init_attributes(self, manager, editor):
		self.__manager = manager
		self.__editor = editor
		return

	def __destroy(self):
		self.__editor.disconnect_signal(self.__sigid1, self.__manager)
		del self
		return False

	def __destroy_cb(self, *args):
		self.__destroy()
		return False
