/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.loaders.objectfile;

import com.sun.j3d.loaders.ParsingErrorException;
import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;

class ObjectFileParser
extends StreamTokenizer {
    private static final char BACKSLASH = '\\';

    void setup() {
        this.resetSyntax();
        this.eolIsSignificant(true);
        this.lowerCaseMode(true);
        this.wordChars(33, 126);
        this.commentChar(33);
        this.whitespaceChars(32, 32);
        this.whitespaceChars(10, 10);
        this.whitespaceChars(13, 13);
        this.whitespaceChars(9, 9);
        this.ordinaryChar(35);
        this.ordinaryChar(47);
        this.ordinaryChar(92);
    }

    void getToken() throws ParsingErrorException {
        boolean bl = false;
        try {
            do {
                int n;
                if ((n = this.nextToken()) == 92) {
                    n = this.nextToken();
                    if (this.ttype == 10) continue;
                    bl = true;
                    continue;
                }
                bl = true;
            } while (!bl);
        }
        catch (IOException iOException) {
            throw new ParsingErrorException("IO error on line " + this.lineno() + ": " + iOException.getMessage());
        }
    }

    void printToken() {
        switch (this.ttype) {
            case 10: {
                System.out.println("Token EOL");
                break;
            }
            case -1: {
                System.out.println("Token EOF");
                break;
            }
            case -3: {
                System.out.println("Token TT_WORD: " + this.sval);
                break;
            }
            case 47: {
                System.out.println("Token /");
                break;
            }
            case 92: {
                System.out.println("Token \\");
                break;
            }
            case 35: {
                System.out.println("Token #");
            }
        }
    }

    void skipToNextLine() throws ParsingErrorException {
        while (this.ttype != 10 && this.ttype != -1) {
            this.getToken();
        }
    }

    void getNumber() throws ParsingErrorException {
        try {
            this.getToken();
            if (this.ttype != -3) {
                throw new ParsingErrorException("Expected number on line " + this.lineno());
            }
            this.nval = Double.valueOf(this.sval);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParsingErrorException(numberFormatException.getMessage());
        }
    }

    ObjectFileParser(Reader reader) {
        super(reader);
        this.setup();
    }
}

