/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.io.PrintStream;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.Geometry;
import javax.media.j3d.Shader;
import javax.media.j3d.ShaderAppearance;
import javax.media.j3d.ShaderAttribute;
import javax.media.j3d.ShaderAttributeSet;
import javax.media.j3d.ShaderProgram;
import javax.media.j3d.Shape3D;

public class ShaderError {
    private int errorCode = 0;
    private String errorMessage = null;
    private String detailMessage = null;
    private Canvas3D canvas = null;
    private Shape3D shape = null;
    private Geometry geometry = null;
    private ShaderAppearance shaderApp = null;
    private ShaderProgram shaderProgram = null;
    private Shader shader = null;
    private ShaderAttributeSet shaderAttributeSet = null;
    private ShaderAttribute shaderAttribute = null;
    public static final int NO_ERROR = 0;
    public static final int COMPILE_ERROR = 1;
    public static final int LINK_ERROR = 2;
    public static final int VERTEX_ATTRIBUTE_LOOKUP_ERROR = 3;
    public static final int SHADER_ATTRIBUTE_LOOKUP_ERROR = 4;
    public static final int SHADER_ATTRIBUTE_NAME_NOT_SET_ERROR = 5;
    public static final int SHADER_ATTRIBUTE_TYPE_ERROR = 6;
    public static final int UNSUPPORTED_LANGUAGE_ERROR = 7;

    public ShaderError() {
    }

    public ShaderError(int n, String string) {
        this.errorCode = n;
        this.errorMessage = string;
    }

    public void printVerbose() {
        this.printVerbose(System.err);
    }

    public void printVerbose(PrintStream printStream) {
        printStream.println(this);
        if (this.canvas != null) {
            printStream.println("canvas = " + this.canvas);
        }
        if (this.shape != null) {
            printStream.println("shape = " + this.shape);
        }
        if (this.geometry != null) {
            printStream.println("geometry = " + this.geometry);
        }
        if (this.shaderApp != null) {
            printStream.println("shaderApp = " + this.shaderApp);
        }
        if (this.shaderProgram != null) {
            printStream.println("shaderProgram = " + this.shaderProgram);
        }
        if (this.shader != null) {
            printStream.println("shader = " + this.shader);
        }
        if (this.shaderAttributeSet != null) {
            printStream.println("shaderAttributeSet = " + this.shaderAttributeSet);
        }
        if (this.shaderAttribute != null) {
            printStream.println("shaderAttribute = " + this.shaderAttribute);
        }
        if (this.detailMessage != null) {
            printStream.println();
            printStream.println("Detail Message");
            printStream.println("--------------");
            printStream.println(this.detailMessage);
        }
    }

    public void setErrorCode(int n) {
        this.errorCode = n;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public void setErrorMessage(String string) {
        this.errorMessage = string;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setDetailMessage(String string) {
        this.detailMessage = string;
    }

    public String getDetailMessage() {
        return this.detailMessage;
    }

    public void setCanvas3D(Canvas3D canvas3D) {
        this.canvas = canvas3D;
    }

    public Canvas3D getCanvas3D() {
        return this.canvas;
    }

    public void setShape3D(Shape3D shape3D) {
        this.shape = shape3D;
    }

    public Shape3D getShape3D() {
        return this.shape;
    }

    public void setGeometry(Geometry geometry) {
        this.geometry = geometry;
    }

    public Geometry getGeometry() {
        return this.geometry;
    }

    public void setShaderAppearance(ShaderAppearance shaderAppearance) {
        this.shaderApp = shaderAppearance;
    }

    public ShaderAppearance getShaderAppearance() {
        return this.shaderApp;
    }

    public void setShaderProgram(ShaderProgram shaderProgram) {
        this.shaderProgram = shaderProgram;
    }

    public ShaderProgram getShaderProgram() {
        return this.shaderProgram;
    }

    public void setShader(Shader shader) {
        this.shader = shader;
    }

    public Shader getShader() {
        return this.shader;
    }

    public void setShaderAttributeSet(ShaderAttributeSet shaderAttributeSet) {
        this.shaderAttributeSet = shaderAttributeSet;
    }

    public ShaderAttributeSet getShaderAttributeSet() {
        return this.shaderAttributeSet;
    }

    public void setShaderAttribute(ShaderAttribute shaderAttribute) {
        this.shaderAttribute = shaderAttribute;
    }

    public ShaderAttribute getShaderAttribute() {
        return this.shaderAttribute;
    }

    public String toString() {
        String string;
        switch (this.errorCode) {
            case 0: {
                string = "NO_ERROR";
                break;
            }
            case 1: {
                string = "COMPILE_ERROR";
                break;
            }
            case 2: {
                string = "LINK_ERROR";
                break;
            }
            case 3: {
                string = "VERTEX_ATTRIBUTE_LOOKUP_ERROR";
                break;
            }
            case 4: {
                string = "SHADER_ATTRIBUTE_LOOKUP_ERROR";
                break;
            }
            case 5: {
                string = "SHADER_ATTRIBUTE_NAME_NOT_SET_ERROR";
                break;
            }
            case 6: {
                string = "SHADER_ATTRIBUTE_TYPE_ERROR";
                break;
            }
            case 7: {
                string = "UNSUPPORTED_LANGUAGE_ERROR";
                break;
            }
            default: {
                string = "UNKNOWN ERROR CODE (" + this.errorCode + ")";
            }
        }
        if (this.errorMessage == null) {
            return string;
        }
        return string + ": " + this.errorMessage;
    }
}

