/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.Alpha;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.Node;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransformInterpolator;

public abstract class PathInterpolator
extends TransformInterpolator {
    private float[] knots;
    protected float currentInterpolationValue;
    protected int currentKnotIndex;

    PathInterpolator() {
    }

    public PathInterpolator(Alpha alpha, float[] fArray) {
        this(alpha, null, fArray);
    }

    public PathInterpolator(Alpha alpha, TransformGroup transformGroup, float[] fArray) {
        super(alpha, transformGroup);
        this.setKnots(fArray);
    }

    public PathInterpolator(Alpha alpha, TransformGroup transformGroup, Transform3D transform3D, float[] fArray) {
        super(alpha, transformGroup, transform3D);
        this.setKnots(fArray);
    }

    public int getArrayLengths() {
        return this.knots.length;
    }

    public void setKnot(int n, float f) {
        this.knots[n] = f;
    }

    public float getKnot(int n) {
        return this.knots[n];
    }

    protected void setKnots(float[] fArray) {
        if ((double)fArray[0] < -1.0E-4 || (double)fArray[0] > 1.0E-4) {
            throw new IllegalArgumentException(J3dI18N.getString("PathInterpolator0"));
        }
        if ((double)(fArray[fArray.length - 1] - 1.0f) < -1.0E-4 || (double)(fArray[fArray.length - 1] - 1.0f) > 1.0E-4) {
            throw new IllegalArgumentException(J3dI18N.getString("PathInterpolator1"));
        }
        this.knots = new float[fArray.length];
        for (int i = 0; i < fArray.length; ++i) {
            if (i > 0 && fArray[i] < fArray[i - 1]) {
                throw new IllegalArgumentException(J3dI18N.getString("PathInterpolator2"));
            }
            this.knots[i] = fArray[i];
        }
    }

    public void getKnots(float[] fArray) {
        for (int i = 0; i < this.knots.length; ++i) {
            fArray[i] = this.knots[i];
        }
    }

    protected void computePathInterpolation(float f) {
        for (int i = 0; i < this.knots.length; ++i) {
            if (!(i == 0 && f <= this.knots[i]) && (i <= 0 || !(f >= this.knots[i - 1]) || !(f <= this.knots[i]))) continue;
            if (i == 0) {
                this.currentInterpolationValue = 0.0f;
                this.currentKnotIndex = 0;
                break;
            }
            this.currentInterpolationValue = (f - this.knots[i - 1]) / (this.knots[i] - this.knots[i - 1]);
            this.currentKnotIndex = i - 1;
            break;
        }
    }

    protected void computePathInterpolation() {
        float f = this.alpha.value();
        this.computePathInterpolation(f);
    }

    void duplicateAttributes(Node node, boolean bl) {
        super.duplicateAttributes(node, bl);
        PathInterpolator pathInterpolator = (PathInterpolator)node;
        int n = pathInterpolator.getArrayLengths();
        this.knots = new float[n];
        for (int i = 0; i < n; ++i) {
            this.setKnot(i, pathInterpolator.getKnot(i));
        }
    }
}

