/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import javax.media.j3d.BadTransformException;
import javax.media.j3d.BoundingBox;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.CachedTargets;
import javax.media.j3d.CompileState;
import javax.media.j3d.GroupRetained;
import javax.media.j3d.HashKey;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.LinkRetained;
import javax.media.j3d.MasterControl;
import javax.media.j3d.NodeRetained;
import javax.media.j3d.SceneGraphPath;
import javax.media.j3d.SetLiveState;
import javax.media.j3d.SharedGroupRetained;
import javax.media.j3d.SwitchState;
import javax.media.j3d.Targets;
import javax.media.j3d.TargetsInterface;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroupData;
import javax.media.j3d.UpdateTargets;
import javax.media.j3d.VirtualUniverse;
import javax.media.j3d.WakeupIndexedList;
import javax.media.j3d.WakeupOnTransformChange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TransformGroupRetained
extends GroupRetained
implements TargetsInterface {
    Transform3D transform = new Transform3D();
    Transform3D invTransform = null;
    Transform3D normalTransform = null;
    Transform3D currentTransform = new Transform3D();
    Transform3D[][] childLocalToVworld = null;
    int[][] childLocalToVworldIndex = null;
    Transform3D[][] childTrans = null;
    int[][] childTransIndex = null;
    int localTargetThreads = 0;
    int targetThreads = 0;
    WakeupIndexedList transformChange = null;
    ArrayList<NodeRetained> childTransformLinks = new ArrayList(1);
    boolean needNormalsTransform = false;
    HashKey currentKey = new HashKey();
    boolean aboveAViewPlatform = false;
    int maxTransformLevel = -1;
    int[] transformLevels = null;
    CachedTargets[] j3dCTs = null;
    CachedTargets[] cachedTargets = null;
    TransformGroupData[] perPathData = null;

    TransformGroupRetained() {
        this.nodeType = 24;
    }

    void setTransform(Transform3D transform3D) {
        J3dMessage j3dMessage = null;
        Transform3D transform3D2 = null;
        if (this.staticTransform != null) {
            transform3D2 = new Transform3D(this.staticTransform.transform);
            transform3D2.mul(transform3D);
            this.transform.setWithLock(transform3D2);
        } else {
            transform3D2 = new Transform3D(transform3D);
            this.transform.setWithLock(transform3D);
        }
        if (this.transformChange != null) {
            this.notifyConditions();
        }
        if (this.source.isLive()) {
            if (this.aboveAViewPlatform && !transform3D.isCongruent()) {
                throw new BadTransformException(J3dI18N.getString("ViewPlatformRetained0"));
            }
            j3dMessage = new J3dMessage();
            j3dMessage.type = 3;
            j3dMessage.threads = this.targetThreads;
            j3dMessage.args[1] = this;
            j3dMessage.args[2] = transform3D2;
            j3dMessage.universe = this.universe;
            VirtualUniverse.mc.processMessage(j3dMessage);
        }
        this.dirtyBoundsCache();
    }

    void getTransform(Transform3D transform3D) {
        this.transform.getWithLock(transform3D);
        if (this.staticTransform != null) {
            Transform3D transform3D2 = this.staticTransform.getInvTransform();
            transform3D.mul(transform3D2, transform3D);
        }
    }

    Transform3D getInvTransform() {
        if (this.invTransform == null) {
            this.invTransform = new Transform3D(this.transform);
            this.invTransform.invert();
        }
        return this.invTransform;
    }

    Transform3D getNormalTransform() {
        if (this.normalTransform == null) {
            this.normalTransform = new Transform3D(this.transform);
            this.normalTransform.invert();
            this.normalTransform.transpose();
        }
        return this.normalTransform;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    synchronized void setNodeData(SetLiveState setLiveState) {
        int n;
        super.setNodeData(setLiveState);
        this.childTrans = new Transform3D[setLiveState.currentTransforms.length][2];
        this.childTransIndex = new int[setLiveState.currentTransforms.length][2];
        for (n = 0; n < setLiveState.currentTransforms.length; ++n) {
            this.childTrans[n][0] = new Transform3D();
            this.childTrans[n][0].mul(setLiveState.currentTransforms[n][setLiveState.currentTransformsIndex[n][1]], this.currentTransform);
            this.childTrans[n][1] = new Transform3D(this.childTrans[n][0]);
            this.childTransIndex[n][0] = 0;
            this.childTransIndex[n][1] = 0;
        }
        if (!setLiveState.inSharedGroup) {
            setLiveState.transformLevels[0] = setLiveState.transformLevels[0] + 1;
            this.maxTransformLevel = setLiveState.transformLevels[0];
        } else {
            for (n = 0; n < setLiveState.keys.length; ++n) {
                int n2 = n;
                setLiveState.transformLevels[n2] = setLiveState.transformLevels[n2] + 1;
                if (setLiveState.transformLevels[n] <= this.maxTransformLevel) continue;
                this.maxTransformLevel = setLiveState.transformLevels[n];
            }
        }
        if (!this.inSharedGroup) {
            if (this.childLocalToVworld == null) {
                this.childLocalToVworld = new Transform3D[1][];
                this.childLocalToVworldIndex = new int[1][];
                this.transformLevels = new int[1];
                this.cachedTargets = new CachedTargets[1];
                this.perPathData = new TransformGroupData[1];
            }
            this.childLocalToVworld[0] = this.childTrans[0];
            this.childLocalToVworldIndex[0] = this.childTransIndex[0];
            this.transformLevels[0] = setLiveState.transformLevels[0];
            this.setAuxData(setLiveState, 0, 0);
        } else {
            int n3;
            int n4;
            if (this.childLocalToVworld == null) {
                this.childLocalToVworld = new Transform3D[setLiveState.keys.length][];
                this.childLocalToVworldIndex = new int[setLiveState.keys.length][];
                this.transformLevels = new int[setLiveState.keys.length];
                this.cachedTargets = new CachedTargets[setLiveState.keys.length];
                this.perPathData = new TransformGroupData[setLiveState.keys.length];
                n4 = 0;
            } else {
                n4 = this.localToVworld.length - setLiveState.keys.length;
                n3 = this.localToVworld.length;
                Transform3D[][] transform3DArrayArray = new Transform3D[n3][];
                int[][] nArrayArray = new int[n3][];
                int[] nArray = new int[n3];
                CachedTargets[] cachedTargetsArray = new CachedTargets[n3];
                TransformGroupData[] transformGroupDataArray = new TransformGroupData[n3];
                System.arraycopy(this.childLocalToVworld, 0, transform3DArrayArray, 0, this.childLocalToVworld.length);
                System.arraycopy(this.childLocalToVworldIndex, 0, nArrayArray, 0, this.childLocalToVworldIndex.length);
                System.arraycopy(this.transformLevels, 0, nArray, 0, this.transformLevels.length);
                System.arraycopy(this.cachedTargets, 0, cachedTargetsArray, 0, this.cachedTargets.length);
                System.arraycopy(this.perPathData, 0, transformGroupDataArray, 0, this.perPathData.length);
                this.childLocalToVworld = transform3DArrayArray;
                this.childLocalToVworldIndex = nArrayArray;
                this.transformLevels = nArray;
                this.cachedTargets = cachedTargetsArray;
                this.perPathData = transformGroupDataArray;
            }
            n = n4;
            int n5 = 0;
            while (n < this.localToVworld.length) {
                n3 = setLiveState.keys[n5].equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
                if (n3 < 0) {
                    MasterControl.getCoreLogger().severe("Can't Find matching hashKey in setNodeData.");
                    break;
                }
                if (n3 >= n) {
                    this.childLocalToVworld[n] = this.childTrans[n5];
                    this.childLocalToVworldIndex[n] = this.childTransIndex[n5];
                    this.transformLevels[n] = setLiveState.transformLevels[n5];
                } else {
                    int n6 = n3 + 1;
                    int n7 = n - n3;
                    System.arraycopy(this.childLocalToVworld, n3, this.childLocalToVworld, n6, n7);
                    System.arraycopy(this.childLocalToVworldIndex, n3, this.childLocalToVworldIndex, n6, n7);
                    System.arraycopy(this.transformLevels, n3, this.transformLevels, n6, n7);
                    System.arraycopy(this.cachedTargets, n3, this.cachedTargets, n6, n7);
                    System.arraycopy(this.perPathData, n3, this.perPathData, n6, n7);
                    this.childLocalToVworld[n3] = this.childTrans[n5];
                    this.childLocalToVworldIndex[n3] = this.childTransIndex[n5];
                    this.transformLevels[n3] = setLiveState.transformLevels[n5];
                }
                this.setAuxData(setLiveState, n5, n3);
                ++n;
                ++n5;
            }
        }
        if (setLiveState.childTransformLinks != null) {
            ArrayList<NodeRetained> arrayList = setLiveState.childTransformLinks;
            synchronized (arrayList) {
                if (!this.inSharedGroup || !setLiveState.childTransformLinks.contains(this)) {
                    setLiveState.childTransformLinks.add(this);
                }
            }
        }
        setLiveState.localToVworld = this.childLocalToVworld;
        setLiveState.localToVworldIndex = this.childLocalToVworldIndex;
        setLiveState.currentTransforms = this.childTrans;
        setLiveState.currentTransformsIndex = this.childTransIndex;
        setLiveState.childTransformLinks = this.childTransformLinks;
        setLiveState.parentTransformLink = this;
    }

    @Override
    void setAuxData(SetLiveState setLiveState, int n, int n2) {
        super.setAuxData(setLiveState, n, n2);
        this.perPathData[n2] = new TransformGroupData();
        this.perPathData[n2].switchState = setLiveState.switchStates.get(n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeCondition(WakeupOnTransformChange wakeupOnTransformChange) {
        WakeupIndexedList wakeupIndexedList = this.transformChange;
        synchronized (wakeupIndexedList) {
            this.transformChange.remove(wakeupOnTransformChange);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addCondition(WakeupOnTransformChange wakeupOnTransformChange) {
        WakeupIndexedList wakeupIndexedList = this.transformChange;
        synchronized (wakeupIndexedList) {
            this.transformChange.add(wakeupOnTransformChange);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyConditions() {
        WakeupIndexedList wakeupIndexedList = this.transformChange;
        synchronized (wakeupIndexedList) {
            WakeupOnTransformChange[] wakeupOnTransformChangeArray = (WakeupOnTransformChange[])this.transformChange.toArray(false);
            for (int i = this.transformChange.size() - 1; i >= 0; --i) {
                wakeupOnTransformChangeArray[i].setTriggered();
            }
        }
    }

    @Override
    boolean isStatic() {
        return super.isStatic() && !this.source.getCapability(17) && !this.source.getCapability(18);
    }

    @Override
    void mergeTransform(TransformGroupRetained transformGroupRetained) {
        super.mergeTransform(transformGroupRetained);
        this.transform.mul(transformGroupRetained.transform, this.transform);
    }

    @Override
    void traverse(boolean bl, int n) {
        System.err.println();
        for (int i = 0; i < n; ++i) {
            System.err.print(".");
        }
        System.err.print(this);
        if (this.isStatic()) {
            System.err.print(" (s)");
        } else {
            System.err.print(" (w)");
        }
        System.err.println();
        System.err.println(this.transform.toString());
        super.traverse(true, n);
    }

    @Override
    void compile(CompileState compileState) {
        boolean bl = compileState.keepTG;
        compileState.keepTG = false;
        boolean bl2 = compileState.needNormalsTransform;
        compileState.needNormalsTransform = false;
        super.compile(compileState);
        if (compileState.keepTG) {
            this.mergeFlag = 0;
        }
        if (this.mergeFlag == 0) {
            compileState.staticTransform = null;
            compileState.parentGroup = null;
            super.merge(compileState);
        } else {
            this.mergeFlag = 1;
        }
        compileState.keepTG = bl;
        this.needNormalsTransform = compileState.needNormalsTransform;
        compileState.needNormalsTransform = bl2;
    }

    @Override
    void merge(CompileState compileState) {
        Transform3D transform3D;
        if (compileState.staticTransform != null) {
            this.staticTransform = compileState.staticTransform;
            this.mergeTransform(compileState.staticTransform);
        }
        if (this.mergeFlag == 1 && this.needNormalsTransform && !(transform3D = this.getNormalTransform()).isCongruent()) {
            this.mergeFlag = 0;
        }
        if (this.mergeFlag == 1) {
            TransformGroupRetained transformGroupRetained = compileState.staticTransform;
            compileState.staticTransform = this;
            super.merge(compileState);
            compileState.staticTransform = transformGroupRetained;
        } else {
            compileState.parentGroup.compiledChildrenList.add(this);
            this.parent = compileState.parentGroup;
        }
        this.mergeFlag = 2;
    }

    @Override
    void setLive(SetLiveState setLiveState) {
        int n;
        Transform3D transform3D = null;
        Targets[] targetsArray = null;
        Targets[] targetsArray2 = null;
        int n2 = 0;
        n2 = setLiveState.traverseFlags;
        targetsArray2 = setLiveState.transformTargets;
        int n3 = setLiveState.inSharedGroup ? setLiveState.keys.length : 1;
        targetsArray = new Targets[n3];
        for (n = 0; n < n3; ++n) {
            targetsArray[n] = new Targets();
        }
        setLiveState.transformTargets = targetsArray;
        setLiveState.traverseFlags = 0;
        this.inSharedGroup = setLiveState.inSharedGroup;
        transform3D = new Transform3D();
        this.transform.getWithLock(transform3D);
        this.currentTransform.set(transform3D);
        ArrayList<NodeRetained> arrayList = setLiveState.childTransformLinks;
        GroupRetained groupRetained = setLiveState.parentTransformLink;
        Transform3D[][] transform3DArray = setLiveState.currentTransforms;
        int[][] nArray = setLiveState.currentTransformsIndex;
        super.doSetLive(setLiveState);
        if (!this.inSharedGroup) {
            if (setLiveState.transformTargets[0] != null) {
                this.cachedTargets[0] = setLiveState.transformTargets[0].snapShotInit();
            }
            if (setLiveState.switchTargets != null && setLiveState.switchTargets[0] != null) {
                setLiveState.switchTargets[0].addNode(this, 6);
            }
        } else {
            for (n = 0; n < n3; ++n) {
                if (setLiveState.transformTargets[n] != null) {
                    int n4 = setLiveState.keys[n].equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
                    this.cachedTargets[n4] = setLiveState.transformTargets[n].snapShotInit();
                }
                if (setLiveState.switchTargets == null || setLiveState.switchTargets[n] == null) continue;
                setLiveState.switchTargets[n].addNode(this, 6);
            }
        }
        this.j3dCTs = new CachedTargets[this.cachedTargets.length];
        this.copyCachedTargets(0, this.j3dCTs);
        this.computeTargetThreads(0, this.cachedTargets);
        setLiveState.localToVworld = this.localToVworld;
        setLiveState.localToVworldIndex = this.localToVworldIndex;
        setLiveState.currentTransforms = transform3DArray;
        setLiveState.currentTransformsIndex = nArray;
        setLiveState.childTransformLinks = arrayList;
        setLiveState.parentTransformLink = groupRetained;
        setLiveState.transformTargets = targetsArray2;
        if (!setLiveState.inSharedGroup) {
            setLiveState.transformLevels[0] = setLiveState.transformLevels[0] - 1;
        } else {
            n = 0;
            while (n < setLiveState.keys.length) {
                int n5 = n++;
                setLiveState.transformLevels[n5] = setLiveState.transformLevels[n5] - 1;
            }
        }
        if ((setLiveState.traverseFlags & 1) != 0) {
            this.aboveAViewPlatform = true;
        }
        setLiveState.traverseFlags |= n2;
        if (this.aboveAViewPlatform && !transform3D.isCongruent()) {
            throw new BadTransformException(J3dI18N.getString("ViewPlatformRetained0"));
        }
        super.markAsLive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void removeNodeData(SetLiveState setLiveState) {
        TransformGroupRetained transformGroupRetained = this;
        synchronized (transformGroupRetained) {
            if (this.refCount <= 0) {
                this.childLocalToVworld = null;
                this.childLocalToVworldIndex = null;
                this.transformLevels = null;
                this.cachedTargets = null;
                this.perPathData = null;
                this.targetThreads = 0;
                if (this.parentTransformLink != null) {
                    ArrayList<NodeRetained> arrayList = this.parentTransformLink instanceof TransformGroupRetained ? ((TransformGroupRetained)this.parentTransformLink).childTransformLinks : ((SharedGroupRetained)this.parentTransformLink).childTransformLinks;
                    ArrayList<NodeRetained> arrayList2 = arrayList;
                    synchronized (arrayList2) {
                        arrayList.remove(this);
                    }
                }
                this.aboveAViewPlatform = false;
            } else {
                int n;
                int n2 = this.localToVworld.length - setLiveState.keys.length;
                Transform3D[][] transform3DArrayArray = new Transform3D[n2][];
                int[][] nArrayArray = new int[n2][];
                int[] nArray = new int[n2];
                ArrayList[] arrayListArray = new ArrayList[n2];
                CachedTargets[] cachedTargetsArray = new CachedTargets[n2];
                TransformGroupData[] transformGroupDataArray = new TransformGroupData[n2];
                int[] nArray2 = new int[setLiveState.keys.length];
                int n3 = 0;
                int n4 = 0;
                boolean bl = false;
                for (int i = 0; i < setLiveState.keys.length; ++i) {
                    int n5;
                    nArray2[i] = n5 = setLiveState.keys[i].equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
                    if (n5 >= 0) {
                        bl = true;
                        if (n5 == n3) {
                            ++n3;
                            continue;
                        }
                        n = n5 - n3;
                        System.arraycopy(this.childLocalToVworld, n3, transform3DArrayArray, n4, n);
                        System.arraycopy(this.childLocalToVworldIndex, n3, nArrayArray, n4, n);
                        System.arraycopy(this.transformLevels, n3, nArray, n4, n);
                        System.arraycopy(this.cachedTargets, n3, cachedTargetsArray, n4, n);
                        System.arraycopy(this.perPathData, n3, transformGroupDataArray, n4, n);
                        n3 = n5 + 1;
                        n4 += n;
                        continue;
                    }
                    bl = false;
                    MasterControl.getCoreLogger().severe("TG.removeNodeData-Can't find matching hashKey.");
                }
                if (bl && n3 < this.localToVworld.length) {
                    n = this.localToVworld.length - n3;
                    System.arraycopy(this.childLocalToVworld, n3, transform3DArrayArray, n4, n);
                    System.arraycopy(this.childLocalToVworldIndex, n3, nArrayArray, n4, n);
                    System.arraycopy(this.transformLevels, n3, nArray, n4, n);
                    System.arraycopy(this.cachedTargets, n3, cachedTargetsArray, n4, n);
                    System.arraycopy(this.perPathData, n3, transformGroupDataArray, n4, n);
                }
                this.childLocalToVworld = transform3DArrayArray;
                this.childLocalToVworldIndex = nArrayArray;
                this.transformLevels = nArray;
                this.cachedTargets = cachedTargetsArray;
                this.perPathData = transformGroupDataArray;
            }
            super.removeNodeData(setLiveState);
            setLiveState.localToVworld = this.childLocalToVworld;
            setLiveState.localToVworldIndex = this.childLocalToVworldIndex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void clearLive(SetLiveState setLiveState) {
        Targets[] targetsArray = null;
        targetsArray = setLiveState.transformTargets;
        setLiveState.transformTargets = null;
        super.clearLive(setLiveState);
        setLiveState.localToVworld = this.localToVworld;
        setLiveState.localToVworldIndex = this.localToVworldIndex;
        setLiveState.transformTargets = targetsArray;
        TransformGroupRetained transformGroupRetained = this;
        synchronized (transformGroupRetained) {
            if (this.inSharedGroup) {
                int n;
                if (this.transformLevels != null) {
                    this.maxTransformLevel = this.transformLevels[0];
                    for (n = 1; n < this.transformLevels.length; ++n) {
                        if (this.transformLevels[n] <= this.maxTransformLevel) continue;
                        this.maxTransformLevel = this.transformLevels[n];
                    }
                } else {
                    this.maxTransformLevel = -1;
                }
                if (setLiveState.switchTargets != null) {
                    for (n = 0; n < setLiveState.switchTargets.length; ++n) {
                        if (setLiveState.switchTargets[n] == null) continue;
                        setLiveState.switchTargets[n].addNode(this, 6);
                    }
                }
            } else {
                this.maxTransformLevel = -1;
                if (setLiveState.switchTargets != null && setLiveState.switchTargets[0] != null) {
                    setLiveState.switchTargets[0].addNode(this, 6);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void computeCombineBounds(Bounds bounds) {
        if (this.validCachedBounds && this.boundsAutoCompute) {
            Bounds bounds2 = (Bounds)this.cachedBounds.clone();
            Transform3D transform3D = this.transform;
            synchronized (transform3D) {
                bounds2.transform(this.transform);
            }
            bounds.combine(bounds2);
            return;
        }
        Bounds bounds3 = null;
        bounds3 = VirtualUniverse.mc.useBoxForGroupBounds ? new BoundingBox((Bounds)null) : new BoundingSphere((Bounds)null);
        if (this.boundsAutoCompute) {
            for (int i = this.children.size() - 1; i >= 0; --i) {
                NodeRetained nodeRetained = (NodeRetained)this.children.get(i);
                if (nodeRetained == null) continue;
                nodeRetained.computeCombineBounds(bounds3);
            }
            if (VirtualUniverse.mc.cacheAutoComputedBounds) {
                this.cachedBounds = (Bounds)bounds3.clone();
            }
        } else {
            Bounds bounds4 = this.localBounds;
            synchronized (bounds4) {
                bounds3.set(this.localBounds);
            }
        }
        Transform3D transform3D = this.transform;
        synchronized (transform3D) {
            bounds3.transform(this.transform);
        }
        bounds.combine(bounds3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processChildLocalToVworld(ArrayList<TransformGroupRetained> arrayList, ArrayList arrayList2, UpdateTargets updateTargets, ArrayList arrayList3) {
        TransformGroupRetained transformGroupRetained = this;
        synchronized (transformGroupRetained) {
            if (this.inSharedGroup) {
                if (this.localToVworldKeys != null) {
                    for (int i = 0; i < this.localToVworldKeys.length; ++i) {
                        if (!this.perPathData[i].markedDirty) continue;
                        this.updateChildLocalToVworld(this.localToVworldKeys[i], i, arrayList, arrayList2, updateTargets, arrayList3);
                    }
                }
            } else if (this.perPathData != null && this.perPathData[0].markedDirty) {
                this.updateChildLocalToVworld(arrayList, arrayList2, updateTargets, arrayList3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateChildLocalToVworld(HashKey hashKey, int n, ArrayList<TransformGroupRetained> arrayList, ArrayList arrayList2, UpdateTargets updateTargets, ArrayList arrayList3) {
        TransformGroupRetained transformGroupRetained = this;
        synchronized (transformGroupRetained) {
            if (this.localToVworld != null) {
                this.perPathData[n].markedDirty = false;
                if (this.perPathData[n].switchState.currentSwitchOn) {
                    Transform3D transform3D = this.getCurrentLocalToVworld(n);
                    Transform3D transform3D2 = this.getUpdateChildLocalToVworld(n);
                    transform3D2.mul(transform3D, this.currentTransform);
                    arrayList.add(this);
                    arrayList2.add(hashKey);
                    CachedTargets cachedTargets = this.j3dCTs[n];
                    if (cachedTargets != null) {
                        updateTargets.addCachedTargets(cachedTargets);
                        if (cachedTargets.targetArr[5] != null) {
                            TransformGroupRetained.gatherBlUsers(arrayList3, cachedTargets.targetArr[5]);
                        }
                    }
                } else {
                    this.perPathData[n].switchDirty = true;
                }
                ArrayList<NodeRetained> arrayList4 = this.childTransformLinks;
                synchronized (arrayList4) {
                    for (int i = 0; i < this.childTransformLinks.size(); ++i) {
                        NodeRetained nodeRetained = this.childTransformLinks.get(i);
                        if (nodeRetained instanceof TransformGroupRetained) {
                            TransformGroupRetained transformGroupRetained2 = (TransformGroupRetained)nodeRetained;
                            transformGroupRetained2.updateChildLocalToVworld(transformGroupRetained2.localToVworldKeys[n], n, arrayList, arrayList2, updateTargets, arrayList3);
                            continue;
                        }
                        LinkRetained linkRetained = (LinkRetained)nodeRetained;
                        this.currentKey.set(this.localToVworldKeys[n]);
                        this.currentKey.append(LinkRetained.plus).append(linkRetained.nodeId);
                        if (linkRetained.sharedGroup == null || linkRetained.sharedGroup.localToVworldKeys == null) continue;
                        int n2 = this.currentKey.equals(linkRetained.sharedGroup.localToVworldKeys, 0, linkRetained.sharedGroup.localToVworldKeys.length);
                        if (n2 < 0) {
                            System.err.println("TransformGroupRetained : Can't find hashKey");
                        }
                        if (n2 >= linkRetained.sharedGroup.localToVworldKeys.length) continue;
                        linkRetained.sharedGroup.updateChildLocalToVworld(linkRetained.sharedGroup.localToVworldKeys[n2], n2, arrayList, arrayList2, updateTargets, arrayList3);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateChildLocalToVworld(ArrayList<TransformGroupRetained> arrayList, ArrayList arrayList2, UpdateTargets updateTargets, ArrayList arrayList3) {
        TransformGroupRetained transformGroupRetained = this;
        synchronized (transformGroupRetained) {
            if (this.localToVworld != null) {
                this.perPathData[0].markedDirty = false;
                if (this.perPathData[0].switchState.currentSwitchOn) {
                    Transform3D transform3D = this.getCurrentLocalToVworld(0);
                    Transform3D transform3D2 = this.getUpdateChildLocalToVworld(0);
                    transform3D2.mul(transform3D, this.currentTransform);
                    arrayList.add(this);
                    CachedTargets cachedTargets = this.j3dCTs[0];
                    if (cachedTargets != null) {
                        updateTargets.addCachedTargets(cachedTargets);
                        if (cachedTargets.targetArr[5] != null) {
                            TransformGroupRetained.gatherBlUsers(arrayList3, cachedTargets.targetArr[5]);
                        }
                    }
                } else {
                    this.perPathData[0].switchDirty = true;
                }
                ArrayList<NodeRetained> arrayList4 = this.childTransformLinks;
                synchronized (arrayList4) {
                    for (int i = 0; i < this.childTransformLinks.size(); ++i) {
                        NodeRetained nodeRetained = this.childTransformLinks.get(i);
                        if (nodeRetained instanceof TransformGroupRetained) {
                            TransformGroupRetained transformGroupRetained2 = (TransformGroupRetained)nodeRetained;
                            transformGroupRetained2.updateChildLocalToVworld(arrayList, arrayList2, updateTargets, arrayList3);
                            continue;
                        }
                        LinkRetained linkRetained = (LinkRetained)nodeRetained;
                        this.currentKey.reset();
                        this.currentKey.append(this.locale.nodeId);
                        this.currentKey.append(LinkRetained.plus).append(linkRetained.nodeId);
                        if (linkRetained.sharedGroup == null || linkRetained.sharedGroup.localToVworldKeys == null) continue;
                        int n = this.currentKey.equals(linkRetained.sharedGroup.localToVworldKeys, 0, linkRetained.sharedGroup.localToVworldKeys.length);
                        if (n < 0) {
                            System.err.println("TransformGroupRetained : Can't find hashKey");
                        }
                        if (n >= linkRetained.sharedGroup.localToVworldKeys.length) continue;
                        linkRetained.sharedGroup.updateChildLocalToVworld(linkRetained.sharedGroup.localToVworldKeys[n], n, arrayList, arrayList2, updateTargets, arrayList3);
                    }
                }
            }
        }
    }

    @Override
    void transformBounds(SceneGraphPath sceneGraphPath, Bounds bounds) {
        if (!((NodeRetained)sceneGraphPath.item.retained).inSharedGroup) {
            bounds.transform(this.getCurrentChildLocalToVworld());
        } else {
            HashKey hashKey = new HashKey("");
            sceneGraphPath.getHashKey(hashKey);
            bounds.transform(this.getCurrentChildLocalToVworld(hashKey));
        }
    }

    Transform3D getUpdateChildLocalToVworld(int n) {
        int n2 = this.childLocalToVworldIndex[n][1];
        if (n2 == this.childLocalToVworldIndex[n][0]) {
            this.childLocalToVworldIndex[n][1] = n2 ^= 1;
        }
        return this.childLocalToVworld[n][n2];
    }

    Transform3D getCurrentChildLocalToVworld() {
        return this.getCurrentChildLocalToVworld(0);
    }

    Transform3D getCurrentChildLocalToVworld(int n) {
        return this.childLocalToVworld[n][this.childLocalToVworldIndex[n][1]];
    }

    Transform3D getCurrentChildLocalToVworld(HashKey hashKey) {
        if (!this.inSharedGroup) {
            return this.childLocalToVworld[0][this.childLocalToVworldIndex[0][1]];
        }
        int n = hashKey.equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
        if (n >= 0) {
            return this.childLocalToVworld[n][this.childLocalToVworldIndex[n][1]];
        }
        return new Transform3D();
    }

    Transform3D getLastChildLocalToVworld(HashKey hashKey) {
        if (!this.inSharedGroup) {
            return this.childLocalToVworld[0][this.childLocalToVworldIndex[0][0]];
        }
        int n = hashKey.equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
        if (n >= 0) {
            return this.childLocalToVworld[n][this.childLocalToVworldIndex[n][0]];
        }
        return new Transform3D();
    }

    @Override
    public int getTargetThreads(int n) {
        if (n == 0) {
            return this.targetThreads;
        }
        System.err.println("getTargetsThreads: wrong arguments");
        return -1;
    }

    @Override
    public CachedTargets getCachedTargets(int n, int n2, int n3) {
        if (n == 0) {
            return this.cachedTargets[n2];
        }
        System.err.println("getCachedTargets: wrong arguments");
        return null;
    }

    @Override
    TargetsInterface getClosestTargetsInterface(int n) {
        return n == 0 ? this : (TargetsInterface)((Object)this.parentSwitchLink);
    }

    @Override
    public void computeTargetThreads(int n, CachedTargets[] cachedTargetsArray) {
        if (n == 0) {
            int n2;
            this.localTargetThreads = 8192;
            for (n2 = 0; n2 < cachedTargetsArray.length; ++n2) {
                if (cachedTargetsArray[n2] == null) continue;
                this.localTargetThreads |= cachedTargetsArray[n2].computeTargetThreads();
            }
            this.targetThreads = this.localTargetThreads;
            n2 = this.childTransformLinks.size();
            for (int i = 0; i < n2; ++i) {
                NodeRetained nodeRetained = this.childTransformLinks.get(i);
                TargetsInterface targetsInterface = nodeRetained.nodeType == 9 ? ((LinkRetained)nodeRetained).sharedGroup : (TargetsInterface)((Object)nodeRetained);
                if (targetsInterface == null) continue;
                this.targetThreads |= targetsInterface.getTargetThreads(0);
            }
        } else {
            System.err.println("computeTargetsThreads: wrong arguments");
        }
    }

    @Override
    public void updateTargetThreads(int n, CachedTargets[] cachedTargetsArray) {
        if (n == 0) {
            this.computeTargetThreads(n, cachedTargetsArray);
            if (this.parentTransformLink != null) {
                TargetsInterface targetsInterface = (TargetsInterface)((Object)this.parentTransformLink);
                targetsInterface.propagateTargetThreads(0, this.targetThreads);
            }
        } else {
            System.err.println("updateTargetThreads: wrong arguments");
        }
    }

    @Override
    public void propagateTargetThreads(int n, int n2) {
        if (n == 0) {
            this.targetThreads |= n2;
            if (this.parentTransformLink != null) {
                TargetsInterface targetsInterface = (TargetsInterface)((Object)this.parentTransformLink);
                targetsInterface.propagateTargetThreads(0, this.targetThreads);
            }
        } else {
            System.err.println("propagateTargetThreads: wrong arguments");
        }
    }

    @Override
    public void updateCachedTargets(int n, CachedTargets[] cachedTargetsArray) {
        if (n == 0) {
            this.j3dCTs = cachedTargetsArray;
        } else {
            System.err.println("updateCachedTargets: wrong arguments");
        }
    }

    @Override
    public void copyCachedTargets(int n, CachedTargets[] cachedTargetsArray) {
        if (n == 0) {
            for (CachedTargets cachedTargetsArray[var4_4] : this.cachedTargets) {
            }
        } else {
            System.err.println("copyCachedTargets: wrong arguments");
        }
    }

    @Override
    public void resetCachedTargets(int n, CachedTargets[] cachedTargetsArray, int n2) {
        if (n == 0) {
            this.cachedTargets = cachedTargetsArray;
        } else {
            System.err.println("resetCachedTargets: wrong arguments");
        }
    }

    @Override
    public ArrayList<SwitchState> getTargetsData(int n, int n2) {
        return null;
    }

    @Override
    void childCheckSetLive(NodeRetained nodeRetained, int n, SetLiveState setLiveState, NodeRetained nodeRetained2) {
        setLiveState.currentTransforms = this.childLocalToVworld;
        setLiveState.currentTransformsIndex = this.childLocalToVworldIndex;
        setLiveState.parentTransformLink = this;
        setLiveState.childTransformLinks = this.childTransformLinks;
        setLiveState.localToVworld = setLiveState.currentTransforms;
        setLiveState.localToVworldIndex = setLiveState.currentTransformsIndex;
        nodeRetained.setLive(setLiveState);
    }
}

