/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.loaders.lw3d;

import com.sun.j3d.internal.J3dUtilsI18N;
import javax.media.j3d.Alpha;
import javax.media.j3d.Interpolator;

abstract class FloatValueInterpolator
extends Interpolator {
    private float[] knots;
    private int knotsLength;
    protected int currentKnotIndex;
    protected float currentInterpolationRatio;
    protected float[] values;
    protected float currentValue;

    FloatValueInterpolator(Alpha alpha, float[] fArray, float[] fArray2) {
        super(alpha);
        int n;
        this.knotsLength = fArray.length;
        if ((double)fArray[0] < -1.0E-4 || (double)fArray[0] > 1.0E-4) {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("FloatValueInterpolator0"));
        }
        if ((double)(fArray[this.knotsLength - 1] - 1.0f) < -1.0E-4 || (double)(fArray[this.knotsLength - 1] - 1.0f) > 1.0E-4) {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("FloatValueInterpolator1"));
        }
        this.knots = new float[this.knotsLength];
        for (n = 0; n < this.knotsLength; ++n) {
            if (n > 0 && fArray[n] < fArray[n - 1]) {
                throw new IllegalArgumentException(J3dUtilsI18N.getString("FloatValueInterpolator2"));
            }
            this.knots[n] = fArray[n];
        }
        if (this.knotsLength != fArray2.length) {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("FloatValueInterpolator3"));
        }
        this.values = new float[this.knotsLength];
        for (n = 0; n < this.knotsLength; ++n) {
            this.values[n] = fArray2[n];
        }
    }

    void setValue(int n, float f) {
        this.values[n] = f;
    }

    float getValue(int n) {
        return this.values[n];
    }

    protected void computePathInterpolation() {
        float f = this.getAlpha().value();
        for (int i = 0; i < this.knotsLength; ++i) {
            if (!(i == 0 && f <= this.knots[i]) && (i <= 0 || !(f >= this.knots[i - 1]) || !(f <= this.knots[i]))) continue;
            if (i == 0) {
                this.currentInterpolationRatio = 0.0f;
                this.currentKnotIndex = 0;
                this.currentValue = this.values[0];
                break;
            }
            this.currentInterpolationRatio = (f - this.knots[i - 1]) / (this.knots[i] - this.knots[i - 1]);
            this.currentKnotIndex = i - 1;
            this.currentValue = this.values[i - 1] + this.currentInterpolationRatio * (this.values[i] - this.values[i - 1]);
            break;
        }
    }
}

