/*
 * Decompiled with CFR 0.152.
 */
package org.sunflow.core;

import java.util.Iterator;
import org.sunflow.core.Camera;
import org.sunflow.core.Instance;
import org.sunflow.core.IntersectionState;
import org.sunflow.core.LightSample;
import org.sunflow.core.LightServer;
import org.sunflow.core.Modifier;
import org.sunflow.core.PhotonStore;
import org.sunflow.core.PrimitiveList;
import org.sunflow.core.Ray;
import org.sunflow.core.Shader;
import org.sunflow.core.primitive.TriangleMesh;
import org.sunflow.image.Color;
import org.sunflow.math.Matrix4;
import org.sunflow.math.OrthoNormalBasis;
import org.sunflow.math.Point2;
import org.sunflow.math.Point3;
import org.sunflow.math.QMC;
import org.sunflow.math.Vector3;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ShadingState
implements Iterable<LightSample> {
    private IntersectionState istate;
    private LightServer server;
    private float rx;
    private float ry;
    private float time;
    private Color result;
    private Point3 p;
    private Vector3 n;
    private Point2 tex;
    private Vector3 ng;
    private OrthoNormalBasis basis;
    private float cosND;
    private float bias;
    private boolean behind;
    private float hitU;
    private float hitV;
    private float hitW;
    private Instance instance;
    private int primitiveID;
    private Matrix4 o2w;
    private Matrix4 w2o;
    private Ray r;
    private int d;
    private int i;
    private double qmcD0I;
    private double qmcD1I;
    private Shader shader;
    private Modifier modifier;
    private int diffuseDepth;
    private int reflectionDepth;
    private int refractionDepth;
    private boolean includeLights;
    private boolean includeSpecular;
    private LightSample lightSample;
    private PhotonStore map;
    private int shadowDepth;

    static ShadingState createPhotonState(Ray ray, IntersectionState intersectionState, int n, PhotonStore photonStore, LightServer lightServer) {
        ShadingState shadingState = new ShadingState(null, intersectionState, ray, n, 4, false);
        shadingState.server = lightServer;
        shadingState.map = photonStore;
        return shadingState;
    }

    static ShadingState createState(IntersectionState intersectionState, float f, float f2, float f3, Ray ray, int n, int n2, LightServer lightServer) {
        ShadingState shadingState = new ShadingState(null, intersectionState, ray, n, n2, false);
        shadingState.server = lightServer;
        shadingState.rx = f;
        shadingState.ry = f2;
        shadingState.time = f3;
        return shadingState;
    }

    static ShadingState createDiffuseBounceState(ShadingState shadingState, Ray ray, int n) {
        ShadingState shadingState2 = new ShadingState(shadingState, shadingState.istate, ray, n, 2, false);
        ++shadingState2.diffuseDepth;
        return shadingState2;
    }

    static ShadingState createGlossyBounceState(ShadingState shadingState, Ray ray, int n) {
        ShadingState shadingState2 = new ShadingState(shadingState, shadingState.istate, ray, n, 2, false);
        shadingState2.includeLights = false;
        shadingState2.includeSpecular = true;
        shadingState2.reflectionDepth += 4;
        return shadingState2;
    }

    static ShadingState createReflectionBounceState(ShadingState shadingState, Ray ray, int n) {
        ShadingState shadingState2 = new ShadingState(shadingState, shadingState.istate, ray, n, 2, false);
        ++shadingState2.reflectionDepth;
        return shadingState2;
    }

    static ShadingState createRefractionBounceState(ShadingState shadingState, Ray ray, int n) {
        ShadingState shadingState2 = new ShadingState(shadingState, shadingState.istate, ray, n, 2, false);
        ++shadingState2.refractionDepth;
        return shadingState2;
    }

    static ShadingState createFinalGatherState(ShadingState shadingState, Ray ray, int n) {
        ShadingState shadingState2 = new ShadingState(shadingState, shadingState.istate, ray, n, 2, false);
        ++shadingState2.diffuseDepth;
        shadingState2.includeLights = false;
        shadingState2.includeSpecular = false;
        return shadingState2;
    }

    private ShadingState(ShadingState shadingState, IntersectionState intersectionState, Ray ray, int n, int n2, boolean bl) {
        this.r = ray;
        this.istate = intersectionState;
        this.i = n;
        this.d = n2;
        this.time = intersectionState.time;
        this.instance = intersectionState.instance;
        this.primitiveID = intersectionState.id;
        this.hitU = intersectionState.u;
        this.hitV = intersectionState.v;
        this.hitW = intersectionState.w;
        this.o2w = this.instance.getObjectToWorld(this.time);
        this.w2o = this.instance.getWorldToObject(this.time);
        if (shadingState == null) {
            this.diffuseDepth = 0;
            this.reflectionDepth = 0;
            this.refractionDepth = 0;
        } else {
            this.diffuseDepth = shadingState.diffuseDepth;
            this.reflectionDepth = shadingState.reflectionDepth;
            this.refractionDepth = shadingState.refractionDepth;
            this.shadowDepth = shadingState.shadowDepth;
            this.server = shadingState.server;
            this.map = shadingState.map;
            this.rx = shadingState.rx;
            this.ry = shadingState.ry;
            this.i += shadingState.i;
            this.d += shadingState.d;
        }
        this.behind = false;
        this.cosND = Float.NaN;
        this.includeSpecular = true;
        this.includeLights = true;
        if (!bl) {
            this.qmcD0I = QMC.halton(this.d, this.i);
            this.qmcD1I = QMC.halton(this.d + 1, this.i);
        }
        this.result = null;
        this.bias = 0.001f;
    }

    final void setRay(Ray ray) {
        this.r = ray;
    }

    public final void init() {
        this.p = new Point3();
        this.n = new Vector3();
        this.tex = new Point2();
        this.ng = new Vector3();
        this.basis = null;
    }

    public final Color shade() {
        return this.server.shadeHit(this);
    }

    final void correctShadingNormal() {
        if (Vector3.dot(this.n, this.ng) < 0.0f) {
            this.n.negate();
            this.basis.flipW();
        }
    }

    public final void faceforward() {
        if (!(this.r.dot(this.ng) < 0.0f)) {
            this.ng.negate();
            this.n.negate();
            this.basis.flipW();
            this.behind = true;
        }
        this.cosND = Math.max(-this.r.dot(this.n), 0.0f);
        this.bias = Math.abs(this.ng.x) > Math.abs(this.ng.y) && Math.abs(this.ng.x) > Math.abs(this.ng.z) ? Math.max(this.bias, 25.0f * Math.ulp(Math.abs(this.p.x))) : (Math.abs(this.ng.y) > Math.abs(this.ng.z) ? Math.max(this.bias, 25.0f * Math.ulp(Math.abs(this.p.y))) : Math.max(this.bias, 25.0f * Math.ulp(Math.abs(this.p.z))));
        this.p.x += this.bias * this.ng.x;
        this.p.y += this.bias * this.ng.y;
        this.p.z += this.bias * this.ng.z;
    }

    public final float getRasterX() {
        return this.rx;
    }

    public final float getRasterY() {
        return this.ry;
    }

    public final float getCosND() {
        return this.cosND;
    }

    public final boolean isBehind() {
        return this.behind;
    }

    final IntersectionState getIntersectionState() {
        return this.istate;
    }

    public final float getU() {
        return this.hitU;
    }

    public final float getV() {
        return this.hitV;
    }

    public final float getW() {
        return this.hitW;
    }

    public final Instance getInstance() {
        return this.instance;
    }

    public final int getPrimitiveID() {
        return this.primitiveID;
    }

    public Point3 transformObjectToWorld(Point3 point3) {
        return this.o2w == null ? new Point3(point3) : this.o2w.transformP(point3);
    }

    public Point3 transformWorldToObject(Point3 point3) {
        return this.w2o == null ? new Point3(point3) : this.w2o.transformP(point3);
    }

    public Vector3 transformNormalObjectToWorld(Vector3 vector3) {
        return this.o2w == null ? new Vector3(vector3) : this.w2o.transformTransposeV(vector3);
    }

    public Vector3 transformNormalWorldToObject(Vector3 vector3) {
        return this.o2w == null ? new Vector3(vector3) : this.o2w.transformTransposeV(vector3);
    }

    public Vector3 transformVectorObjectToWorld(Vector3 vector3) {
        return this.o2w == null ? new Vector3(vector3) : this.o2w.transformV(vector3);
    }

    public Vector3 transformVectorWorldToObject(Vector3 vector3) {
        return this.o2w == null ? new Vector3(vector3) : this.w2o.transformV(vector3);
    }

    final void setResult(Color color) {
        this.result = color;
    }

    public final Color getResult() {
        return this.result;
    }

    final LightServer getLightServer() {
        return this.server;
    }

    public final void addSample(LightSample lightSample) {
        lightSample.next = this.lightSample;
        this.lightSample = lightSample;
    }

    public final double getRandom(int n, int n2) {
        switch (n2) {
            case 0: {
                return QMC.mod1(this.qmcD0I + QMC.halton(0, n));
            }
            case 1: {
                return QMC.mod1(this.qmcD1I + QMC.halton(1, n));
            }
        }
        return QMC.mod1(QMC.halton(this.d + n2, this.i) + QMC.halton(n2, n));
    }

    public final double getRandom(int n, int n2, int n3) {
        switch (n2) {
            case 0: {
                return QMC.mod1(this.qmcD0I + (double)n / (double)n3);
            }
            case 1: {
                return QMC.mod1(this.qmcD1I + QMC.halton(0, n));
            }
        }
        return QMC.mod1(QMC.halton(this.d + n2, this.i) + QMC.halton(n2 - 1, n));
    }

    public final boolean includeLights() {
        return this.includeLights;
    }

    public final boolean includeSpecular() {
        return this.includeSpecular;
    }

    public final Shader getShader() {
        return this.shader;
    }

    public final void setShader(Shader shader) {
        this.shader = shader;
    }

    final Modifier getModifier() {
        return this.modifier;
    }

    public final void setModifier(Modifier modifier) {
        this.modifier = modifier;
    }

    public final int getDepth() {
        return this.diffuseDepth + this.reflectionDepth + this.refractionDepth;
    }

    public final int getDiffuseDepth() {
        return this.diffuseDepth;
    }

    public final int getReflectionDepth() {
        return this.reflectionDepth;
    }

    public final int getRefractionDepth() {
        return this.refractionDepth;
    }

    public final Point3 getPoint() {
        return this.p;
    }

    public final Vector3 getNormal() {
        return this.n;
    }

    public final Point2 getUV() {
        return this.tex;
    }

    public final Vector3 getGeoNormal() {
        return this.ng;
    }

    public final OrthoNormalBasis getBasis() {
        return this.basis;
    }

    public final void setBasis(OrthoNormalBasis orthoNormalBasis) {
        this.basis = orthoNormalBasis;
    }

    public final Ray getRay() {
        return this.r;
    }

    public final Matrix4 getCameraToWorld() {
        Camera camera = this.server.getScene().getCamera();
        return camera != null ? camera.getCameraToWorld(this.time) : Matrix4.IDENTITY;
    }

    public final Matrix4 getWorldToCamera() {
        Camera camera = this.server.getScene().getCamera();
        return camera != null ? camera.getWorldToCamera(this.time) : Matrix4.IDENTITY;
    }

    public final boolean getTrianglePoints(Point3[] point3Array) {
        PrimitiveList primitiveList = this.instance.getGeometry().getPrimitiveList();
        if (primitiveList instanceof TriangleMesh) {
            TriangleMesh triangleMesh = (TriangleMesh)primitiveList;
            point3Array[0] = new Point3();
            triangleMesh.getPoint(this.primitiveID, 0, point3Array[0]);
            point3Array[1] = new Point3();
            triangleMesh.getPoint(this.primitiveID, 1, point3Array[1]);
            point3Array[2] = new Point3();
            triangleMesh.getPoint(this.primitiveID, 2, point3Array[2]);
            return true;
        }
        return false;
    }

    public final void initLightSamples() {
        this.server.initLightSamples(this);
    }

    public final void initCausticSamples() {
        this.server.initCausticSamples(this);
    }

    public final Color traceGlossy(Ray ray, int n) {
        return this.server.traceGlossy(this, ray, n);
    }

    public final Color traceReflection(Ray ray, int n) {
        return this.server.traceReflection(this, ray, n);
    }

    public final Color traceRefraction(Ray ray, int n) {
        ray.ox -= 2.0f * this.bias * this.ng.x;
        ray.oy -= 2.0f * this.bias * this.ng.y;
        ray.oz -= 2.0f * this.bias * this.ng.z;
        return this.server.traceRefraction(this, ray, n);
    }

    public final Color traceTransparency() {
        return this.traceRefraction(new Ray(this.p.x, this.p.y, this.p.z, this.r.dx, this.r.dy, this.r.dz), 0);
    }

    public final Color traceShadow(Ray ray) {
        return this.server.traceShadow(ray, this);
    }

    public final void storePhoton(Vector3 vector3, Color color, Color color2) {
        this.map.store(this, vector3, color, color2);
    }

    public final void traceReflectionPhoton(Ray ray, Color color) {
        if (this.map.allowReflectionBounced()) {
            this.server.traceReflectionPhoton(this, ray, color);
        }
    }

    public final void traceRefractionPhoton(Ray ray, Color color) {
        if (this.map.allowRefractionBounced()) {
            ray.ox -= 0.002f * this.ng.x;
            ray.oy -= 0.002f * this.ng.y;
            ray.oz -= 0.002f * this.ng.z;
            this.server.traceRefractionPhoton(this, ray, color);
        }
    }

    public final void traceDiffusePhoton(Ray ray, Color color) {
        if (this.map.allowDiffuseBounced()) {
            this.server.traceDiffusePhoton(this, ray, color);
        }
    }

    public final Color getGlobalRadiance() {
        return this.server.getGlobalRadiance(this);
    }

    public final Color getIrradiance(Color color) {
        return this.server.getIrradiance(this, color);
    }

    public final ShadingState traceFinalGather(Ray ray, int n) {
        return this.server.traceFinalGather(this, ray, n);
    }

    public final Color occlusion(int n, float f) {
        return this.occlusion(n, f, Color.WHITE, Color.BLACK);
    }

    public final Color occlusion(int n, float f, Color color, Color color2) {
        if (this.n == null) {
            return color;
        }
        this.faceforward();
        OrthoNormalBasis orthoNormalBasis = this.getBasis();
        Vector3 vector3 = new Vector3();
        Color color3 = Color.black();
        for (int i = 0; i < n; ++i) {
            float f2 = (float)this.getRandom(i, 0, n);
            float f3 = (float)this.getRandom(i, 1, n);
            float f4 = (float)(Math.PI * 2 * (double)f2);
            float f5 = (float)Math.cos(f4);
            float f6 = (float)Math.sin(f4);
            float f7 = (float)Math.sqrt(f3);
            float f8 = (float)Math.sqrt(1.0f - f3);
            vector3.x = f5 * f7;
            vector3.y = f6 * f7;
            vector3.z = f8;
            orthoNormalBasis.transform(vector3);
            Ray ray = new Ray(this.p, vector3);
            ray.setMax(f);
            color3.add(Color.blend(color, color2, this.traceShadow(ray)));
        }
        return color3.mul(1.0f / (float)n);
    }

    public final Color diffuse(Color color) {
        Color color2 = Color.black();
        if (color.isBlack()) {
            return color2;
        }
        for (LightSample lightSample : this) {
            color2.madd(lightSample.dot(this.n), lightSample.getDiffuseRadiance());
        }
        color2.add(this.getIrradiance(color));
        return color2.mul(color).mul(0.31830987f);
    }

    public final Color specularPhong(Color color, float f, int n) {
        float f2;
        Color color2 = Color.black();
        if (!this.includeSpecular || color.isBlack()) {
            return color2;
        }
        float f3 = 2.0f * this.cosND;
        Vector3 vector3 = new Vector3();
        vector3.x = f3 * this.n.x + this.r.dx;
        vector3.y = f3 * this.n.y + this.r.dy;
        vector3.z = f3 * this.n.z + this.r.dz;
        for (Object object : this) {
            f2 = ((LightSample)object).dot(this.n);
            float f4 = ((LightSample)object).dot(vector3);
            if (!(f4 > 0.0f)) continue;
            color2.madd(f2 * (float)Math.pow(f4, f), ((LightSample)object).getSpecularRadiance());
        }
        if (n > 0) {
            Object object;
            int n2 = this.getDepth() == 0 ? n : 1;
            object = OrthoNormalBasis.makeFromW(vector3);
            f2 = (float)Math.PI * 2 / (f + 1.0f) / (float)n2;
            for (int i = 0; i < n2; ++i) {
                double d = this.getRandom(i, 0, n2);
                double d2 = this.getRandom(i, 1, n2);
                double d3 = Math.PI * 2 * d;
                double d4 = (float)Math.pow(d2, 1.0f / (f + 1.0f));
                double d5 = (float)Math.sqrt(1.0 - d4 * d4);
                Vector3 vector32 = new Vector3((float)(Math.cos(d3) * d5), (float)(Math.sin(d3) * d5), (float)d4);
                float f5 = Vector3.dot(vector32 = ((OrthoNormalBasis)object).transform(vector32, new Vector3()), this.n);
                if (!(f5 > 0.0f)) continue;
                color2.madd(f5 * f2, this.traceGlossy(new Ray(this.p, vector32), i));
            }
        }
        color2.mul(color).mul((f + 2.0f) / ((float)Math.PI * 2));
        return color2;
    }

    @Override
    public Iterator<LightSample> iterator() {
        return new LightSampleIterator(this.lightSample);
    }

    static ShadingState createShadowState(ShadingState shadingState, Ray ray) {
        ShadingState shadingState2 = new ShadingState(shadingState, shadingState.istate, ray, shadingState.i, shadingState.d, true);
        ++shadingState2.shadowDepth;
        return shadingState2;
    }

    public final int getShadowDepth() {
        return this.shadowDepth;
    }

    public Color traceTransparentShadow(float f) {
        Ray ray = new Ray(this.r.ox, this.r.oy, this.r.oz, this.r.dx, this.r.dy, this.r.dz);
        ray.setMinMax(this.r.getMax(), f);
        return this.traceShadow(ray);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LightSampleIterator
    implements Iterator<LightSample> {
        private LightSample current;

        LightSampleIterator(LightSample lightSample) {
            this.current = lightSample;
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        @Override
        public LightSample next() {
            LightSample lightSample = this.current;
            this.current = this.current.next;
            return lightSample;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

