/*
 * Decompiled with CFR 0.152.
 */
package org.sunflow.image;

import org.sunflow.image.Color;
import org.sunflow.math.MathUtils;

public final class ColorEncoder {
    public static final Color[] unpremult(Color[] colorArray, float[] fArray) {
        Color[] colorArray2 = new Color[colorArray.length];
        for (int i = 0; i < colorArray.length; ++i) {
            colorArray2[i] = colorArray[i].copy().mul(1.0f / fArray[i]);
        }
        return colorArray2;
    }

    public static final Color[] unlinearize(Color[] colorArray) {
        Color[] colorArray2 = new Color[colorArray.length];
        for (int i = 0; i < colorArray.length; ++i) {
            colorArray2[i] = colorArray[i].copy().toNonLinear();
        }
        return colorArray2;
    }

    public static final byte[] quantizeRGB8(Color[] colorArray) {
        byte[] byArray = new byte[colorArray.length * 3];
        int n = 0;
        int n2 = 0;
        while (n < colorArray.length) {
            float[] fArray = colorArray[n].getRGB();
            byArray[n2 + 0] = (byte)MathUtils.clamp((int)(fArray[0] * 255.0f + 0.5f), 0, 255);
            byArray[n2 + 1] = (byte)MathUtils.clamp((int)(fArray[1] * 255.0f + 0.5f), 0, 255);
            byArray[n2 + 2] = (byte)MathUtils.clamp((int)(fArray[2] * 255.0f + 0.5f), 0, 255);
            ++n;
            n2 += 3;
        }
        return byArray;
    }

    public static final byte[] quantizeRGBA8(Color[] colorArray, float[] fArray) {
        byte[] byArray = new byte[colorArray.length * 4];
        int n = 0;
        int n2 = 0;
        while (n < colorArray.length) {
            float[] fArray2 = colorArray[n].getRGB();
            byArray[n2 + 0] = (byte)MathUtils.clamp((int)(fArray2[0] * 255.0f + 0.5f), 0, 255);
            byArray[n2 + 1] = (byte)MathUtils.clamp((int)(fArray2[1] * 255.0f + 0.5f), 0, 255);
            byArray[n2 + 2] = (byte)MathUtils.clamp((int)(fArray2[2] * 255.0f + 0.5f), 0, 255);
            byArray[n2 + 3] = (byte)MathUtils.clamp((int)(fArray[n] * 255.0f + 0.5f), 0, 255);
            ++n;
            n2 += 4;
        }
        return byArray;
    }

    public static final int[] encodeRGBE(Color[] colorArray) {
        int[] nArray = new int[colorArray.length];
        for (int i = 0; i < colorArray.length; ++i) {
            nArray[i] = colorArray[i].toRGBE();
        }
        return nArray;
    }
}

