/*
 * Decompiled with CFR 0.152.
 */
package org.sunflow.math;

import org.sunflow.system.UI;

public final class QMC {
    public static final int MAX_SIGMA_ORDER = 15;
    private static final int NUM = 128;
    private static final int[][] SIGMA;
    private static final int[] PRIMES;
    private static final int[] FIBONACCI;
    private static final double[] FIBONACCI_INV;
    private static final double[] KOROBOV;

    private static final int nextPrime(int n) {
        n = n + (n & 1) + 1;
        while (true) {
            int n2 = 3;
            boolean bl = true;
            while (bl && n2 * n2 <= n) {
                bl = n % n2 != 0;
                n2 += 2;
            }
            if (bl) {
                return n;
            }
            n += 2;
        }
    }

    private QMC() {
    }

    public static double riVDC(int n, int n2) {
        n = n << 16 | n >>> 16;
        n = (n & 0xFF00FF) << 8 | (n & 0xFF00FF00) >>> 8;
        n = (n & 0xF0F0F0F) << 4 | (n & 0xF0F0F0F0) >>> 4;
        n = (n & 0x33333333) << 2 | (n & 0xCCCCCCCC) >>> 2;
        n = (n & 0x55555555) << 1 | (n & 0xAAAAAAAA) >>> 1;
        return (double)((long)(n ^= n2) & 0xFFFFFFFFL) / 4.294967296E9;
    }

    public static double riS(int n, int n2) {
        int n3 = Integer.MIN_VALUE;
        while (n != 0) {
            if ((n & 1) != 0) {
                n2 ^= n3;
            }
            n >>>= 1;
            n3 ^= n3 >>> 1;
        }
        return (double)((long)n2 & 0xFFFFFFFFL) / 4.294967296E9;
    }

    public static double riLP(int n, int n2) {
        int n3 = Integer.MIN_VALUE;
        while (n != 0) {
            if ((n & 1) != 0) {
                n2 ^= n3;
            }
            n >>>= 1;
            n3 |= n3 >>> 1;
        }
        return (double)((long)n2 & 0xFFFFFFFFL) / 4.294967296E9;
    }

    public static final double halton(int n, int n2) {
        double d;
        switch (n) {
            case 0: {
                n2 = n2 << 16 | n2 >>> 16;
                n2 = (n2 & 0xFF00FF) << 8 | (n2 & 0xFF00FF00) >>> 8;
                n2 = (n2 & 0xF0F0F0F) << 4 | (n2 & 0xF0F0F0F0) >>> 4;
                n2 = (n2 & 0x33333333) << 2 | (n2 & 0xCCCCCCCC) >>> 2;
                n2 = (n2 & 0x55555555) << 1 | (n2 & 0xAAAAAAAA) >>> 1;
                return (double)((long)n2 & 0xFFFFFFFFL) / 4.294967296E9;
            }
            case 1: {
                double d2;
                double d3 = 0.0;
                double d4 = d2 = 0.3333333333333333;
                for (int i = n2; i != 0; i /= 3) {
                    d3 += (double)(i % 3) * d4;
                    d4 *= d2;
                }
                return d3;
            }
        }
        int n3 = PRIMES[n];
        int[] nArray = SIGMA[n];
        double d5 = 0.0;
        double d6 = d = 1.0 / (double)n3;
        for (int i = n2; i != 0; i /= n3) {
            d5 += (double)nArray[i % n3] * d6;
            d6 *= d;
        }
        return d5;
    }

    public static final double mod1(double d) {
        return d - (double)((int)d);
    }

    public static final int sigma(int n, int n2) {
        assert (n2 > 0 && n2 < 32);
        assert (n >= 0 && n < 1 << n2);
        n = n << 16 | n >>> 16;
        n = (n & 0xFF00FF) << 8 | (n & 0xFF00FF00) >>> 8;
        n = (n & 0xF0F0F0F) << 4 | (n & 0xF0F0F0F0) >>> 4;
        n = (n & 0x33333333) << 2 | (n & 0xCCCCCCCC) >>> 2;
        n = (n & 0x55555555) << 1 | (n & 0xAAAAAAAA) >>> 1;
        return n >>> 32 - n2;
    }

    public static final int getFibonacciRank(int n) {
        int n2 = 3;
        while (FIBONACCI[n2] <= n) {
            ++n2;
        }
        return n2 - 1;
    }

    public static final int fibonacci(int n) {
        return FIBONACCI[n];
    }

    public static final double fibonacciLattice(int n, int n2, int n3) {
        return n3 == 0 ? (double)n2 * FIBONACCI_INV[n] : QMC.mod1((double)(n2 * FIBONACCI[n - 1]) * FIBONACCI_INV[n]);
    }

    public static final double reducedCPRotation(int n, int n2, double d, double d2) {
        int n3 = FIBONACCI[2 * (n - 1 >> 2) + 1];
        int n4 = FIBONACCI[2 * (n + 1 >> 2)];
        if (n2 == 1) {
            n3 = n3 * FIBONACCI[n - 1] % FIBONACCI[n];
            n4 = n4 * FIBONACCI[n - 1] % FIBONACCI[n] - FIBONACCI[n];
        }
        return (d * (double)n3 + d2 * (double)n4) * FIBONACCI_INV[n];
    }

    public static final double korobovLattice(int n, int n2, int n3) {
        return QMC.mod1((double)n2 * KOROBOV[n3] / (double)(1 << n));
    }

    static {
        int n;
        SIGMA = new int[128][];
        PRIMES = new int[128];
        FIBONACCI = new int[47];
        FIBONACCI_INV = new double[FIBONACCI.length];
        KOROBOV = new double[128];
        UI.printInfo(UI.Module.QMC, "Initializing Faure scrambling tables ...", new Object[0]);
        QMC.PRIMES[0] = 2;
        for (int i = 1; i < PRIMES.length; ++i) {
            QMC.PRIMES[i] = QMC.nextPrime(PRIMES[i - 1]);
        }
        int[][] nArrayArray = new int[PRIMES[PRIMES.length - 1] + 1][];
        nArrayArray[2] = new int[2];
        nArrayArray[2][0] = 0;
        nArrayArray[2][1] = 1;
        for (n = 3; n <= PRIMES[PRIMES.length - 1]; ++n) {
            int n2;
            int n3;
            int[] nArray;
            nArrayArray[n] = new int[n];
            if ((n & 1) == 0) {
                nArray = nArrayArray[n >> 1];
                for (n3 = 0; n3 < nArray.length; ++n3) {
                    nArrayArray[n][n3] = 2 * nArray[n3];
                }
                for (n3 = 0; n3 < nArray.length; ++n3) {
                    nArrayArray[n][nArray.length + n3] = 2 * nArray[n3] + 1;
                }
                continue;
            }
            nArray = nArrayArray[n - 1];
            n3 = n - 1 >> 1;
            for (n2 = 0; n2 < n3; ++n2) {
                nArrayArray[n][n2] = nArray[n2] + (nArray[n2] >= n3 ? 1 : 0);
            }
            nArrayArray[n][n3] = n3;
            for (n2 = 0; n2 < n3; ++n2) {
                nArrayArray[n][n3 + n2 + 1] = nArray[n2 + n3] + (nArray[n2 + n3] >= n3 ? 1 : 0);
            }
        }
        for (n = 0; n < PRIMES.length; ++n) {
            int n4 = PRIMES[n];
            QMC.SIGMA[n] = new int[n4];
            System.arraycopy(nArrayArray[n4], 0, SIGMA[n], 0, n4);
        }
        UI.printInfo(UI.Module.QMC, "Initializing lattice tables ...", new Object[0]);
        QMC.FIBONACCI[0] = 0;
        QMC.FIBONACCI[1] = 1;
        for (n = 2; n < FIBONACCI.length; ++n) {
            QMC.FIBONACCI[n] = FIBONACCI[n - 1] + FIBONACCI[n - 2];
            QMC.FIBONACCI_INV[n] = 1.0 / (double)FIBONACCI[n];
        }
        QMC.KOROBOV[0] = 1.0;
        for (n = 1; n < KOROBOV.length; ++n) {
            QMC.KOROBOV[n] = 203.0 * KOROBOV[n - 1];
        }
    }
}

