/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.contrib;

import CH.ifa.draw.contrib.PolygonFigure;
import CH.ifa.draw.figures.PolyLineHandle;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.framework.Locator;
import CH.ifa.draw.standard.AbstractHandle;
import CH.ifa.draw.standard.SingleFigureEnumerator;
import CH.ifa.draw.util.Undoable;
import java.awt.Point;

public class PolygonHandle
extends AbstractHandle {
    private Locator fLocator;
    private int fIndex;

    public PolygonHandle(PolygonFigure owner, Locator l, int index) {
        super(owner);
        this.fLocator = l;
        this.fIndex = index;
    }

    public void invokeStart(int x, int y, DrawingView view) {
        this.setUndoActivity(this.createUndoActivity(view, this.fIndex));
        this.getUndoActivity().setAffectedFigures(new SingleFigureEnumerator(this.owner()));
        ((UndoActivity)this.getUndoActivity()).setOldPoint(new Point(x, y));
    }

    public void invokeStep(int x, int y, int anchorX, int anchorY, DrawingView view) {
        int index = ((PolyLineHandle.UndoActivity)this.getUndoActivity()).getPointIndex();
        this.myOwner().setPointAt(new Point(x, y), index);
    }

    public void invokeEnd(int x, int y, int anchorX, int anchorY, DrawingView view) {
        this.myOwner().smoothPoints();
        if (x == anchorX && y == anchorY) {
            this.setUndoActivity(null);
        }
    }

    public Point locate() {
        return this.fLocator.locate(this.owner());
    }

    private PolygonFigure myOwner() {
        return (PolygonFigure)this.owner();
    }

    protected Undoable createUndoActivity(DrawingView newView, int newPointIndex) {
        return new UndoActivity(newView, newPointIndex);
    }

    public static class UndoActivity
    extends PolyLineHandle.UndoActivity {
        public UndoActivity(DrawingView newView, int newPointIndex) {
            super(newView, newPointIndex);
        }

        protected boolean movePointToOldLocation() {
            FigureEnumeration fe = this.getAffectedFigures();
            if (!fe.hasMoreElements()) {
                return false;
            }
            PolygonFigure figure = (PolygonFigure)fe.nextFigure();
            Point backupPoint = figure.pointAt(this.getPointIndex());
            figure.setPointAt(this.getOldPoint(), this.getPointIndex());
            figure.smoothPoints();
            this.setOldPoint(backupPoint);
            return true;
        }
    }
}

