/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.figures;

import CH.ifa.draw.figures.ImageFigure;
import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.standard.AbstractCommand;
import CH.ifa.draw.util.Iconkit;
import CH.ifa.draw.util.Undoable;
import CH.ifa.draw.util.UndoableAdapter;
import java.awt.Component;
import java.awt.Image;
import java.lang.ref.WeakReference;

public class InsertImageCommand
extends AbstractCommand {
    private String myImageName;

    public InsertImageCommand(String name, String newImageName, DrawingEditor newDrawingEditor) {
        super(name, newDrawingEditor);
        this.myImageName = newImageName;
    }

    public void execute() {
        super.execute();
        this.setUndoActivity(this.createUndoActivity());
        ((UndoActivity)this.getUndoActivity()).insertImage();
        this.view().checkDamage();
    }

    protected Undoable createUndoActivity() {
        return new UndoActivity(this.view(), this.myImageName);
    }

    public class UndoActivity
    extends UndoableAdapter {
        WeakReference myAffectedImageFigure;
        private String myAffectedImageName;

        UndoActivity(DrawingView newDrawingView, String newAffectedImageName) {
            super(newDrawingView);
            this.myAffectedImageName = newAffectedImageName;
            this.setUndoable(true);
            this.setRedoable(true);
        }

        protected void setImageFigure(ImageFigure newImageFigure) {
            this.myAffectedImageFigure = new WeakReference<ImageFigure>(newImageFigure);
        }

        protected ImageFigure getImageFigure() {
            if (this.myAffectedImageFigure == null || this.myAffectedImageFigure.get() == null) {
                Image image = Iconkit.instance().registerAndLoadImage((Component)((Object)this.getDrawingView()), this.myAffectedImageName);
                this.setImageFigure(new ImageFigure(image, this.myAffectedImageName, this.getDrawingView().lastClick()));
            }
            return (ImageFigure)this.myAffectedImageFigure.get();
        }

        public boolean undo() {
            if (super.undo()) {
                this.getDrawingView().clearSelection();
                this.getDrawingView().drawing().orphan(this.getImageFigure());
                return true;
            }
            return false;
        }

        public boolean redo() {
            if (this.isRedoable()) {
                this.insertImage();
                return true;
            }
            return false;
        }

        protected void insertImage() {
            this.getDrawingView().add(this.getImageFigure());
            this.getDrawingView().clearSelection();
            this.getDrawingView().addToSelection(this.getImageFigure());
        }
    }
}

