/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.util;

import CH.ifa.draw.util.Undoable;
import java.util.Vector;

public class UndoManager {
    public static final int DEFAULT_BUFFER_SIZE = 20;
    private Vector redoStack;
    private Vector undoStack;
    private int maxStackCapacity;

    public UndoManager() {
        this(20);
    }

    public UndoManager(int newUndoStackSize) {
        this.maxStackCapacity = newUndoStackSize;
        this.undoStack = new Vector(this.maxStackCapacity);
        this.redoStack = new Vector(this.maxStackCapacity);
    }

    public void pushUndo(Undoable undoActivity) {
        if (undoActivity.isUndoable()) {
            if (this.getUndoSize() >= this.maxStackCapacity) {
                this.undoStack.removeElementAt(0);
            }
            this.undoStack.addElement(undoActivity);
        } else {
            this.undoStack = new Vector(this.maxStackCapacity);
        }
    }

    public void pushRedo(Undoable redoActivity) {
        if (redoActivity.isRedoable()) {
            if (this.getRedoSize() >= this.maxStackCapacity) {
                this.redoStack.removeElementAt(0);
            }
            if (this.getRedoSize() == 0 || this.peekRedo() != redoActivity) {
                this.redoStack.addElement(redoActivity);
            }
        } else {
            this.redoStack = new Vector(this.maxStackCapacity);
        }
    }

    public boolean isUndoable() {
        if (this.getUndoSize() > 0) {
            return ((Undoable)this.undoStack.lastElement()).isUndoable();
        }
        return false;
    }

    public boolean isRedoable() {
        if (this.getRedoSize() > 0) {
            return ((Undoable)this.redoStack.lastElement()).isRedoable();
        }
        return false;
    }

    protected Undoable peekUndo() {
        if (this.getUndoSize() > 0) {
            return (Undoable)this.undoStack.lastElement();
        }
        return null;
    }

    protected Undoable peekRedo() {
        if (this.getRedoSize() > 0) {
            return (Undoable)this.redoStack.lastElement();
        }
        return null;
    }

    public int getUndoSize() {
        return this.undoStack.size();
    }

    public int getRedoSize() {
        return this.redoStack.size();
    }

    public Undoable popUndo() {
        Undoable lastUndoable = this.peekUndo();
        this.undoStack.removeElementAt(this.getUndoSize() - 1);
        return lastUndoable;
    }

    public Undoable popRedo() {
        Undoable lastUndoable = this.peekRedo();
        this.redoStack.removeElementAt(this.getRedoSize() - 1);
        return lastUndoable;
    }

    public void clearUndos() {
        this.clearStack(this.undoStack);
    }

    public void clearRedos() {
        this.clearStack(this.redoStack);
    }

    protected void clearStack(Vector clearStack) {
        clearStack.removeAllElements();
    }
}

